#ifndef NOATUNPREF_H
#define NOATUNPREF_H

#include <kdialogbase.h>
#include <qevent.h>
#include <qframe.h>
#include <qlist.h>

#include <noatunapp.h>


#define NoatunPrefAdd(dparent, type, shortname, longname) \
	(napp->preferencesBox()->_add(new type(napp->preferencesBox()->_addModule(shortname, longname))), napp->preferencesBox()->_last()->_destroyParent(dparent), (type*)napp->preferencesBox()->_last())

		
class CModule;

class NoatunPreferences : public KDialogBase
{
Q_OBJECT
public:
	NoatunPreferences(QWidget *parent);

public:
	QFrame *_addModule(const QString &shortTitle, const QString &longTitle);
	void _add(CModule*);
	void _remove(CModule*);
	CModule *_last() {return modules.last(); }

	virtual void show();
protected:
	virtual void slotOk();
	virtual void slotApply();

private:
	QList<CModule> modules;
	
signals:
	// Sent whenever the dialog is closed, part of win position saving
	void dialogClosed(void);
};

class CModule : public QFrame
{
Q_OBJECT

public:
	CModule(QWidget *parent, const char *name=0);

public:
	void _destroyParent(QObject *p=0);
	
public slots:
	/**
	 * save all your options, and apply them
	 **/
	virtual void save() {}
	/**
	 * reload all options (e.g., read config files)
	 **/
	virtual void reopen() {}
private slots:
	void _destroyParentSlot();
};


#endif // NOATUNPREF_H
