/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSMODULES_H
#define ARTSMODULES_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"
#include "artsmidi.h"

namespace Arts {
class MidiChannel;
class ObjectCache;
class MidiReleaseHelper;
class Synth_CAPTURE_WAV;
class Synth_NIL;
class Synth_DEBUG;
class Synth_DATA;
class Synth_ATAN_SATURATE;
class Synth_BRICKWALL_LIMITER;
class Synth_AUTOPANNER;
class Synth_DELAY;
class Synth_CDELAY;
class Synth_FM_SOURCE;
class Synth_TREMOLO;
class Synth_FX_CFLANGER;
class Synth_NOISE;
class Synth_WAVE_TRI;
class Synth_WAVE_SQUARE;
class Synth_WAVE_PULSE;
class Synth_WAVE_SOFTSAW;
class Synth_ENVELOPE_ADSR;
class Synth_SHELVE_CUTOFF;
class Synth_XFADE;
class Synth_MIDI_TEST;
class Synth_MIDI_DEBUG;
class Synth_FREEVERB;
class Synth_STD_EQUALIZER;
class Synth_RC;
class Synth_MOOG_VCF;
class Synth_PSCALE;
class Synth_SEQUENCE;
class Synth_PITCH_SHIFT;
class Interface_MIDI_NOTE;
class Synth_STRUCT_KILL;

class MidiChannel_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static MidiChannel_base *_create(const std::string& subClass = "Arts::MidiChannel");
	static MidiChannel_base *_fromString(std::string objectref);
	static MidiChannel_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiChannel_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::TimeStamp time() = 0;
	virtual void noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume) = 0;
	virtual void noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note) = 0;
	virtual void noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume) = 0;
	virtual void noteOff(Arts::mcopbyte channel, Arts::mcopbyte note) = 0;
};

class MidiChannel_stub : virtual public MidiChannel_base, virtual public Arts::Object_stub {
protected:
	MidiChannel_stub();

public:
	MidiChannel_stub(Arts::Connection *connection, long objectID);

	Arts::TimeStamp time();
	void noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	void noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note);
	void noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	void noteOff(Arts::mcopbyte channel, Arts::mcopbyte note);
};

class MidiChannel_skel : virtual public MidiChannel_base, virtual public Arts::Object_skel {
public:
	MidiChannel_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiChannel : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiChannel_base *_cache;
	inline MidiChannel_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiChannel_base *)_pool->base->_cast(MidiChannel_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiChannel(MidiChannel_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiChannel_base _base_class;

	inline MidiChannel() : Arts::Object(_Creator), _cache(0) {}
	inline MidiChannel(const Arts::SubClass& s) :
		Arts::Object(MidiChannel_base::_create(s.string())), _cache(0) {}
	inline MidiChannel(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiChannel_base::_fromString(r.string())):(MidiChannel_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiChannel(const Arts::DynamicCast& c) : Arts::Object(MidiChannel_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiChannel(const MidiChannel& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiChannel(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiChannel null() {return MidiChannel((MidiChannel_base*)0);}
	inline static MidiChannel _from_base(MidiChannel_base* b) {return MidiChannel(b);}
	inline MidiChannel& operator=(const MidiChannel& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline MidiChannel_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::TimeStamp time();
	inline void noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	inline void noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note);
	inline void noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	inline void noteOff(Arts::mcopbyte channel, Arts::mcopbyte note);
};

class ObjectCache_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static ObjectCache_base *_create(const std::string& subClass = "Arts::ObjectCache");
	static ObjectCache_base *_fromString(std::string objectref);
	static ObjectCache_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline ObjectCache_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void put(Arts::Object obj, const std::string& name) = 0;
	virtual Arts::Object get(const std::string& name) = 0;
};

class ObjectCache_stub : virtual public ObjectCache_base, virtual public Arts::Object_stub {
protected:
	ObjectCache_stub();

public:
	ObjectCache_stub(Arts::Connection *connection, long objectID);

	void put(Arts::Object obj, const std::string& name);
	Arts::Object get(const std::string& name);
};

class ObjectCache_skel : virtual public ObjectCache_base, virtual public Arts::Object_skel {
public:
	ObjectCache_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class ObjectCache : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ObjectCache_base *_cache;
	inline ObjectCache_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ObjectCache_base *)_pool->base->_cast(ObjectCache_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ObjectCache(ObjectCache_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ObjectCache_base _base_class;

	inline ObjectCache() : Arts::Object(_Creator), _cache(0) {}
	inline ObjectCache(const Arts::SubClass& s) :
		Arts::Object(ObjectCache_base::_create(s.string())), _cache(0) {}
	inline ObjectCache(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ObjectCache_base::_fromString(r.string())):(ObjectCache_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ObjectCache(const Arts::DynamicCast& c) : Arts::Object(ObjectCache_base::_fromString(c.object().toString())), _cache(0) {}
	inline ObjectCache(const ObjectCache& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ObjectCache(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ObjectCache null() {return ObjectCache((ObjectCache_base*)0);}
	inline static ObjectCache _from_base(ObjectCache_base* b) {return ObjectCache(b);}
	inline ObjectCache& operator=(const ObjectCache& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline ObjectCache_base* _base() {return _cache?_cache:_method_call();}

	inline void put(Arts::Object obj, const std::string& name);
	inline Arts::Object get(const std::string& name);
};

class MidiReleaseHelper_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static MidiReleaseHelper_base *_create(const std::string& subClass = "Arts::MidiReleaseHelper");
	static MidiReleaseHelper_base *_fromString(std::string objectref);
	static MidiReleaseHelper_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline MidiReleaseHelper_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::SynthModule voice() = 0;
	virtual void voice(Arts::SynthModule newValue) = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual Arts::ObjectCache cache() = 0;
	virtual void cache(Arts::ObjectCache newValue) = 0;
	virtual bool terminate() = 0;
};

class MidiReleaseHelper_stub : virtual public MidiReleaseHelper_base, virtual public Arts::SynthModule_stub {
protected:
	MidiReleaseHelper_stub();

public:
	MidiReleaseHelper_stub(Arts::Connection *connection, long objectID);

	Arts::SynthModule voice();
	void voice(Arts::SynthModule newValue);
	std::string name();
	void name(const std::string& newValue);
	Arts::ObjectCache cache();
	void cache(Arts::ObjectCache newValue);
	bool terminate();
};

class MidiReleaseHelper_skel : virtual public MidiReleaseHelper_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *done;                              // incoming stream

protected:
	// emitters for change notifications
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	MidiReleaseHelper_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class MidiReleaseHelper : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	MidiReleaseHelper_base *_cache;
	inline MidiReleaseHelper_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(MidiReleaseHelper_base *)_pool->base->_cast(MidiReleaseHelper_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline MidiReleaseHelper(MidiReleaseHelper_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef MidiReleaseHelper_base _base_class;

	inline MidiReleaseHelper() : Arts::Object(_Creator), _cache(0) {}
	inline MidiReleaseHelper(const Arts::SubClass& s) :
		Arts::Object(MidiReleaseHelper_base::_create(s.string())), _cache(0) {}
	inline MidiReleaseHelper(const Arts::Reference &r) :
		Arts::Object(r.isString()?(MidiReleaseHelper_base::_fromString(r.string())):(MidiReleaseHelper_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline MidiReleaseHelper(const Arts::DynamicCast& c) : Arts::Object(MidiReleaseHelper_base::_fromString(c.object().toString())), _cache(0) {}
	inline MidiReleaseHelper(const MidiReleaseHelper& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline MidiReleaseHelper(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static MidiReleaseHelper null() {return MidiReleaseHelper((MidiReleaseHelper_base*)0);}
	inline static MidiReleaseHelper _from_base(MidiReleaseHelper_base* b) {return MidiReleaseHelper(b);}
	inline MidiReleaseHelper& operator=(const MidiReleaseHelper& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline MidiReleaseHelper_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::SynthModule voice();
	inline void voice(Arts::SynthModule _newValue);
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::ObjectCache cache();
	inline void cache(Arts::ObjectCache _newValue);
	inline bool terminate();
};

class Synth_CAPTURE_WAV_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_CAPTURE_WAV_base *_create(const std::string& subClass = "Arts::Synth_CAPTURE_WAV");
	static Synth_CAPTURE_WAV_base *_fromString(std::string objectref);
	static Synth_CAPTURE_WAV_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_CAPTURE_WAV_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_CAPTURE_WAV_stub : virtual public Synth_CAPTURE_WAV_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_CAPTURE_WAV_stub();

public:
	Synth_CAPTURE_WAV_stub(Arts::Connection *connection, long objectID);

};

class Synth_CAPTURE_WAV_skel : virtual public Synth_CAPTURE_WAV_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // incoming stream
	float *right;                             // incoming stream

public:
	Synth_CAPTURE_WAV_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_CAPTURE_WAV : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_CAPTURE_WAV_base *_cache;
	inline Synth_CAPTURE_WAV_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_CAPTURE_WAV_base *)_pool->base->_cast(Synth_CAPTURE_WAV_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_CAPTURE_WAV(Synth_CAPTURE_WAV_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_CAPTURE_WAV_base _base_class;

	inline Synth_CAPTURE_WAV() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::SubClass& s) :
		Arts::Object(Synth_CAPTURE_WAV_base::_create(s.string())), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_CAPTURE_WAV_base::_fromString(r.string())):(Synth_CAPTURE_WAV_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Arts::DynamicCast& c) : Arts::Object(Synth_CAPTURE_WAV_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_CAPTURE_WAV(const Synth_CAPTURE_WAV& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_CAPTURE_WAV(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_CAPTURE_WAV null() {return Synth_CAPTURE_WAV((Synth_CAPTURE_WAV_base*)0);}
	inline static Synth_CAPTURE_WAV _from_base(Synth_CAPTURE_WAV_base* b) {return Synth_CAPTURE_WAV(b);}
	inline Synth_CAPTURE_WAV& operator=(const Synth_CAPTURE_WAV& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_CAPTURE_WAV_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_NIL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_NIL_base *_create(const std::string& subClass = "Arts::Synth_NIL");
	static Synth_NIL_base *_fromString(std::string objectref);
	static Synth_NIL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_NIL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_NIL_stub : virtual public Synth_NIL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_NIL_stub();

public:
	Synth_NIL_stub(Arts::Connection *connection, long objectID);

};

class Synth_NIL_skel : virtual public Synth_NIL_base, virtual public Arts::SynthModule_skel {
public:
	Synth_NIL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_NIL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_NIL_base *_cache;
	inline Synth_NIL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_NIL_base *)_pool->base->_cast(Synth_NIL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_NIL(Synth_NIL_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_NIL_base _base_class;

	inline Synth_NIL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_NIL(const Arts::SubClass& s) :
		Arts::Object(Synth_NIL_base::_create(s.string())), _cache(0) {}
	inline Synth_NIL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_NIL_base::_fromString(r.string())):(Synth_NIL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_NIL(const Arts::DynamicCast& c) : Arts::Object(Synth_NIL_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_NIL(const Synth_NIL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_NIL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_NIL null() {return Synth_NIL((Synth_NIL_base*)0);}
	inline static Synth_NIL _from_base(Synth_NIL_base* b) {return Synth_NIL(b);}
	inline Synth_NIL& operator=(const Synth_NIL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_NIL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_DEBUG_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DEBUG_base *_create(const std::string& subClass = "Arts::Synth_DEBUG");
	static Synth_DEBUG_base *_fromString(std::string objectref);
	static Synth_DEBUG_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_DEBUG_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string comment() = 0;
	virtual void comment(const std::string& newValue) = 0;
};

class Synth_DEBUG_stub : virtual public Synth_DEBUG_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DEBUG_stub();

public:
	Synth_DEBUG_stub(Arts::Connection *connection, long objectID);

	std::string comment();
	void comment(const std::string& newValue);
};

class Synth_DEBUG_skel : virtual public Synth_DEBUG_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream

protected:
	// emitters for change notifications
	inline void comment_changed(const std::string& newValue) {
		_emit_changed("comment_changed",newValue);
	}

public:
	Synth_DEBUG_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DEBUG : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DEBUG_base *_cache;
	inline Synth_DEBUG_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DEBUG_base *)_pool->base->_cast(Synth_DEBUG_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DEBUG(Synth_DEBUG_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DEBUG_base _base_class;

	inline Synth_DEBUG() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DEBUG(const Arts::SubClass& s) :
		Arts::Object(Synth_DEBUG_base::_create(s.string())), _cache(0) {}
	inline Synth_DEBUG(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DEBUG_base::_fromString(r.string())):(Synth_DEBUG_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DEBUG(const Arts::DynamicCast& c) : Arts::Object(Synth_DEBUG_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_DEBUG(const Synth_DEBUG& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DEBUG(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DEBUG null() {return Synth_DEBUG((Synth_DEBUG_base*)0);}
	inline static Synth_DEBUG _from_base(Synth_DEBUG_base* b) {return Synth_DEBUG(b);}
	inline Synth_DEBUG& operator=(const Synth_DEBUG& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DEBUG_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::string comment();
	inline void comment(const std::string& _newValue);
};

class Synth_DATA_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DATA_base *_create(const std::string& subClass = "Arts::Synth_DATA");
	static Synth_DATA_base *_fromString(std::string objectref);
	static Synth_DATA_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_DATA_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float value() = 0;
	virtual void value(float newValue) = 0;
};

class Synth_DATA_stub : virtual public Synth_DATA_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DATA_stub();

public:
	Synth_DATA_stub(Arts::Connection *connection, long objectID);

	float value();
	void value(float newValue);
};

class Synth_DATA_skel : virtual public Synth_DATA_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void value_changed(float newValue) {
		_emit_changed("value_changed",newValue);
	}

public:
	Synth_DATA_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DATA : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DATA_base *_cache;
	inline Synth_DATA_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DATA_base *)_pool->base->_cast(Synth_DATA_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DATA(Synth_DATA_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DATA_base _base_class;

	inline Synth_DATA() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DATA(const Arts::SubClass& s) :
		Arts::Object(Synth_DATA_base::_create(s.string())), _cache(0) {}
	inline Synth_DATA(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DATA_base::_fromString(r.string())):(Synth_DATA_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DATA(const Arts::DynamicCast& c) : Arts::Object(Synth_DATA_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_DATA(const Synth_DATA& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DATA(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DATA null() {return Synth_DATA((Synth_DATA_base*)0);}
	inline static Synth_DATA _from_base(Synth_DATA_base* b) {return Synth_DATA(b);}
	inline Synth_DATA& operator=(const Synth_DATA& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DATA_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float value();
	inline void value(float _newValue);
};

class Synth_ATAN_SATURATE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ATAN_SATURATE_base *_create(const std::string& subClass = "Arts::Synth_ATAN_SATURATE");
	static Synth_ATAN_SATURATE_base *_fromString(std::string objectref);
	static Synth_ATAN_SATURATE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_ATAN_SATURATE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float inscale() = 0;
	virtual void inscale(float newValue) = 0;
};

class Synth_ATAN_SATURATE_stub : virtual public Synth_ATAN_SATURATE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ATAN_SATURATE_stub();

public:
	Synth_ATAN_SATURATE_stub(Arts::Connection *connection, long objectID);

	float inscale();
	void inscale(float newValue);
};

class Synth_ATAN_SATURATE_skel : virtual public Synth_ATAN_SATURATE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void inscale_changed(float newValue) {
		_emit_changed("inscale_changed",newValue);
	}

public:
	Synth_ATAN_SATURATE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_ATAN_SATURATE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ATAN_SATURATE_base *_cache;
	inline Synth_ATAN_SATURATE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ATAN_SATURATE_base *)_pool->base->_cast(Synth_ATAN_SATURATE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ATAN_SATURATE(Synth_ATAN_SATURATE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_ATAN_SATURATE_base _base_class;

	inline Synth_ATAN_SATURATE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::SubClass& s) :
		Arts::Object(Synth_ATAN_SATURATE_base::_create(s.string())), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ATAN_SATURATE_base::_fromString(r.string())):(Synth_ATAN_SATURATE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Arts::DynamicCast& c) : Arts::Object(Synth_ATAN_SATURATE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_ATAN_SATURATE(const Synth_ATAN_SATURATE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ATAN_SATURATE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ATAN_SATURATE null() {return Synth_ATAN_SATURATE((Synth_ATAN_SATURATE_base*)0);}
	inline static Synth_ATAN_SATURATE _from_base(Synth_ATAN_SATURATE_base* b) {return Synth_ATAN_SATURATE(b);}
	inline Synth_ATAN_SATURATE& operator=(const Synth_ATAN_SATURATE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ATAN_SATURATE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float inscale();
	inline void inscale(float _newValue);
};

class Synth_BRICKWALL_LIMITER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_BRICKWALL_LIMITER_base *_create(const std::string& subClass = "Arts::Synth_BRICKWALL_LIMITER");
	static Synth_BRICKWALL_LIMITER_base *_fromString(std::string objectref);
	static Synth_BRICKWALL_LIMITER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_BRICKWALL_LIMITER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_BRICKWALL_LIMITER_stub : virtual public Synth_BRICKWALL_LIMITER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_BRICKWALL_LIMITER_stub();

public:
	Synth_BRICKWALL_LIMITER_stub(Arts::Connection *connection, long objectID);

};

class Synth_BRICKWALL_LIMITER_skel : virtual public Synth_BRICKWALL_LIMITER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_BRICKWALL_LIMITER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_BRICKWALL_LIMITER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_BRICKWALL_LIMITER_base *_cache;
	inline Synth_BRICKWALL_LIMITER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_BRICKWALL_LIMITER_base *)_pool->base->_cast(Synth_BRICKWALL_LIMITER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_BRICKWALL_LIMITER(Synth_BRICKWALL_LIMITER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_BRICKWALL_LIMITER_base _base_class;

	inline Synth_BRICKWALL_LIMITER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::SubClass& s) :
		Arts::Object(Synth_BRICKWALL_LIMITER_base::_create(s.string())), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_BRICKWALL_LIMITER_base::_fromString(r.string())):(Synth_BRICKWALL_LIMITER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Arts::DynamicCast& c) : Arts::Object(Synth_BRICKWALL_LIMITER_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_BRICKWALL_LIMITER(const Synth_BRICKWALL_LIMITER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_BRICKWALL_LIMITER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_BRICKWALL_LIMITER null() {return Synth_BRICKWALL_LIMITER((Synth_BRICKWALL_LIMITER_base*)0);}
	inline static Synth_BRICKWALL_LIMITER _from_base(Synth_BRICKWALL_LIMITER_base* b) {return Synth_BRICKWALL_LIMITER(b);}
	inline Synth_BRICKWALL_LIMITER& operator=(const Synth_BRICKWALL_LIMITER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_BRICKWALL_LIMITER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_AUTOPANNER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_AUTOPANNER_base *_create(const std::string& subClass = "Arts::Synth_AUTOPANNER");
	static Synth_AUTOPANNER_base *_fromString(std::string objectref);
	static Synth_AUTOPANNER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_AUTOPANNER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_AUTOPANNER_stub : virtual public Synth_AUTOPANNER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_AUTOPANNER_stub();

public:
	Synth_AUTOPANNER_stub(Arts::Connection *connection, long objectID);

};

class Synth_AUTOPANNER_skel : virtual public Synth_AUTOPANNER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *inlfo;                             // incoming stream
	float *outvalue1;                         // outgoing stream
	float *outvalue2;                         // outgoing stream

public:
	Synth_AUTOPANNER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_AUTOPANNER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_AUTOPANNER_base *_cache;
	inline Synth_AUTOPANNER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_AUTOPANNER_base *)_pool->base->_cast(Synth_AUTOPANNER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_AUTOPANNER(Synth_AUTOPANNER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_AUTOPANNER_base _base_class;

	inline Synth_AUTOPANNER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::SubClass& s) :
		Arts::Object(Synth_AUTOPANNER_base::_create(s.string())), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_AUTOPANNER_base::_fromString(r.string())):(Synth_AUTOPANNER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_AUTOPANNER(const Arts::DynamicCast& c) : Arts::Object(Synth_AUTOPANNER_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_AUTOPANNER(const Synth_AUTOPANNER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_AUTOPANNER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_AUTOPANNER null() {return Synth_AUTOPANNER((Synth_AUTOPANNER_base*)0);}
	inline static Synth_AUTOPANNER _from_base(Synth_AUTOPANNER_base* b) {return Synth_AUTOPANNER(b);}
	inline Synth_AUTOPANNER& operator=(const Synth_AUTOPANNER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_AUTOPANNER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_DELAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_DELAY_base *_create(const std::string& subClass = "Arts::Synth_DELAY");
	static Synth_DELAY_base *_fromString(std::string objectref);
	static Synth_DELAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_DELAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_DELAY_stub : virtual public Synth_DELAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_DELAY_stub();

public:
	Synth_DELAY_stub(Arts::Connection *connection, long objectID);

};

class Synth_DELAY_skel : virtual public Synth_DELAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *time;                              // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_DELAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_DELAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_DELAY_base *_cache;
	inline Synth_DELAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_DELAY_base *)_pool->base->_cast(Synth_DELAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_DELAY(Synth_DELAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_DELAY_base _base_class;

	inline Synth_DELAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_DELAY(const Arts::SubClass& s) :
		Arts::Object(Synth_DELAY_base::_create(s.string())), _cache(0) {}
	inline Synth_DELAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_DELAY_base::_fromString(r.string())):(Synth_DELAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_DELAY(const Arts::DynamicCast& c) : Arts::Object(Synth_DELAY_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_DELAY(const Synth_DELAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_DELAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_DELAY null() {return Synth_DELAY((Synth_DELAY_base*)0);}
	inline static Synth_DELAY _from_base(Synth_DELAY_base* b) {return Synth_DELAY(b);}
	inline Synth_DELAY& operator=(const Synth_DELAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_DELAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_CDELAY_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_CDELAY_base *_create(const std::string& subClass = "Arts::Synth_CDELAY");
	static Synth_CDELAY_base *_fromString(std::string objectref);
	static Synth_CDELAY_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_CDELAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float time() = 0;
	virtual void time(float newValue) = 0;
};

class Synth_CDELAY_stub : virtual public Synth_CDELAY_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_CDELAY_stub();

public:
	Synth_CDELAY_stub(Arts::Connection *connection, long objectID);

	float time();
	void time(float newValue);
};

class Synth_CDELAY_skel : virtual public Synth_CDELAY_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void time_changed(float newValue) {
		_emit_changed("time_changed",newValue);
	}

public:
	Synth_CDELAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_CDELAY : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_CDELAY_base *_cache;
	inline Synth_CDELAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_CDELAY_base *)_pool->base->_cast(Synth_CDELAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_CDELAY(Synth_CDELAY_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_CDELAY_base _base_class;

	inline Synth_CDELAY() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_CDELAY(const Arts::SubClass& s) :
		Arts::Object(Synth_CDELAY_base::_create(s.string())), _cache(0) {}
	inline Synth_CDELAY(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_CDELAY_base::_fromString(r.string())):(Synth_CDELAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_CDELAY(const Arts::DynamicCast& c) : Arts::Object(Synth_CDELAY_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_CDELAY(const Synth_CDELAY& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_CDELAY(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_CDELAY null() {return Synth_CDELAY((Synth_CDELAY_base*)0);}
	inline static Synth_CDELAY _from_base(Synth_CDELAY_base* b) {return Synth_CDELAY(b);}
	inline Synth_CDELAY& operator=(const Synth_CDELAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_CDELAY_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float time();
	inline void time(float _newValue);
};

class Synth_FM_SOURCE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FM_SOURCE_base *_create(const std::string& subClass = "Arts::Synth_FM_SOURCE");
	static Synth_FM_SOURCE_base *_fromString(std::string objectref);
	static Synth_FM_SOURCE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_FM_SOURCE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_FM_SOURCE_stub : virtual public Synth_FM_SOURCE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FM_SOURCE_stub();

public:
	Synth_FM_SOURCE_stub(Arts::Connection *connection, long objectID);

};

class Synth_FM_SOURCE_skel : virtual public Synth_FM_SOURCE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *modulator;                         // incoming stream
	float *modlevel;                          // incoming stream
	float *pos;                               // outgoing stream

public:
	Synth_FM_SOURCE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FM_SOURCE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FM_SOURCE_base *_cache;
	inline Synth_FM_SOURCE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FM_SOURCE_base *)_pool->base->_cast(Synth_FM_SOURCE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FM_SOURCE(Synth_FM_SOURCE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FM_SOURCE_base _base_class;

	inline Synth_FM_SOURCE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::SubClass& s) :
		Arts::Object(Synth_FM_SOURCE_base::_create(s.string())), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FM_SOURCE_base::_fromString(r.string())):(Synth_FM_SOURCE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FM_SOURCE(const Arts::DynamicCast& c) : Arts::Object(Synth_FM_SOURCE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_FM_SOURCE(const Synth_FM_SOURCE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FM_SOURCE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FM_SOURCE null() {return Synth_FM_SOURCE((Synth_FM_SOURCE_base*)0);}
	inline static Synth_FM_SOURCE _from_base(Synth_FM_SOURCE_base* b) {return Synth_FM_SOURCE(b);}
	inline Synth_FM_SOURCE& operator=(const Synth_FM_SOURCE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FM_SOURCE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_TREMOLO_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_TREMOLO_base *_create(const std::string& subClass = "Arts::Synth_TREMOLO");
	static Synth_TREMOLO_base *_fromString(std::string objectref);
	static Synth_TREMOLO_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_TREMOLO_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_TREMOLO_stub : virtual public Synth_TREMOLO_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_TREMOLO_stub();

public:
	Synth_TREMOLO_stub(Arts::Connection *connection, long objectID);

};

class Synth_TREMOLO_skel : virtual public Synth_TREMOLO_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *inlfo;                             // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_TREMOLO_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_TREMOLO : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_TREMOLO_base *_cache;
	inline Synth_TREMOLO_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_TREMOLO_base *)_pool->base->_cast(Synth_TREMOLO_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_TREMOLO(Synth_TREMOLO_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_TREMOLO_base _base_class;

	inline Synth_TREMOLO() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_TREMOLO(const Arts::SubClass& s) :
		Arts::Object(Synth_TREMOLO_base::_create(s.string())), _cache(0) {}
	inline Synth_TREMOLO(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_TREMOLO_base::_fromString(r.string())):(Synth_TREMOLO_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_TREMOLO(const Arts::DynamicCast& c) : Arts::Object(Synth_TREMOLO_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_TREMOLO(const Synth_TREMOLO& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_TREMOLO(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_TREMOLO null() {return Synth_TREMOLO((Synth_TREMOLO_base*)0);}
	inline static Synth_TREMOLO _from_base(Synth_TREMOLO_base* b) {return Synth_TREMOLO(b);}
	inline Synth_TREMOLO& operator=(const Synth_TREMOLO& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_TREMOLO_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_FX_CFLANGER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FX_CFLANGER_base *_create(const std::string& subClass = "Arts::Synth_FX_CFLANGER");
	static Synth_FX_CFLANGER_base *_fromString(std::string objectref);
	static Synth_FX_CFLANGER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_FX_CFLANGER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float mintime() = 0;
	virtual void mintime(float newValue) = 0;
	virtual float maxtime() = 0;
	virtual void maxtime(float newValue) = 0;
};

class Synth_FX_CFLANGER_stub : virtual public Synth_FX_CFLANGER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_FX_CFLANGER_stub();

public:
	Synth_FX_CFLANGER_stub(Arts::Connection *connection, long objectID);

	float mintime();
	void mintime(float newValue);
	float maxtime();
	void maxtime(float newValue);
};

class Synth_FX_CFLANGER_skel : virtual public Synth_FX_CFLANGER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *lfo;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void mintime_changed(float newValue) {
		_emit_changed("mintime_changed",newValue);
	}
	inline void maxtime_changed(float newValue) {
		_emit_changed("maxtime_changed",newValue);
	}

public:
	Synth_FX_CFLANGER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FX_CFLANGER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FX_CFLANGER_base *_cache;
	inline Synth_FX_CFLANGER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FX_CFLANGER_base *)_pool->base->_cast(Synth_FX_CFLANGER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FX_CFLANGER(Synth_FX_CFLANGER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FX_CFLANGER_base _base_class;

	inline Synth_FX_CFLANGER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::SubClass& s) :
		Arts::Object(Synth_FX_CFLANGER_base::_create(s.string())), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FX_CFLANGER_base::_fromString(r.string())):(Synth_FX_CFLANGER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FX_CFLANGER(const Arts::DynamicCast& c) : Arts::Object(Synth_FX_CFLANGER_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_FX_CFLANGER(const Synth_FX_CFLANGER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FX_CFLANGER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FX_CFLANGER null() {return Synth_FX_CFLANGER((Synth_FX_CFLANGER_base*)0);}
	inline static Synth_FX_CFLANGER _from_base(Synth_FX_CFLANGER_base* b) {return Synth_FX_CFLANGER(b);}
	inline Synth_FX_CFLANGER& operator=(const Synth_FX_CFLANGER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FX_CFLANGER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float mintime();
	inline void mintime(float _newValue);
	inline float maxtime();
	inline void maxtime(float _newValue);
};

class Synth_NOISE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_NOISE_base *_create(const std::string& subClass = "Arts::Synth_NOISE");
	static Synth_NOISE_base *_fromString(std::string objectref);
	static Synth_NOISE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_NOISE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_NOISE_stub : virtual public Synth_NOISE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_NOISE_stub();

public:
	Synth_NOISE_stub(Arts::Connection *connection, long objectID);

};

class Synth_NOISE_skel : virtual public Synth_NOISE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *outvalue;                          // outgoing stream

public:
	Synth_NOISE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_NOISE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_NOISE_base *_cache;
	inline Synth_NOISE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_NOISE_base *)_pool->base->_cast(Synth_NOISE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_NOISE(Synth_NOISE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_NOISE_base _base_class;

	inline Synth_NOISE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_NOISE(const Arts::SubClass& s) :
		Arts::Object(Synth_NOISE_base::_create(s.string())), _cache(0) {}
	inline Synth_NOISE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_NOISE_base::_fromString(r.string())):(Synth_NOISE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_NOISE(const Arts::DynamicCast& c) : Arts::Object(Synth_NOISE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_NOISE(const Synth_NOISE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_NOISE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_NOISE null() {return Synth_NOISE((Synth_NOISE_base*)0);}
	inline static Synth_NOISE _from_base(Synth_NOISE_base* b) {return Synth_NOISE(b);}
	inline Synth_NOISE& operator=(const Synth_NOISE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_NOISE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_TRI_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_TRI_base *_create(const std::string& subClass = "Arts::Synth_WAVE_TRI");
	static Synth_WAVE_TRI_base *_fromString(std::string objectref);
	static Synth_WAVE_TRI_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_WAVE_TRI_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_TRI_stub : virtual public Synth_WAVE_TRI_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_TRI_stub();

public:
	Synth_WAVE_TRI_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_TRI_skel : virtual public Synth_WAVE_TRI_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_TRI_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_TRI : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_TRI_base *_cache;
	inline Synth_WAVE_TRI_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_TRI_base *)_pool->base->_cast(Synth_WAVE_TRI_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_TRI(Synth_WAVE_TRI_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_TRI_base _base_class;

	inline Synth_WAVE_TRI() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_TRI_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_TRI_base::_fromString(r.string())):(Synth_WAVE_TRI_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_TRI(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_TRI_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_WAVE_TRI(const Synth_WAVE_TRI& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_TRI(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_TRI null() {return Synth_WAVE_TRI((Synth_WAVE_TRI_base*)0);}
	inline static Synth_WAVE_TRI _from_base(Synth_WAVE_TRI_base* b) {return Synth_WAVE_TRI(b);}
	inline Synth_WAVE_TRI& operator=(const Synth_WAVE_TRI& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_TRI_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_SQUARE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SQUARE_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SQUARE");
	static Synth_WAVE_SQUARE_base *_fromString(std::string objectref);
	static Synth_WAVE_SQUARE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_WAVE_SQUARE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SQUARE_stub : virtual public Synth_WAVE_SQUARE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SQUARE_stub();

public:
	Synth_WAVE_SQUARE_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SQUARE_skel : virtual public Synth_WAVE_SQUARE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SQUARE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_SQUARE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SQUARE_base *_cache;
	inline Synth_WAVE_SQUARE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SQUARE_base *)_pool->base->_cast(Synth_WAVE_SQUARE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SQUARE(Synth_WAVE_SQUARE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SQUARE_base _base_class;

	inline Synth_WAVE_SQUARE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SQUARE_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SQUARE_base::_fromString(r.string())):(Synth_WAVE_SQUARE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SQUARE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_WAVE_SQUARE(const Synth_WAVE_SQUARE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SQUARE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SQUARE null() {return Synth_WAVE_SQUARE((Synth_WAVE_SQUARE_base*)0);}
	inline static Synth_WAVE_SQUARE _from_base(Synth_WAVE_SQUARE_base* b) {return Synth_WAVE_SQUARE(b);}
	inline Synth_WAVE_SQUARE& operator=(const Synth_WAVE_SQUARE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SQUARE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_WAVE_PULSE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_PULSE_base *_create(const std::string& subClass = "Arts::Synth_WAVE_PULSE");
	static Synth_WAVE_PULSE_base *_fromString(std::string objectref);
	static Synth_WAVE_PULSE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_WAVE_PULSE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float dutycycle() = 0;
	virtual void dutycycle(float newValue) = 0;
};

class Synth_WAVE_PULSE_stub : virtual public Synth_WAVE_PULSE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_PULSE_stub();

public:
	Synth_WAVE_PULSE_stub(Arts::Connection *connection, long objectID);

	float dutycycle();
	void dutycycle(float newValue);
};

class Synth_WAVE_PULSE_skel : virtual public Synth_WAVE_PULSE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void dutycycle_changed(float newValue) {
		_emit_changed("dutycycle_changed",newValue);
	}

public:
	Synth_WAVE_PULSE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_PULSE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_PULSE_base *_cache;
	inline Synth_WAVE_PULSE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_PULSE_base *)_pool->base->_cast(Synth_WAVE_PULSE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_PULSE(Synth_WAVE_PULSE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_PULSE_base _base_class;

	inline Synth_WAVE_PULSE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_PULSE_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_PULSE_base::_fromString(r.string())):(Synth_WAVE_PULSE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_PULSE(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_PULSE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_WAVE_PULSE(const Synth_WAVE_PULSE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_PULSE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_PULSE null() {return Synth_WAVE_PULSE((Synth_WAVE_PULSE_base*)0);}
	inline static Synth_WAVE_PULSE _from_base(Synth_WAVE_PULSE_base* b) {return Synth_WAVE_PULSE(b);}
	inline Synth_WAVE_PULSE& operator=(const Synth_WAVE_PULSE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_PULSE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float dutycycle();
	inline void dutycycle(float _newValue);
};

class Synth_WAVE_SOFTSAW_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SOFTSAW_base *_create(const std::string& subClass = "Arts::Synth_WAVE_SOFTSAW");
	static Synth_WAVE_SOFTSAW_base *_fromString(std::string objectref);
	static Synth_WAVE_SOFTSAW_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_WAVE_SOFTSAW_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SOFTSAW_stub : virtual public Synth_WAVE_SOFTSAW_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_WAVE_SOFTSAW_stub();

public:
	Synth_WAVE_SOFTSAW_stub(Arts::Connection *connection, long objectID);

};

class Synth_WAVE_SOFTSAW_skel : virtual public Synth_WAVE_SOFTSAW_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SOFTSAW_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_WAVE_SOFTSAW : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_WAVE_SOFTSAW_base *_cache;
	inline Synth_WAVE_SOFTSAW_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SOFTSAW_base *)_pool->base->_cast(Synth_WAVE_SOFTSAW_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_WAVE_SOFTSAW(Synth_WAVE_SOFTSAW_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_WAVE_SOFTSAW_base _base_class;

	inline Synth_WAVE_SOFTSAW() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::SubClass& s) :
		Arts::Object(Synth_WAVE_SOFTSAW_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_WAVE_SOFTSAW_base::_fromString(r.string())):(Synth_WAVE_SOFTSAW_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Arts::DynamicCast& c) : Arts::Object(Synth_WAVE_SOFTSAW_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_WAVE_SOFTSAW(const Synth_WAVE_SOFTSAW& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SOFTSAW(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_WAVE_SOFTSAW null() {return Synth_WAVE_SOFTSAW((Synth_WAVE_SOFTSAW_base*)0);}
	inline static Synth_WAVE_SOFTSAW _from_base(Synth_WAVE_SOFTSAW_base* b) {return Synth_WAVE_SOFTSAW(b);}
	inline Synth_WAVE_SOFTSAW& operator=(const Synth_WAVE_SOFTSAW& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_WAVE_SOFTSAW_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_ENVELOPE_ADSR_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ENVELOPE_ADSR_base *_create(const std::string& subClass = "Arts::Synth_ENVELOPE_ADSR");
	static Synth_ENVELOPE_ADSR_base *_fromString(std::string objectref);
	static Synth_ENVELOPE_ADSR_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_ENVELOPE_ADSR_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_ENVELOPE_ADSR_stub : virtual public Synth_ENVELOPE_ADSR_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_ENVELOPE_ADSR_stub();

public:
	Synth_ENVELOPE_ADSR_stub(Arts::Connection *connection, long objectID);

};

class Synth_ENVELOPE_ADSR_skel : virtual public Synth_ENVELOPE_ADSR_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *active;                            // incoming stream
	float *invalue;                           // incoming stream
	float *attack;                            // incoming stream
	float *decay;                             // incoming stream
	float *sustain;                           // incoming stream
	float *release;                           // incoming stream
	float *outvalue;                          // outgoing stream
	float *done;                              // outgoing stream

public:
	Synth_ENVELOPE_ADSR_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_ENVELOPE_ADSR : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_ENVELOPE_ADSR_base *_cache;
	inline Synth_ENVELOPE_ADSR_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ENVELOPE_ADSR_base *)_pool->base->_cast(Synth_ENVELOPE_ADSR_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_ENVELOPE_ADSR(Synth_ENVELOPE_ADSR_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_ENVELOPE_ADSR_base _base_class;

	inline Synth_ENVELOPE_ADSR() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::SubClass& s) :
		Arts::Object(Synth_ENVELOPE_ADSR_base::_create(s.string())), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_ENVELOPE_ADSR_base::_fromString(r.string())):(Synth_ENVELOPE_ADSR_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Arts::DynamicCast& c) : Arts::Object(Synth_ENVELOPE_ADSR_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_ENVELOPE_ADSR(const Synth_ENVELOPE_ADSR& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_ENVELOPE_ADSR(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_ENVELOPE_ADSR null() {return Synth_ENVELOPE_ADSR((Synth_ENVELOPE_ADSR_base*)0);}
	inline static Synth_ENVELOPE_ADSR _from_base(Synth_ENVELOPE_ADSR_base* b) {return Synth_ENVELOPE_ADSR(b);}
	inline Synth_ENVELOPE_ADSR& operator=(const Synth_ENVELOPE_ADSR& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_ENVELOPE_ADSR_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_SHELVE_CUTOFF_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_SHELVE_CUTOFF_base *_create(const std::string& subClass = "Arts::Synth_SHELVE_CUTOFF");
	static Synth_SHELVE_CUTOFF_base *_fromString(std::string objectref);
	static Synth_SHELVE_CUTOFF_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_SHELVE_CUTOFF_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_SHELVE_CUTOFF_stub : virtual public Synth_SHELVE_CUTOFF_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_SHELVE_CUTOFF_stub();

public:
	Synth_SHELVE_CUTOFF_stub(Arts::Connection *connection, long objectID);

};

class Synth_SHELVE_CUTOFF_skel : virtual public Synth_SHELVE_CUTOFF_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *frequency;                         // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_SHELVE_CUTOFF_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_SHELVE_CUTOFF : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_SHELVE_CUTOFF_base *_cache;
	inline Synth_SHELVE_CUTOFF_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_SHELVE_CUTOFF_base *)_pool->base->_cast(Synth_SHELVE_CUTOFF_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_SHELVE_CUTOFF(Synth_SHELVE_CUTOFF_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_SHELVE_CUTOFF_base _base_class;

	inline Synth_SHELVE_CUTOFF() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::SubClass& s) :
		Arts::Object(Synth_SHELVE_CUTOFF_base::_create(s.string())), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_SHELVE_CUTOFF_base::_fromString(r.string())):(Synth_SHELVE_CUTOFF_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Arts::DynamicCast& c) : Arts::Object(Synth_SHELVE_CUTOFF_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_SHELVE_CUTOFF(const Synth_SHELVE_CUTOFF& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_SHELVE_CUTOFF(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_SHELVE_CUTOFF null() {return Synth_SHELVE_CUTOFF((Synth_SHELVE_CUTOFF_base*)0);}
	inline static Synth_SHELVE_CUTOFF _from_base(Synth_SHELVE_CUTOFF_base* b) {return Synth_SHELVE_CUTOFF(b);}
	inline Synth_SHELVE_CUTOFF& operator=(const Synth_SHELVE_CUTOFF& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_SHELVE_CUTOFF_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_XFADE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_XFADE_base *_create(const std::string& subClass = "Arts::Synth_XFADE");
	static Synth_XFADE_base *_fromString(std::string objectref);
	static Synth_XFADE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_XFADE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_XFADE_stub : virtual public Synth_XFADE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_XFADE_stub();

public:
	Synth_XFADE_stub(Arts::Connection *connection, long objectID);

};

class Synth_XFADE_skel : virtual public Synth_XFADE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *percentage;                        // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_XFADE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_XFADE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_XFADE_base *_cache;
	inline Synth_XFADE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_XFADE_base *)_pool->base->_cast(Synth_XFADE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_XFADE(Synth_XFADE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_XFADE_base _base_class;

	inline Synth_XFADE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_XFADE(const Arts::SubClass& s) :
		Arts::Object(Synth_XFADE_base::_create(s.string())), _cache(0) {}
	inline Synth_XFADE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_XFADE_base::_fromString(r.string())):(Synth_XFADE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_XFADE(const Arts::DynamicCast& c) : Arts::Object(Synth_XFADE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_XFADE(const Synth_XFADE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_XFADE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_XFADE null() {return Synth_XFADE((Synth_XFADE_base*)0);}
	inline static Synth_XFADE _from_base(Synth_XFADE_base* b) {return Synth_XFADE(b);}
	inline Synth_XFADE& operator=(const Synth_XFADE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_XFADE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_MIDI_TEST_base : virtual public Arts::SynthModule_base,
	virtual public Arts::MidiPort_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MIDI_TEST_base *_create(const std::string& subClass = "Arts::Synth_MIDI_TEST");
	static Synth_MIDI_TEST_base *_fromString(std::string objectref);
	static Synth_MIDI_TEST_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_MIDI_TEST_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
};

class Synth_MIDI_TEST_stub : virtual public Synth_MIDI_TEST_base, virtual public Arts::SynthModule_stub,
	virtual public Arts::MidiPort_stub {
protected:
	Synth_MIDI_TEST_stub();

public:
	Synth_MIDI_TEST_stub(Arts::Connection *connection, long objectID);

	std::string filename();
	void filename(const std::string& newValue);
};

class Synth_MIDI_TEST_skel : virtual public Synth_MIDI_TEST_base, virtual public Arts::SynthModule_skel,
	virtual public Arts::MidiPort_skel {
protected:
	// emitters for change notifications
	inline void filename_changed(const std::string& newValue) {
		_emit_changed("filename_changed",newValue);
	}

public:
	Synth_MIDI_TEST_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MIDI_TEST : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MIDI_TEST_base *_cache;
	inline Synth_MIDI_TEST_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MIDI_TEST_base *)_pool->base->_cast(Synth_MIDI_TEST_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MIDI_TEST(Synth_MIDI_TEST_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MIDI_TEST_base _base_class;

	inline Synth_MIDI_TEST() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::SubClass& s) :
		Arts::Object(Synth_MIDI_TEST_base::_create(s.string())), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MIDI_TEST_base::_fromString(r.string())):(Synth_MIDI_TEST_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MIDI_TEST(const Arts::DynamicCast& c) : Arts::Object(Synth_MIDI_TEST_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_MIDI_TEST(const Synth_MIDI_TEST& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MIDI_TEST(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MIDI_TEST null() {return Synth_MIDI_TEST((Synth_MIDI_TEST_base*)0);}
	inline static Synth_MIDI_TEST _from_base(Synth_MIDI_TEST_base* b) {return Synth_MIDI_TEST(b);}
	inline Synth_MIDI_TEST& operator=(const Synth_MIDI_TEST& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline operator Arts::MidiPort() const { return Arts::MidiPort(*_pool); }
	inline Synth_MIDI_TEST_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::TimeStamp time();
	inline void processCommand(const Arts::MidiCommand& command);
	inline void processEvent(const Arts::MidiEvent& event);
	inline std::string filename();
	inline void filename(const std::string& _newValue);
};

class Synth_MIDI_DEBUG_base : virtual public Arts::SynthModule_base,
	virtual public Arts::MidiChannel_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MIDI_DEBUG_base *_create(const std::string& subClass = "Arts::Synth_MIDI_DEBUG");
	static Synth_MIDI_DEBUG_base *_fromString(std::string objectref);
	static Synth_MIDI_DEBUG_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_MIDI_DEBUG_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MIDI_DEBUG_stub : virtual public Synth_MIDI_DEBUG_base, virtual public Arts::SynthModule_stub,
	virtual public Arts::MidiChannel_stub {
protected:
	Synth_MIDI_DEBUG_stub();

public:
	Synth_MIDI_DEBUG_stub(Arts::Connection *connection, long objectID);

};

class Synth_MIDI_DEBUG_skel : virtual public Synth_MIDI_DEBUG_base, virtual public Arts::SynthModule_skel,
	virtual public Arts::MidiChannel_skel {
public:
	Synth_MIDI_DEBUG_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MIDI_DEBUG : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MIDI_DEBUG_base *_cache;
	inline Synth_MIDI_DEBUG_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MIDI_DEBUG_base *)_pool->base->_cast(Synth_MIDI_DEBUG_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MIDI_DEBUG(Synth_MIDI_DEBUG_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MIDI_DEBUG_base _base_class;

	inline Synth_MIDI_DEBUG() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::SubClass& s) :
		Arts::Object(Synth_MIDI_DEBUG_base::_create(s.string())), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MIDI_DEBUG_base::_fromString(r.string())):(Synth_MIDI_DEBUG_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Arts::DynamicCast& c) : Arts::Object(Synth_MIDI_DEBUG_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_MIDI_DEBUG(const Synth_MIDI_DEBUG& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MIDI_DEBUG(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MIDI_DEBUG null() {return Synth_MIDI_DEBUG((Synth_MIDI_DEBUG_base*)0);}
	inline static Synth_MIDI_DEBUG _from_base(Synth_MIDI_DEBUG_base* b) {return Synth_MIDI_DEBUG(b);}
	inline Synth_MIDI_DEBUG& operator=(const Synth_MIDI_DEBUG& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline operator Arts::MidiChannel() const { return Arts::MidiChannel(*_pool); }
	inline Synth_MIDI_DEBUG_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline Arts::TimeStamp time();
	inline void noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	inline void noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note);
	inline void noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume);
	inline void noteOff(Arts::mcopbyte channel, Arts::mcopbyte note);
};

class Synth_FREEVERB_base : virtual public Arts::StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FREEVERB_base *_create(const std::string& subClass = "Arts::Synth_FREEVERB");
	static Synth_FREEVERB_base *_fromString(std::string objectref);
	static Synth_FREEVERB_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_FREEVERB_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float roomsize() = 0;
	virtual void roomsize(float newValue) = 0;
	virtual float damp() = 0;
	virtual void damp(float newValue) = 0;
	virtual float wet() = 0;
	virtual void wet(float newValue) = 0;
	virtual float dry() = 0;
	virtual void dry(float newValue) = 0;
	virtual float width() = 0;
	virtual void width(float newValue) = 0;
	virtual float mode() = 0;
	virtual void mode(float newValue) = 0;
};

class Synth_FREEVERB_stub : virtual public Synth_FREEVERB_base, virtual public Arts::StereoEffect_stub {
protected:
	Synth_FREEVERB_stub();

public:
	Synth_FREEVERB_stub(Arts::Connection *connection, long objectID);

	float roomsize();
	void roomsize(float newValue);
	float damp();
	void damp(float newValue);
	float wet();
	void wet(float newValue);
	float dry();
	void dry(float newValue);
	float width();
	void width(float newValue);
	float mode();
	void mode(float newValue);
};

class Synth_FREEVERB_skel : virtual public Synth_FREEVERB_base, virtual public Arts::StereoEffect_skel {
protected:
	// emitters for change notifications
	inline void roomsize_changed(float newValue) {
		_emit_changed("roomsize_changed",newValue);
	}
	inline void damp_changed(float newValue) {
		_emit_changed("damp_changed",newValue);
	}
	inline void wet_changed(float newValue) {
		_emit_changed("wet_changed",newValue);
	}
	inline void dry_changed(float newValue) {
		_emit_changed("dry_changed",newValue);
	}
	inline void width_changed(float newValue) {
		_emit_changed("width_changed",newValue);
	}
	inline void mode_changed(float newValue) {
		_emit_changed("mode_changed",newValue);
	}

public:
	Synth_FREEVERB_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_FREEVERB : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_FREEVERB_base *_cache;
	inline Synth_FREEVERB_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FREEVERB_base *)_pool->base->_cast(Synth_FREEVERB_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_FREEVERB(Synth_FREEVERB_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_FREEVERB_base _base_class;

	inline Synth_FREEVERB() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_FREEVERB(const Arts::SubClass& s) :
		Arts::Object(Synth_FREEVERB_base::_create(s.string())), _cache(0) {}
	inline Synth_FREEVERB(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_FREEVERB_base::_fromString(r.string())):(Synth_FREEVERB_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FREEVERB(const Arts::DynamicCast& c) : Arts::Object(Synth_FREEVERB_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_FREEVERB(const Synth_FREEVERB& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_FREEVERB(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_FREEVERB null() {return Synth_FREEVERB((Synth_FREEVERB_base*)0);}
	inline static Synth_FREEVERB _from_base(Synth_FREEVERB_base* b) {return Synth_FREEVERB(b);}
	inline Synth_FREEVERB& operator=(const Synth_FREEVERB& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::StereoEffect() const { return Arts::StereoEffect(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_FREEVERB_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float roomsize();
	inline void roomsize(float _newValue);
	inline float damp();
	inline void damp(float _newValue);
	inline float wet();
	inline void wet(float _newValue);
	inline float dry();
	inline void dry(float _newValue);
	inline float width();
	inline void width(float _newValue);
	inline float mode();
	inline void mode(float _newValue);
};

class Synth_STD_EQUALIZER_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STD_EQUALIZER_base *_create(const std::string& subClass = "Arts::Synth_STD_EQUALIZER");
	static Synth_STD_EQUALIZER_base *_fromString(std::string objectref);
	static Synth_STD_EQUALIZER_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_STD_EQUALIZER_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float low() = 0;
	virtual void low(float newValue) = 0;
	virtual float mid() = 0;
	virtual void mid(float newValue) = 0;
	virtual float high() = 0;
	virtual void high(float newValue) = 0;
	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
	virtual float q() = 0;
	virtual void q(float newValue) = 0;
};

class Synth_STD_EQUALIZER_stub : virtual public Synth_STD_EQUALIZER_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_STD_EQUALIZER_stub();

public:
	Synth_STD_EQUALIZER_stub(Arts::Connection *connection, long objectID);

	float low();
	void low(float newValue);
	float mid();
	void mid(float newValue);
	float high();
	void high(float newValue);
	float frequency();
	void frequency(float newValue);
	float q();
	void q(float newValue);
};

class Synth_STD_EQUALIZER_skel : virtual public Synth_STD_EQUALIZER_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void low_changed(float newValue) {
		_emit_changed("low_changed",newValue);
	}
	inline void mid_changed(float newValue) {
		_emit_changed("mid_changed",newValue);
	}
	inline void high_changed(float newValue) {
		_emit_changed("high_changed",newValue);
	}
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}
	inline void q_changed(float newValue) {
		_emit_changed("q_changed",newValue);
	}

public:
	Synth_STD_EQUALIZER_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STD_EQUALIZER : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STD_EQUALIZER_base *_cache;
	inline Synth_STD_EQUALIZER_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STD_EQUALIZER_base *)_pool->base->_cast(Synth_STD_EQUALIZER_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STD_EQUALIZER(Synth_STD_EQUALIZER_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STD_EQUALIZER_base _base_class;

	inline Synth_STD_EQUALIZER() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::SubClass& s) :
		Arts::Object(Synth_STD_EQUALIZER_base::_create(s.string())), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STD_EQUALIZER_base::_fromString(r.string())):(Synth_STD_EQUALIZER_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Arts::DynamicCast& c) : Arts::Object(Synth_STD_EQUALIZER_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_STD_EQUALIZER(const Synth_STD_EQUALIZER& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STD_EQUALIZER(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STD_EQUALIZER null() {return Synth_STD_EQUALIZER((Synth_STD_EQUALIZER_base*)0);}
	inline static Synth_STD_EQUALIZER _from_base(Synth_STD_EQUALIZER_base* b) {return Synth_STD_EQUALIZER(b);}
	inline Synth_STD_EQUALIZER& operator=(const Synth_STD_EQUALIZER& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STD_EQUALIZER_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float low();
	inline void low(float _newValue);
	inline float mid();
	inline void mid(float _newValue);
	inline float high();
	inline void high(float _newValue);
	inline float frequency();
	inline void frequency(float _newValue);
	inline float q();
	inline void q(float _newValue);
};

class Synth_RC_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_RC_base *_create(const std::string& subClass = "Arts::Synth_RC");
	static Synth_RC_base *_fromString(std::string objectref);
	static Synth_RC_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_RC_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float b() = 0;
	virtual void b(float newValue) = 0;
	virtual float f() = 0;
	virtual void f(float newValue) = 0;
};

class Synth_RC_stub : virtual public Synth_RC_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_RC_stub();

public:
	Synth_RC_stub(Arts::Connection *connection, long objectID);

	float b();
	void b(float newValue);
	float f();
	void f(float newValue);
};

class Synth_RC_skel : virtual public Synth_RC_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void b_changed(float newValue) {
		_emit_changed("b_changed",newValue);
	}
	inline void f_changed(float newValue) {
		_emit_changed("f_changed",newValue);
	}

public:
	Synth_RC_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_RC : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_RC_base *_cache;
	inline Synth_RC_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_RC_base *)_pool->base->_cast(Synth_RC_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_RC(Synth_RC_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_RC_base _base_class;

	inline Synth_RC() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_RC(const Arts::SubClass& s) :
		Arts::Object(Synth_RC_base::_create(s.string())), _cache(0) {}
	inline Synth_RC(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_RC_base::_fromString(r.string())):(Synth_RC_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_RC(const Arts::DynamicCast& c) : Arts::Object(Synth_RC_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_RC(const Synth_RC& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_RC(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_RC null() {return Synth_RC((Synth_RC_base*)0);}
	inline static Synth_RC _from_base(Synth_RC_base* b) {return Synth_RC(b);}
	inline Synth_RC& operator=(const Synth_RC& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_RC_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float b();
	inline void b(float _newValue);
	inline float f();
	inline void f(float _newValue);
};

class Synth_MOOG_VCF_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MOOG_VCF_base *_create(const std::string& subClass = "Arts::Synth_MOOG_VCF");
	static Synth_MOOG_VCF_base *_fromString(std::string objectref);
	static Synth_MOOG_VCF_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_MOOG_VCF_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
	virtual float resonance() = 0;
	virtual void resonance(float newValue) = 0;
};

class Synth_MOOG_VCF_stub : virtual public Synth_MOOG_VCF_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_MOOG_VCF_stub();

public:
	Synth_MOOG_VCF_stub(Arts::Connection *connection, long objectID);

	float frequency();
	void frequency(float newValue);
	float resonance();
	void resonance(float newValue);
};

class Synth_MOOG_VCF_skel : virtual public Synth_MOOG_VCF_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}
	inline void resonance_changed(float newValue) {
		_emit_changed("resonance_changed",newValue);
	}

public:
	Synth_MOOG_VCF_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_MOOG_VCF : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_MOOG_VCF_base *_cache;
	inline Synth_MOOG_VCF_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MOOG_VCF_base *)_pool->base->_cast(Synth_MOOG_VCF_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_MOOG_VCF(Synth_MOOG_VCF_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_MOOG_VCF_base _base_class;

	inline Synth_MOOG_VCF() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::SubClass& s) :
		Arts::Object(Synth_MOOG_VCF_base::_create(s.string())), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_MOOG_VCF_base::_fromString(r.string())):(Synth_MOOG_VCF_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MOOG_VCF(const Arts::DynamicCast& c) : Arts::Object(Synth_MOOG_VCF_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_MOOG_VCF(const Synth_MOOG_VCF& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_MOOG_VCF(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_MOOG_VCF null() {return Synth_MOOG_VCF((Synth_MOOG_VCF_base*)0);}
	inline static Synth_MOOG_VCF _from_base(Synth_MOOG_VCF_base* b) {return Synth_MOOG_VCF(b);}
	inline Synth_MOOG_VCF& operator=(const Synth_MOOG_VCF& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_MOOG_VCF_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float frequency();
	inline void frequency(float _newValue);
	inline float resonance();
	inline void resonance(float _newValue);
};

class Synth_PSCALE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PSCALE_base *_create(const std::string& subClass = "Arts::Synth_PSCALE");
	static Synth_PSCALE_base *_fromString(std::string objectref);
	static Synth_PSCALE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_PSCALE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float top() = 0;
	virtual void top(float newValue) = 0;
};

class Synth_PSCALE_stub : virtual public Synth_PSCALE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PSCALE_stub();

public:
	Synth_PSCALE_stub(Arts::Connection *connection, long objectID);

	float top();
	void top(float newValue);
};

class Synth_PSCALE_skel : virtual public Synth_PSCALE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void top_changed(float newValue) {
		_emit_changed("top_changed",newValue);
	}

public:
	Synth_PSCALE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PSCALE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PSCALE_base *_cache;
	inline Synth_PSCALE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PSCALE_base *)_pool->base->_cast(Synth_PSCALE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PSCALE(Synth_PSCALE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PSCALE_base _base_class;

	inline Synth_PSCALE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PSCALE(const Arts::SubClass& s) :
		Arts::Object(Synth_PSCALE_base::_create(s.string())), _cache(0) {}
	inline Synth_PSCALE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PSCALE_base::_fromString(r.string())):(Synth_PSCALE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PSCALE(const Arts::DynamicCast& c) : Arts::Object(Synth_PSCALE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_PSCALE(const Synth_PSCALE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PSCALE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PSCALE null() {return Synth_PSCALE((Synth_PSCALE_base*)0);}
	inline static Synth_PSCALE _from_base(Synth_PSCALE_base* b) {return Synth_PSCALE(b);}
	inline Synth_PSCALE& operator=(const Synth_PSCALE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PSCALE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float top();
	inline void top(float _newValue);
};

class Synth_SEQUENCE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_SEQUENCE_base *_create(const std::string& subClass = "Arts::Synth_SEQUENCE");
	static Synth_SEQUENCE_base *_fromString(std::string objectref);
	static Synth_SEQUENCE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_SEQUENCE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual std::string seq() = 0;
	virtual void seq(const std::string& newValue) = 0;
};

class Synth_SEQUENCE_stub : virtual public Synth_SEQUENCE_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_SEQUENCE_stub();

public:
	Synth_SEQUENCE_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	std::string seq();
	void seq(const std::string& newValue);
};

class Synth_SEQUENCE_skel : virtual public Synth_SEQUENCE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // outgoing stream
	float *pos;                               // outgoing stream

protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void seq_changed(const std::string& newValue) {
		_emit_changed("seq_changed",newValue);
	}

public:
	Synth_SEQUENCE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_SEQUENCE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_SEQUENCE_base *_cache;
	inline Synth_SEQUENCE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_SEQUENCE_base *)_pool->base->_cast(Synth_SEQUENCE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_SEQUENCE(Synth_SEQUENCE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_SEQUENCE_base _base_class;

	inline Synth_SEQUENCE() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::SubClass& s) :
		Arts::Object(Synth_SEQUENCE_base::_create(s.string())), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_SEQUENCE_base::_fromString(r.string())):(Synth_SEQUENCE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_SEQUENCE(const Arts::DynamicCast& c) : Arts::Object(Synth_SEQUENCE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_SEQUENCE(const Synth_SEQUENCE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_SEQUENCE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_SEQUENCE null() {return Synth_SEQUENCE((Synth_SEQUENCE_base*)0);}
	inline static Synth_SEQUENCE _from_base(Synth_SEQUENCE_base* b) {return Synth_SEQUENCE(b);}
	inline Synth_SEQUENCE& operator=(const Synth_SEQUENCE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_SEQUENCE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline std::string seq();
	inline void seq(const std::string& _newValue);
};

class Synth_PITCH_SHIFT_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PITCH_SHIFT_base *_create(const std::string& subClass = "Arts::Synth_PITCH_SHIFT");
	static Synth_PITCH_SHIFT_base *_fromString(std::string objectref);
	static Synth_PITCH_SHIFT_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_PITCH_SHIFT_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual float frequency() = 0;
	virtual void frequency(float newValue) = 0;
};

class Synth_PITCH_SHIFT_stub : virtual public Synth_PITCH_SHIFT_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_PITCH_SHIFT_stub();

public:
	Synth_PITCH_SHIFT_stub(Arts::Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	float frequency();
	void frequency(float newValue);
};

class Synth_PITCH_SHIFT_skel : virtual public Synth_PITCH_SHIFT_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *invalue;                           // incoming stream
	float *outvalue;                          // outgoing stream

protected:
	// emitters for change notifications
	inline void speed_changed(float newValue) {
		_emit_changed("speed_changed",newValue);
	}
	inline void frequency_changed(float newValue) {
		_emit_changed("frequency_changed",newValue);
	}

public:
	Synth_PITCH_SHIFT_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_PITCH_SHIFT : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_PITCH_SHIFT_base *_cache;
	inline Synth_PITCH_SHIFT_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PITCH_SHIFT_base *)_pool->base->_cast(Synth_PITCH_SHIFT_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_PITCH_SHIFT(Synth_PITCH_SHIFT_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_PITCH_SHIFT_base _base_class;

	inline Synth_PITCH_SHIFT() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::SubClass& s) :
		Arts::Object(Synth_PITCH_SHIFT_base::_create(s.string())), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_PITCH_SHIFT_base::_fromString(r.string())):(Synth_PITCH_SHIFT_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Arts::DynamicCast& c) : Arts::Object(Synth_PITCH_SHIFT_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_PITCH_SHIFT(const Synth_PITCH_SHIFT& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_PITCH_SHIFT(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_PITCH_SHIFT null() {return Synth_PITCH_SHIFT((Synth_PITCH_SHIFT_base*)0);}
	inline static Synth_PITCH_SHIFT _from_base(Synth_PITCH_SHIFT_base* b) {return Synth_PITCH_SHIFT(b);}
	inline Synth_PITCH_SHIFT& operator=(const Synth_PITCH_SHIFT& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_PITCH_SHIFT_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline float speed();
	inline void speed(float _newValue);
	inline float frequency();
	inline void frequency(float _newValue);
};

class Interface_MIDI_NOTE_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Interface_MIDI_NOTE_base *_create(const std::string& subClass = "Arts::Interface_MIDI_NOTE");
	static Interface_MIDI_NOTE_base *_fromString(std::string objectref);
	static Interface_MIDI_NOTE_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Interface_MIDI_NOTE_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Interface_MIDI_NOTE_stub : virtual public Interface_MIDI_NOTE_base, virtual public Arts::SynthModule_stub {
protected:
	Interface_MIDI_NOTE_stub();

public:
	Interface_MIDI_NOTE_stub(Arts::Connection *connection, long objectID);

};

class Interface_MIDI_NOTE_skel : virtual public Interface_MIDI_NOTE_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // outgoing stream
	float *velocity;                          // outgoing stream
	float *pressed;                           // outgoing stream

public:
	Interface_MIDI_NOTE_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Interface_MIDI_NOTE : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Interface_MIDI_NOTE_base *_cache;
	inline Interface_MIDI_NOTE_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Interface_MIDI_NOTE_base *)_pool->base->_cast(Interface_MIDI_NOTE_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Interface_MIDI_NOTE(Interface_MIDI_NOTE_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Interface_MIDI_NOTE_base _base_class;

	inline Interface_MIDI_NOTE() : Arts::Object(_Creator), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::SubClass& s) :
		Arts::Object(Interface_MIDI_NOTE_base::_create(s.string())), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Interface_MIDI_NOTE_base::_fromString(r.string())):(Interface_MIDI_NOTE_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Interface_MIDI_NOTE(const Arts::DynamicCast& c) : Arts::Object(Interface_MIDI_NOTE_base::_fromString(c.object().toString())), _cache(0) {}
	inline Interface_MIDI_NOTE(const Interface_MIDI_NOTE& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Interface_MIDI_NOTE(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Interface_MIDI_NOTE null() {return Interface_MIDI_NOTE((Interface_MIDI_NOTE_base*)0);}
	inline static Interface_MIDI_NOTE _from_base(Interface_MIDI_NOTE_base* b) {return Interface_MIDI_NOTE(b);}
	inline Interface_MIDI_NOTE& operator=(const Interface_MIDI_NOTE& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Interface_MIDI_NOTE_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

class Synth_STRUCT_KILL_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_STRUCT_KILL_base *_create(const std::string& subClass = "Arts::Synth_STRUCT_KILL");
	static Synth_STRUCT_KILL_base *_fromString(std::string objectref);
	static Synth_STRUCT_KILL_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline Synth_STRUCT_KILL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_STRUCT_KILL_stub : virtual public Synth_STRUCT_KILL_base, virtual public Arts::SynthModule_stub {
protected:
	Synth_STRUCT_KILL_stub();

public:
	Synth_STRUCT_KILL_stub(Arts::Connection *connection, long objectID);

};

class Synth_STRUCT_KILL_skel : virtual public Synth_STRUCT_KILL_base, virtual public Arts::SynthModule_skel {
protected:
	// variables for streams
	float *ready;                             // incoming stream

public:
	Synth_STRUCT_KILL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class Synth_STRUCT_KILL : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Synth_STRUCT_KILL_base *_cache;
	inline Synth_STRUCT_KILL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_STRUCT_KILL_base *)_pool->base->_cast(Synth_STRUCT_KILL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Synth_STRUCT_KILL(Synth_STRUCT_KILL_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Synth_STRUCT_KILL_base _base_class;

	inline Synth_STRUCT_KILL() : Arts::Object(_Creator), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::SubClass& s) :
		Arts::Object(Synth_STRUCT_KILL_base::_create(s.string())), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Synth_STRUCT_KILL_base::_fromString(r.string())):(Synth_STRUCT_KILL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_STRUCT_KILL(const Arts::DynamicCast& c) : Arts::Object(Synth_STRUCT_KILL_base::_fromString(c.object().toString())), _cache(0) {}
	inline Synth_STRUCT_KILL(const Synth_STRUCT_KILL& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Synth_STRUCT_KILL(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Synth_STRUCT_KILL null() {return Synth_STRUCT_KILL((Synth_STRUCT_KILL_base*)0);}
	inline static Synth_STRUCT_KILL _from_base(Synth_STRUCT_KILL_base* b) {return Synth_STRUCT_KILL(b);}
	inline Synth_STRUCT_KILL& operator=(const Synth_STRUCT_KILL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Synth_STRUCT_KILL_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
};

// Forward wrapper calls to _base classes:

inline Arts::TimeStamp Arts::MidiChannel::time()
{
	return _cache?static_cast<Arts::MidiChannel_base*>(_cache)->time():static_cast<Arts::MidiChannel_base*>(_method_call())->time();
}

inline void Arts::MidiChannel::noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOnAt(time, channel, note, volume):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOnAt(time, channel, note, volume);
}

inline void Arts::MidiChannel::noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOffAt(time, channel, note):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOffAt(time, channel, note);
}

inline void Arts::MidiChannel::noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOn(channel, note, volume):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOn(channel, note, volume);
}

inline void Arts::MidiChannel::noteOff(Arts::mcopbyte channel, Arts::mcopbyte note)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOff(channel, note):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOff(channel, note);
}

inline void Arts::ObjectCache::put(Arts::Object obj, const std::string& name)
{
	 _cache?static_cast<Arts::ObjectCache_base*>(_cache)->put(obj, name):static_cast<Arts::ObjectCache_base*>(_method_call())->put(obj, name);
}

inline Arts::Object Arts::ObjectCache::get(const std::string& name)
{
	return _cache?static_cast<Arts::ObjectCache_base*>(_cache)->get(name):static_cast<Arts::ObjectCache_base*>(_method_call())->get(name);
}

inline Arts::AutoSuspendState Arts::MidiReleaseHelper::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::MidiReleaseHelper::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::MidiReleaseHelper::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::MidiReleaseHelper::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::MidiReleaseHelper::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::MidiReleaseHelper::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::SynthModule Arts::MidiReleaseHelper::voice()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->voice():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->voice();
}

inline void Arts::MidiReleaseHelper::voice(Arts::SynthModule _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->voice(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->voice(_newValue);
}

inline std::string Arts::MidiReleaseHelper::name()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->name():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->name();
}

inline void Arts::MidiReleaseHelper::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->name(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->name(_newValue);
}

inline Arts::ObjectCache Arts::MidiReleaseHelper::cache()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->cache():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->cache();
}

inline void Arts::MidiReleaseHelper::cache(Arts::ObjectCache _newValue)
{
	 _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->cache(_newValue):static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->cache(_newValue);
}

inline bool Arts::MidiReleaseHelper::terminate()
{
	return _cache?static_cast<Arts::MidiReleaseHelper_base*>(_cache)->terminate():static_cast<Arts::MidiReleaseHelper_base*>(_method_call())->terminate();
}

inline Arts::AutoSuspendState Arts::Synth_CAPTURE_WAV::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_CAPTURE_WAV::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_CAPTURE_WAV::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_CAPTURE_WAV::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_CAPTURE_WAV::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_CAPTURE_WAV::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_NIL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_NIL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_NIL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_NIL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_NIL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_NIL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_DEBUG::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DEBUG::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DEBUG::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DEBUG::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DEBUG::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DEBUG::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::string Arts::Synth_DEBUG::comment()
{
	return _cache?static_cast<Arts::Synth_DEBUG_base*>(_cache)->comment():static_cast<Arts::Synth_DEBUG_base*>(_method_call())->comment();
}

inline void Arts::Synth_DEBUG::comment(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_DEBUG_base*>(_cache)->comment(_newValue):static_cast<Arts::Synth_DEBUG_base*>(_method_call())->comment(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_DATA::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DATA::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DATA::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DATA::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DATA::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DATA::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_DATA::value()
{
	return _cache?static_cast<Arts::Synth_DATA_base*>(_cache)->value():static_cast<Arts::Synth_DATA_base*>(_method_call())->value();
}

inline void Arts::Synth_DATA::value(float _newValue)
{
	 _cache?static_cast<Arts::Synth_DATA_base*>(_cache)->value(_newValue):static_cast<Arts::Synth_DATA_base*>(_method_call())->value(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_ATAN_SATURATE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ATAN_SATURATE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ATAN_SATURATE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ATAN_SATURATE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ATAN_SATURATE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ATAN_SATURATE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_ATAN_SATURATE::inscale()
{
	return _cache?static_cast<Arts::Synth_ATAN_SATURATE_base*>(_cache)->inscale():static_cast<Arts::Synth_ATAN_SATURATE_base*>(_method_call())->inscale();
}

inline void Arts::Synth_ATAN_SATURATE::inscale(float _newValue)
{
	 _cache?static_cast<Arts::Synth_ATAN_SATURATE_base*>(_cache)->inscale(_newValue):static_cast<Arts::Synth_ATAN_SATURATE_base*>(_method_call())->inscale(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_BRICKWALL_LIMITER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_BRICKWALL_LIMITER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_BRICKWALL_LIMITER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_BRICKWALL_LIMITER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_AUTOPANNER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_AUTOPANNER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_AUTOPANNER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_AUTOPANNER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_AUTOPANNER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_AUTOPANNER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_DELAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_DELAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_DELAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_DELAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_DELAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_DELAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_CDELAY::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_CDELAY::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_CDELAY::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_CDELAY::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_CDELAY::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_CDELAY::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_CDELAY::time()
{
	return _cache?static_cast<Arts::Synth_CDELAY_base*>(_cache)->time():static_cast<Arts::Synth_CDELAY_base*>(_method_call())->time();
}

inline void Arts::Synth_CDELAY::time(float _newValue)
{
	 _cache?static_cast<Arts::Synth_CDELAY_base*>(_cache)->time(_newValue):static_cast<Arts::Synth_CDELAY_base*>(_method_call())->time(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_FM_SOURCE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FM_SOURCE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FM_SOURCE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FM_SOURCE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FM_SOURCE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FM_SOURCE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_TREMOLO::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_TREMOLO::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_TREMOLO::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_TREMOLO::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_TREMOLO::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_TREMOLO::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_FX_CFLANGER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FX_CFLANGER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FX_CFLANGER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FX_CFLANGER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FX_CFLANGER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FX_CFLANGER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_FX_CFLANGER::mintime()
{
	return _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->mintime():static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->mintime();
}

inline void Arts::Synth_FX_CFLANGER::mintime(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->mintime(_newValue):static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->mintime(_newValue);
}

inline float Arts::Synth_FX_CFLANGER::maxtime()
{
	return _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->maxtime():static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->maxtime();
}

inline void Arts::Synth_FX_CFLANGER::maxtime(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FX_CFLANGER_base*>(_cache)->maxtime(_newValue):static_cast<Arts::Synth_FX_CFLANGER_base*>(_method_call())->maxtime(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_NOISE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_NOISE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_NOISE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_NOISE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_NOISE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_NOISE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_TRI::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_TRI::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_TRI::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_TRI::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_TRI::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_TRI::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SQUARE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SQUARE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SQUARE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SQUARE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SQUARE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SQUARE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_PULSE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_PULSE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_PULSE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_PULSE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_PULSE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_PULSE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_WAVE_PULSE::dutycycle()
{
	return _cache?static_cast<Arts::Synth_WAVE_PULSE_base*>(_cache)->dutycycle():static_cast<Arts::Synth_WAVE_PULSE_base*>(_method_call())->dutycycle();
}

inline void Arts::Synth_WAVE_PULSE::dutycycle(float _newValue)
{
	 _cache?static_cast<Arts::Synth_WAVE_PULSE_base*>(_cache)->dutycycle(_newValue):static_cast<Arts::Synth_WAVE_PULSE_base*>(_method_call())->dutycycle(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_WAVE_SOFTSAW::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_WAVE_SOFTSAW::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_WAVE_SOFTSAW::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_WAVE_SOFTSAW::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_ENVELOPE_ADSR::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_ENVELOPE_ADSR::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_ENVELOPE_ADSR::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_ENVELOPE_ADSR::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_SHELVE_CUTOFF::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_SHELVE_CUTOFF::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_SHELVE_CUTOFF::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_SHELVE_CUTOFF::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_XFADE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_XFADE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_XFADE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_XFADE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_XFADE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_XFADE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_MIDI_TEST::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MIDI_TEST::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MIDI_TEST::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MIDI_TEST::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MIDI_TEST::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MIDI_TEST::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::TimeStamp Arts::Synth_MIDI_TEST::time()
{
	return _cache?static_cast<Arts::MidiPort_base*>(_cache)->time():static_cast<Arts::MidiPort_base*>(_method_call())->time();
}

inline void Arts::Synth_MIDI_TEST::processCommand(const Arts::MidiCommand& command)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processCommand(command):static_cast<Arts::MidiPort_base*>(_method_call())->processCommand(command);
}

inline void Arts::Synth_MIDI_TEST::processEvent(const Arts::MidiEvent& event)
{
	 _cache?static_cast<Arts::MidiPort_base*>(_cache)->processEvent(event):static_cast<Arts::MidiPort_base*>(_method_call())->processEvent(event);
}

inline std::string Arts::Synth_MIDI_TEST::filename()
{
	return _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->filename():static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->filename();
}

inline void Arts::Synth_MIDI_TEST::filename(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_MIDI_TEST_base*>(_cache)->filename(_newValue):static_cast<Arts::Synth_MIDI_TEST_base*>(_method_call())->filename(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_MIDI_DEBUG::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MIDI_DEBUG::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MIDI_DEBUG::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MIDI_DEBUG::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MIDI_DEBUG::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MIDI_DEBUG::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::TimeStamp Arts::Synth_MIDI_DEBUG::time()
{
	return _cache?static_cast<Arts::MidiChannel_base*>(_cache)->time():static_cast<Arts::MidiChannel_base*>(_method_call())->time();
}

inline void Arts::Synth_MIDI_DEBUG::noteOnAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOnAt(time, channel, note, volume):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOnAt(time, channel, note, volume);
}

inline void Arts::Synth_MIDI_DEBUG::noteOffAt(const Arts::TimeStamp& time, Arts::mcopbyte channel, Arts::mcopbyte note)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOffAt(time, channel, note):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOffAt(time, channel, note);
}

inline void Arts::Synth_MIDI_DEBUG::noteOn(Arts::mcopbyte channel, Arts::mcopbyte note, Arts::mcopbyte volume)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOn(channel, note, volume):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOn(channel, note, volume);
}

inline void Arts::Synth_MIDI_DEBUG::noteOff(Arts::mcopbyte channel, Arts::mcopbyte note)
{
	 _cache?static_cast<Arts::MidiChannel_base*>(_cache)->noteOff(channel, note):static_cast<Arts::MidiChannel_base*>(_method_call())->noteOff(channel, note);
}

inline Arts::AutoSuspendState Arts::Synth_FREEVERB::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_FREEVERB::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_FREEVERB::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_FREEVERB::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_FREEVERB::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_FREEVERB::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_FREEVERB::roomsize()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->roomsize():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->roomsize();
}

inline void Arts::Synth_FREEVERB::roomsize(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->roomsize(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->roomsize(_newValue);
}

inline float Arts::Synth_FREEVERB::damp()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->damp():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->damp();
}

inline void Arts::Synth_FREEVERB::damp(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->damp(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->damp(_newValue);
}

inline float Arts::Synth_FREEVERB::wet()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->wet():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->wet();
}

inline void Arts::Synth_FREEVERB::wet(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->wet(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->wet(_newValue);
}

inline float Arts::Synth_FREEVERB::dry()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->dry():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->dry();
}

inline void Arts::Synth_FREEVERB::dry(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->dry(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->dry(_newValue);
}

inline float Arts::Synth_FREEVERB::width()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->width():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->width();
}

inline void Arts::Synth_FREEVERB::width(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->width(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->width(_newValue);
}

inline float Arts::Synth_FREEVERB::mode()
{
	return _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->mode():static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->mode();
}

inline void Arts::Synth_FREEVERB::mode(float _newValue)
{
	 _cache?static_cast<Arts::Synth_FREEVERB_base*>(_cache)->mode(_newValue):static_cast<Arts::Synth_FREEVERB_base*>(_method_call())->mode(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_STD_EQUALIZER::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STD_EQUALIZER::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STD_EQUALIZER::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STD_EQUALIZER::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STD_EQUALIZER::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STD_EQUALIZER::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_STD_EQUALIZER::low()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->low():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->low();
}

inline void Arts::Synth_STD_EQUALIZER::low(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->low(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->low(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::mid()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->mid():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->mid();
}

inline void Arts::Synth_STD_EQUALIZER::mid(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->mid(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->mid(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::high()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->high():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->high();
}

inline void Arts::Synth_STD_EQUALIZER::high(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->high(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->high(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::frequency()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->frequency():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->frequency();
}

inline void Arts::Synth_STD_EQUALIZER::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->frequency(_newValue);
}

inline float Arts::Synth_STD_EQUALIZER::q()
{
	return _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->q():static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->q();
}

inline void Arts::Synth_STD_EQUALIZER::q(float _newValue)
{
	 _cache?static_cast<Arts::Synth_STD_EQUALIZER_base*>(_cache)->q(_newValue):static_cast<Arts::Synth_STD_EQUALIZER_base*>(_method_call())->q(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_RC::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_RC::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_RC::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_RC::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_RC::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_RC::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_RC::b()
{
	return _cache?static_cast<Arts::Synth_RC_base*>(_cache)->b():static_cast<Arts::Synth_RC_base*>(_method_call())->b();
}

inline void Arts::Synth_RC::b(float _newValue)
{
	 _cache?static_cast<Arts::Synth_RC_base*>(_cache)->b(_newValue):static_cast<Arts::Synth_RC_base*>(_method_call())->b(_newValue);
}

inline float Arts::Synth_RC::f()
{
	return _cache?static_cast<Arts::Synth_RC_base*>(_cache)->f():static_cast<Arts::Synth_RC_base*>(_method_call())->f();
}

inline void Arts::Synth_RC::f(float _newValue)
{
	 _cache?static_cast<Arts::Synth_RC_base*>(_cache)->f(_newValue):static_cast<Arts::Synth_RC_base*>(_method_call())->f(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_MOOG_VCF::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_MOOG_VCF::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_MOOG_VCF::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_MOOG_VCF::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_MOOG_VCF::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_MOOG_VCF::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_MOOG_VCF::frequency()
{
	return _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->frequency():static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->frequency();
}

inline void Arts::Synth_MOOG_VCF::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->frequency(_newValue);
}

inline float Arts::Synth_MOOG_VCF::resonance()
{
	return _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->resonance():static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->resonance();
}

inline void Arts::Synth_MOOG_VCF::resonance(float _newValue)
{
	 _cache?static_cast<Arts::Synth_MOOG_VCF_base*>(_cache)->resonance(_newValue):static_cast<Arts::Synth_MOOG_VCF_base*>(_method_call())->resonance(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_PSCALE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PSCALE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PSCALE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PSCALE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PSCALE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PSCALE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PSCALE::top()
{
	return _cache?static_cast<Arts::Synth_PSCALE_base*>(_cache)->top():static_cast<Arts::Synth_PSCALE_base*>(_method_call())->top();
}

inline void Arts::Synth_PSCALE::top(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PSCALE_base*>(_cache)->top(_newValue):static_cast<Arts::Synth_PSCALE_base*>(_method_call())->top(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_SEQUENCE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_SEQUENCE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_SEQUENCE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_SEQUENCE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_SEQUENCE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_SEQUENCE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_SEQUENCE::speed()
{
	return _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->speed():static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->speed();
}

inline void Arts::Synth_SEQUENCE::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->speed(_newValue);
}

inline std::string Arts::Synth_SEQUENCE::seq()
{
	return _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->seq():static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->seq();
}

inline void Arts::Synth_SEQUENCE::seq(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Synth_SEQUENCE_base*>(_cache)->seq(_newValue):static_cast<Arts::Synth_SEQUENCE_base*>(_method_call())->seq(_newValue);
}

inline Arts::AutoSuspendState Arts::Synth_PITCH_SHIFT::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_PITCH_SHIFT::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_PITCH_SHIFT::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_PITCH_SHIFT::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_PITCH_SHIFT::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_PITCH_SHIFT::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline float Arts::Synth_PITCH_SHIFT::speed()
{
	return _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->speed():static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->speed();
}

inline void Arts::Synth_PITCH_SHIFT::speed(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->speed(_newValue):static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->speed(_newValue);
}

inline float Arts::Synth_PITCH_SHIFT::frequency()
{
	return _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->frequency():static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->frequency();
}

inline void Arts::Synth_PITCH_SHIFT::frequency(float _newValue)
{
	 _cache?static_cast<Arts::Synth_PITCH_SHIFT_base*>(_cache)->frequency(_newValue):static_cast<Arts::Synth_PITCH_SHIFT_base*>(_method_call())->frequency(_newValue);
}

inline Arts::AutoSuspendState Arts::Interface_MIDI_NOTE::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Interface_MIDI_NOTE::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Interface_MIDI_NOTE::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Interface_MIDI_NOTE::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Interface_MIDI_NOTE::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Interface_MIDI_NOTE::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline Arts::AutoSuspendState Arts::Synth_STRUCT_KILL::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void Arts::Synth_STRUCT_KILL::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void Arts::Synth_STRUCT_KILL::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void Arts::Synth_STRUCT_KILL::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void Arts::Synth_STRUCT_KILL::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void Arts::Synth_STRUCT_KILL::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

};
#endif /* ARTSMODULES_H */
