/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIStreamProvider.idl
 */

#ifndef __gen_nsIStreamProvider_h__
#define __gen_nsIStreamProvider_h__


#ifndef __gen_nsIRequestObserver_h__
#include "nsIRequestObserver.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIChannel; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIEventQueue; /* forward declaration */


/* starting interface:    nsIStreamProvider */
#define NS_ISTREAMPROVIDER_IID_STR "d10ef7a9-b728-43d4-9c49-74172186d691"

#define NS_ISTREAMPROVIDER_IID \
  {0xd10ef7a9, 0xb728, 0x43d4, \
    { 0x9c, 0x49, 0x74, 0x17, 0x21, 0x86, 0xd6, 0x91 }}

/**
 * The nsIChannel::AsyncWrite notification handler.  It provides
 * data to the channel, when the channel is ready to accept it.
 */
class NS_NO_VTABLE nsIStreamProvider : public nsIRequestObserver {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMPROVIDER_IID)

  /**
     * Called when data may be written to the channel.
     *
     * @param request - the request returned by AsyncWrite
     * @param ctxt - opaque parameter passed to AsyncWrite
     * @param output - output stream for writing data chunk
     * @param offset - current stream position (informational)
     * @param count - number of bytes that can be written without blocking
     *
     * @return NS_OK - if successfully wrote something.
     * @return NS_BASE_STREAM_CLOSED - if done writing data. NOTE: this is
     *   NOT equivalent to writing zero bytes and returning NS_OK.
     * @return NS_BASE_STREAM_WOULD_BLOCK - if no data can be written at
     *   this time.  This implicitly calls Suspend on the channel.  Call
     *   Resume on the channel to continue the AsyncWrite when more data
     *   becomes available.
     * @return <other-error> - if failure.
     */
  /* void onDataWritable (in nsIRequest request, in nsISupports ctxt, in nsIOutputStream output, in unsigned long offset, in unsigned long count); */
  NS_IMETHOD OnDataWritable(nsIRequest *request, nsISupports *ctxt, nsIOutputStream *output, PRUint32 offset, PRUint32 count) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMPROVIDER \
  NS_IMETHOD OnDataWritable(nsIRequest *request, nsISupports *ctxt, nsIOutputStream *output, PRUint32 offset, PRUint32 count); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMPROVIDER(_to) \
  NS_IMETHOD OnDataWritable(nsIRequest *request, nsISupports *ctxt, nsIOutputStream *output, PRUint32 offset, PRUint32 count) { return _to ## OnDataWritable(request, ctxt, output, offset, count); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMPROVIDER(_to) \
  NS_IMETHOD OnDataWritable(nsIRequest *request, nsISupports *ctxt, nsIOutputStream *output, PRUint32 offset, PRUint32 count) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnDataWritable(request, ctxt, output, offset, count); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamProvider : public nsIStreamProvider
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMPROVIDER

  nsStreamProvider();
  virtual ~nsStreamProvider();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamProvider, nsIStreamProvider)

nsStreamProvider::nsStreamProvider()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamProvider::~nsStreamProvider()
{
  /* destructor code */
}

/* void onDataWritable (in nsIRequest request, in nsISupports ctxt, in nsIOutputStream output, in unsigned long offset, in unsigned long count); */
NS_IMETHODIMP nsStreamProvider::OnDataWritable(nsIRequest *request, nsISupports *ctxt, nsIOutputStream *output, PRUint32 offset, PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIStreamProviderProxy */
#define NS_ISTREAMPROVIDERPROXY_IID_STR "5c3b0bac-605a-49ac-880e-5c8b993f7d2b"

#define NS_ISTREAMPROVIDERPROXY_IID \
  {0x5c3b0bac, 0x605a, 0x49ac, \
    { 0x88, 0x0e, 0x5c, 0x8b, 0x99, 0x3f, 0x7d, 0x2b }}

/**
 * A stream provider proxy is used to ship data over to another thread specified
 * by the thread's event queue.  The "true" stream provider's methods are
 * invoked on the other thread.
 *
 * This interface only provides the initialization needed after construction. 
 * Otherwise, these objects may be used as a nsIStreamProvider.
 */
class NS_NO_VTABLE nsIStreamProviderProxy : public nsIStreamProvider {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTREAMPROVIDERPROXY_IID)

  /**
     * Initializes an nsIStreamProviderProxy.
     *
     * @param provider - receives provider notifications on the other thread.
     * @param eventQ - may be NULL indicating the calling thread's event queue.
     */
  /* void init (in nsIStreamProvider provider, in nsIEventQueue eventQ, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
  NS_IMETHOD Init(nsIStreamProvider *provider, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTREAMPROVIDERPROXY \
  NS_IMETHOD Init(nsIStreamProvider *provider, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTREAMPROVIDERPROXY(_to) \
  NS_IMETHOD Init(nsIStreamProvider *provider, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) { return _to ## Init(provider, eventQ, bufferSegmentSize, bufferMaxSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTREAMPROVIDERPROXY(_to) \
  NS_IMETHOD Init(nsIStreamProvider *provider, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(provider, eventQ, bufferSegmentSize, bufferMaxSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStreamProviderProxy : public nsIStreamProviderProxy
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTREAMPROVIDERPROXY

  nsStreamProviderProxy();
  virtual ~nsStreamProviderProxy();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStreamProviderProxy, nsIStreamProviderProxy)

nsStreamProviderProxy::nsStreamProviderProxy()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStreamProviderProxy::~nsStreamProviderProxy()
{
  /* destructor code */
}

/* void init (in nsIStreamProvider provider, in nsIEventQueue eventQ, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
NS_IMETHODIMP nsStreamProviderProxy::Init(nsIStreamProvider *provider, nsIEventQueue *eventQ, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsISimpleStreamProvider */
#define NS_ISIMPLESTREAMPROVIDER_IID_STR "c20bb3b9-0755-4eff-9222-3537f9e89082"

#define NS_ISIMPLESTREAMPROVIDER_IID \
  {0xc20bb3b9, 0x0755, 0x4eff, \
    { 0x92, 0x22, 0x35, 0x37, 0xf9, 0xe8, 0x90, 0x82 }}

/**
 * A simple stream provider can be used with AsyncWrite to supply data from 
 * an existing input stream.
 */
class NS_NO_VTABLE nsISimpleStreamProvider : public nsIStreamProvider {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISIMPLESTREAMPROVIDER_IID)

  /**
     * Initialize the simple stream provider.
     *
     * @param - data will be read from this input stream to the channel
     * @param - optional stream observer (can be NULL)
     */
  /* void init (in nsIInputStream source, in nsIRequestObserver observer); */
  NS_IMETHOD Init(nsIInputStream *source, nsIRequestObserver *observer) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISIMPLESTREAMPROVIDER \
  NS_IMETHOD Init(nsIInputStream *source, nsIRequestObserver *observer); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISIMPLESTREAMPROVIDER(_to) \
  NS_IMETHOD Init(nsIInputStream *source, nsIRequestObserver *observer) { return _to ## Init(source, observer); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISIMPLESTREAMPROVIDER(_to) \
  NS_IMETHOD Init(nsIInputStream *source, nsIRequestObserver *observer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(source, observer); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSimpleStreamProvider : public nsISimpleStreamProvider
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISIMPLESTREAMPROVIDER

  nsSimpleStreamProvider();
  virtual ~nsSimpleStreamProvider();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSimpleStreamProvider, nsISimpleStreamProvider)

nsSimpleStreamProvider::nsSimpleStreamProvider()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSimpleStreamProvider::~nsSimpleStreamProvider()
{
  /* destructor code */
}

/* void init (in nsIInputStream source, in nsIRequestObserver observer); */
NS_IMETHODIMP nsSimpleStreamProvider::Init(nsIInputStream *source, nsIRequestObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIStreamProvider_h__ */
