// -*- c++ -*-
//  Generated by gtkmmproc from ./../calendar.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_CALENDAR_H
#define _GTKMM_CALENDAR_H

/* $Id: calendar.gen_h,v 1.26 2000/02/13 02:22:09 kenelson Exp $ */

/* calendar.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/widget.h>
#include <gtk/gtkcalendar.h>

namespace Gtk {
class Calendar;
class Calendar_Class;
}
namespace Gtk { Gtk::Calendar *wrap (GtkCalendar *o); }
namespace Gtk
{
//: Display a calendar and/or allow the user to select a date.
//- {\class Gtk_Calendar} is a widget that displays a calendar,
//- one month at a time.
//-
//- The month and year currently displayed can be altered with {select_month()}.
//- The exact day can be selected from the displayed month using {select_day()}.
//-
//- The way in which the calendar itself is displayed can be altered
//- using {display_options()}.
//-
//- The selected date can be retrieved from a GtkCalendar using
//- {get_date()}.
//-
//- If performing many 'mark' operations, the calendar can be frozen
//- to prevent flicker, using {freeze()}, and 'thawed' again using {thaw()}.
class Calendar : public Widget {

public:
  typedef Calendar          CppObjectType;
  typedef Calendar_Class    CppClassType;
  typedef GtkCalendar           BaseObjectType;
  typedef GtkCalendarClass      BaseClassType;

private:
  friend class Calendar_Class;
  static CppClassType calendar_class;

  Calendar(const Calendar&);
  Calendar& operator=(const Calendar&); // not implemented

protected:
  void   initialize_class();
  explicit Calendar(GtkCalendar *castitem);

public:
  static GtkType get_type();
  GtkCalendar* gtkobj()             { return (GtkCalendar*)(gtkobject); }
  const GtkCalendar* gtkobj() const { return (GtkCalendar*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Calendar();

private:

public:

  Calendar();





  gint select_month(guint month,guint year);


  void select_day(guint day);


  gint mark_day(guint day);


  gint unmark_day(guint day);


  void clear_marks();


  void display_options(GtkCalendarDisplayOptions flags);




  void get_date(guint* year,guint* month,guint* day) const;

  void freeze();


  void thaw();

public:

  union
    {
      CppObjectType * calendar_self;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,0> month_changed;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,1> day_selected;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,2> day_selected_double_click;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,3> prev_month;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,4> next_month;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,5> prev_year;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,6> next_year;
    };

protected:
  // impl functions
    virtual void month_changed_impl();
    virtual void day_selected_impl();
    virtual void day_selected_double_click_impl();
    virtual void prev_month_impl();
    virtual void next_month_impl();
    virtual void prev_year_impl();
    virtual void next_year_impl();

};

}


//+ PROPERTIES(Gtk_Calendar)
//. name: header_style
//. type: GtkStyle*
//. get:
//. set:
//. desc:

//. name: label_style
//. type: GtkStyle*
//. get:
//. set:
//. desc:

//. name: month
//. type: gint
//. get:
//. set:
//. desc:

//. name: year
//. type: gint
//. get:
//. set:
//. desc:

//. name: selected_day
//. type: gint
//. get:
//. set:
//. desc:

//. name: day_month[6]
//. type:
//. get:
//. set:
//. desc:

//. name: day[6]
//. type:
//. get:
//. set:
//. desc:

//. name: num_marked_dates
//. type: gint
//. get:
//. set:
//. desc:

//. name: marked_date
//. type:
//. get:
//. set:
//. desc:

//. name: display_flags
//. type: GtkCalendarDisplayOptions
//. get:
//. set:
//. desc:

//. name: marked_date_color
//. type:
//. get:
//. set:
//. desc:

//. name: gc
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: xor_gc
//. type: GdkGC*
//. get:
//. set:
//. desc:

//. name: focus_row
//. type: gint
//. get:
//. set:
//. desc:

//. name: focus_col
//. type: gint
//. get:
//. set:
//. desc:

//. name: highlight_row
//. type: gint
//. get:
//. set:
//. desc:

//. name: highlight_col
//. type: gint
//. get:
//. set:
//. desc:

//. name: private_data
//. type: gpointer
//. get:
//. set:
//. desc:

//. name: grow_space
//. type:
//. get:
//. set:
//. desc:

#endif
