/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __TIMING_H__
#define __TIMING_H__

#define CPUID() \
{ \
	__asm _emit 0x0f \
	__asm _emit 0xa2 \
}

#define RDTSC(cycle) \
	__asm push		eax \
	__asm push		ecx \
	__asm push		edx \
	__asm wait \
	__asm rdtsc \
	__asm lea			ecx, [cycle] \
	__asm mov			[ecx], eax \
	__asm mov			[ecx + 4], edx \
	__asm wait \
	__asm pop			eax \
	__asm pop			ecx \
	__asm pop			edx

/*
#define RDTSC(cycle) \
{ \
	__asm lea			ecx, [(cycle)] \
	__asm _emit		0x0f \
	__asm _emit		0x31 \
	__asm mov			[ecx    ], eax \
	__asm mov			[ecx + 4], edx \
}
*/

#endif // __TIMING_H__
