/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "mathutil.h"
#include "crystal.h"

void UpdateCrystalBall(CrystalBall *crystal_ball)
{
	Matrix m;
	switch (crystal_ball->rot_axis)
	{
		case X: case Y:
			RotateXMat(m, DEG_TO_RAD(crystal_ball->rotx));
			MatMultMat3x4(crystal_ball->rot_mat, m, crystal_ball->rot_mat);
			RotateYMat(m, DEG_TO_RAD(crystal_ball->roty));
			MatMultMat3x4(crystal_ball->rot_mat, m, crystal_ball->rot_mat);
			break;

		case Z:
			RotateZMat(m, DEG_TO_RAD(crystal_ball->rotz));
			MatMultMat3x4(crystal_ball->rot_mat, m, crystal_ball->rot_mat);
			break;
	}
}

void InitCrystalBall(CrystalBall *crystal_ball)
{
	IdentityMat(crystal_ball->rot_mat);
	crystal_ball->rot_axis = W;
	crystal_ball->rotx = crystal_ball->roty = crystal_ball->rotz = 0.0f;
	crystal_ball->scale = 1.0f;
}
