/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    byte[][] data;

    public ByteLookupTable(int n, byte[][] byArray) {
        super(n, byArray.length);
        this.numComponents = byArray.length;
        this.numEntries = byArray[0].length;
        this.data = new byte[this.numComponents][];
        int n2 = 0;
        while (n2 < this.numComponents) {
            this.data[n2] = byArray[n2];
            ++n2;
        }
    }

    public ByteLookupTable(int n, byte[] byArray) {
        super(n, byArray.length);
        this.numComponents = 1;
        this.numEntries = byArray.length;
        this.data = new byte[1][];
        this.data[0] = byArray;
    }

    public final byte[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n] - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                nArray2[n] = this.data[0][n2];
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                int n3 = nArray[n] - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                nArray2[n] = this.data[n][n3];
                ++n;
            }
        }
        return nArray2;
    }

    public byte[] lookupPixel(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        if (this.numComponents == 1) {
            int n = 0;
            while (n < byArray.length) {
                int n2 = (byArray[n] & 0xFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                byArray2[n] = this.data[0][n2];
                ++n;
            }
        } else {
            int n = 0;
            while (n < byArray.length) {
                int n3 = (byArray[n] & 0xFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                byArray2[n] = this.data[n][n3];
                ++n;
            }
        }
        return byArray2;
    }
}

