/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.IOException;
import java.io.OutputStream;
import sun.plugin.ConsoleWindow;

public class DebugOutputStream
extends OutputStream {
    private OutputStream traceOutputStream;
    private int count;
    private byte[] buf = new byte[80];
    private ConsoleWindow console = null;

    DebugOutputStream(ConsoleWindow consoleWindow, OutputStream outputStream) {
        this.console = consoleWindow;
        this.traceOutputStream = outputStream;
        this.count = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            if (this.console != null) {
                this.trace(this.buf, 0, this.count);
            }
            this.count = 0;
        }
    }

    private void trace(byte[] byArray, int n, int n2) {
        if (this.console != null) {
            this.console.append(new String(byArray, n, n2));
        }
        try {
            this.traceOutputStream.write(byArray, n, n2);
            this.traceOutputStream.flush();
        }
        catch (Exception exception) {
            this.console.append(exception.toString());
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
        if (n == 10 || n == 13) {
            this.flushBuffer();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.buf.length) {
            this.flushBuffer();
            this.trace(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        if (byArray[n2 - 1] == 10 || byArray[n2 - 1] == 13) {
            this.flushBuffer();
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }

    protected void printDebug(String string) {
    }
}

