/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MidiSynth
extends JPanel
implements ControlContext {
    final int PROGRAM = 192;
    final int NOTEON = 144;
    final int NOTEOFF = 128;
    final int SUSTAIN = 64;
    final int REVERB = 91;
    final int ON = 0;
    final int OFF = 1;
    final Color jfcBlue = new Color(204, 204, 255);
    final Color pink = new Color(255, 175, 175);
    Sequencer sequencer;
    Sequence sequence;
    Synthesizer synthesizer;
    Instrument[] instruments;
    ChannelData[] channels;
    ChannelData cc;
    JCheckBox mouseOverCB = new JCheckBox("mouseOver", true);
    JSlider veloS;
    JSlider presS;
    JSlider bendS;
    JSlider revbS;
    JCheckBox soloCB;
    JCheckBox monoCB;
    JCheckBox muteCB;
    JCheckBox sustCB;
    Vector keys = new Vector();
    Vector whiteKeys = new Vector();
    JTable table;
    Piano piano;
    boolean record;
    Track track;
    long startTime;
    RecordFrame recordFrame;
    Controls controls;

    public MidiSynth() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bevelBorder = new BevelBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, bevelBorder);
        jPanel.setBorder(new CompoundBorder(compoundBorder, emptyBorder));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 20, 10, 5));
        this.piano = new Piano();
        jPanel2.add(this.piano);
        jPanel.add(jPanel2);
        this.controls = new Controls();
        jPanel.add(this.controls);
        jPanel.add(new InstrumentsTable());
        this.add(jPanel);
    }

    public void open() {
        try {
            if (this.synthesizer == null && (this.synthesizer = MidiSystem.getSynthesizer()) == null) {
                System.out.println("getSynthesizer() failed!");
                return;
            }
            this.synthesizer.open();
            this.sequencer = MidiSystem.getSequencer();
            this.sequence = new Sequence(0.0f, 10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Soundbank soundbank = this.synthesizer.getDefaultSoundbank();
        if (soundbank != null) {
            this.instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
            this.synthesizer.loadInstrument(this.instruments[0]);
        }
        MidiChannel[] midiChannelArray = this.synthesizer.getChannels();
        this.channels = new ChannelData[midiChannelArray.length];
        int n = 0;
        while (n < this.channels.length) {
            this.channels[n] = new ChannelData(midiChannelArray[n], n);
            ++n;
        }
        this.cc = this.channels[0];
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionInterval(0, 0);
        listSelectionModel = this.table.getColumnModel().getSelectionModel();
        listSelectionModel.setSelectionInterval(0, 0);
    }

    public void close() {
        if (this.synthesizer != null) {
            this.synthesizer.close();
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        this.sequencer = null;
        this.synthesizer = null;
        this.instruments = null;
        this.channels = null;
        if (this.recordFrame != null) {
            this.recordFrame.dispose();
            this.recordFrame = null;
        }
    }

    public void createShortEvent(int n, int n2) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            long l = System.currentTimeMillis() - this.startTime;
            long l2 = l * (long)this.sequence.getResolution() / 500L;
            shortMessage.setMessage(n + this.cc.num, n2, this.cc.velocity);
            MidiEvent midiEvent = new MidiEvent(shortMessage, l2);
            this.track.add(midiEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        MidiSynth midiSynth = new MidiSynth();
        midiSynth.open();
        JFrame jFrame = new JFrame("Midi Synthesizer");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", midiSynth);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 760;
        int n2 = 470;
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setSize(n, n2);
        ((Component)jFrame).setVisible(true);
    }

    class RecordFrame
    extends JFrame
    implements ActionListener,
    MetaEventListener {
        public JButton recordB;
        public JButton playB;
        public JButton saveB;
        Vector tracks = new Vector();
        DefaultListModel listModel = new DefaultListModel();
        TableModel dataModel;
        JTable table;

        public RecordFrame() {
            super("Midi Capture");
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ RecordFrame this$1;
                {
                    this.this$1 = recordFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    RecordFrame.access$600((RecordFrame)this.this$1).recordFrame = null;
                }
            });
            MidiSynth.this.sequencer.addMetaEventListener(this);
            try {
                MidiSynth.this.sequence = new Sequence(0.0f, 10);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this.recordB = this.createButton("Record", jPanel2, true);
            this.playB = this.createButton("Play", jPanel2, false);
            this.saveB = this.createButton("Save...", jPanel2, false);
            this.getContentPane().add("North", jPanel2);
            String[] stringArray = new String[]{"Channel #", "Instrument"};
            this.dataModel = new AbstractTableModel(this, stringArray){
                private final /* synthetic */ String[] val$names;
                private final /* synthetic */ RecordFrame this$1;
                {
                    this.this$1 = recordFrame;
                    this.val$names = stringArray;
                }

                public int getColumnCount() {
                    return this.val$names.length;
                }

                public int getRowCount() {
                    return this.this$1.tracks.size();
                }

                public Object getValueAt(int n, int n2) {
                    if (n2 == 0) {
                        return ((TrackData)this.this$1.tracks.get((int)n)).chanNum;
                    }
                    if (n2 == 1) {
                        return ((TrackData)this.this$1.tracks.get((int)n)).name;
                    }
                    return null;
                }

                public String getColumnName(int n) {
                    return this.val$names[n];
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                public void setValueAt(Object object, int n, int n2) {
                    if (n2 == 0) {
                        ((TrackData)this.this$1.tracks.get((int)n)).chanNum = (Integer)object;
                    } else if (n2 == 1) {
                        ((TrackData)this.this$1.tracks.get((int)n)).name = (String)object;
                    }
                }
            };
            this.table = new JTable(this.dataModel);
            TableColumn tableColumn = this.table.getColumn("Channel #");
            tableColumn.setMaxWidth(65);
            this.table.sizeColumnsToFit(0);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            EmptyBorder emptyBorder = new EmptyBorder(0, 5, 5, 5);
            jScrollPane.setBorder(new CompoundBorder(emptyBorder, new EtchedBorder()));
            this.getContentPane().add("Center", jScrollPane);
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 210;
            int n2 = 160;
            ((Component)this).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
            ((Component)this).setSize(n, n2);
            ((Component)this).setVisible(true);
        }

        public JButton createButton(String string, JPanel jPanel, boolean bl) {
            JButton jButton = new JButton(string);
            jButton.setFont(new Font("serif", 0, 10));
            jButton.setEnabled(bl);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.recordB)) {
                MidiSynth.this.record = this.recordB.getText().startsWith("Record");
                if (MidiSynth.this.record) {
                    MidiSynth.this.track = MidiSynth.this.sequence.createTrack();
                    MidiSynth.this.startTime = System.currentTimeMillis();
                    MidiSynth.this.createShortEvent(192, MidiSynth.this.cc.col * 8 + MidiSynth.this.cc.row);
                    this.recordB.setText("Stop");
                    this.playB.setEnabled(false);
                    this.saveB.setEnabled(false);
                } else {
                    String string = null;
                    string = MidiSynth.this.instruments != null ? MidiSynth.this.instruments[MidiSynth.this.cc.col * 8 + MidiSynth.this.cc.row].getName() : Integer.toString(MidiSynth.this.cc.col * 8 + MidiSynth.this.cc.row);
                    this.tracks.add(new TrackData(MidiSynth.this.cc.num + 1, string, MidiSynth.this.track));
                    this.table.tableChanged(new TableModelEvent(this.dataModel));
                    this.recordB.setText("Record");
                    this.playB.setEnabled(true);
                    this.saveB.setEnabled(true);
                }
            } else if (jButton.equals(this.playB)) {
                if (this.playB.getText().startsWith("Play")) {
                    try {
                        MidiSynth.this.sequencer.open();
                        MidiSynth.this.sequencer.setSequence(MidiSynth.this.sequence);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    MidiSynth.this.sequencer.start();
                    this.playB.setText("Stop");
                    this.recordB.setEnabled(false);
                } else {
                    MidiSynth.this.sequencer.stop();
                    this.playB.setText("Play");
                    this.recordB.setEnabled(true);
                }
            } else if (jButton.equals(this.saveB)) {
                try {
                    File file = new File(System.getProperty("user.dir"));
                    JFileChooser jFileChooser = new JFileChooser(file);
                    jFileChooser.setFileFilter(new FileFilter(this){
                        private final /* synthetic */ RecordFrame this$1;
                        {
                            this.this$1 = recordFrame;
                        }

                        public boolean accept(File file) {
                            return file.isDirectory();
                        }

                        public String getDescription() {
                            return "Save as .mid file.";
                        }
                    });
                    if (jFileChooser.showSaveDialog(null) == 0) {
                        this.saveMidiFile(jFileChooser.getSelectedFile());
                    }
                }
                catch (SecurityException securityException) {
                    JavaSound.showInfoDialog();
                    securityException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void meta(MetaMessage metaMessage) {
            if (metaMessage.getType() == 47) {
                this.playB.setText("Play");
                this.recordB.setEnabled(true);
            }
        }

        public void saveMidiFile(File file) {
            try {
                int[] nArray = MidiSystem.getMidiFileTypes(MidiSynth.this.sequence);
                if (nArray.length == 0) {
                    System.out.println("Can't save sequence");
                } else if (MidiSystem.write(MidiSynth.this.sequence, nArray[0], file) == -1) {
                    throw new IOException("Problems writing to file");
                }
            }
            catch (SecurityException securityException) {
                JavaSound.showInfoDialog();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        static /* synthetic */ MidiSynth access$600(RecordFrame recordFrame) {
            return recordFrame.MidiSynth.this;
        }

        class TrackData {
            Integer chanNum;
            String name;
            Track track;

            public TrackData(int n, String string, Track track) {
                this.chanNum = new Integer(n);
                this.name = string;
                this.track = track;
            }
        }
    }

    class Controls
    extends JPanel
    implements ActionListener,
    ChangeListener,
    ItemListener {
        public JButton recordB;
        JMenu menu;
        int fileNum = 0;

        public Controls() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new EmptyBorder(5, 10, 5, 10));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            MidiSynth.this.veloS = this.createSlider("Velocity", jPanel);
            MidiSynth.this.presS = this.createSlider("Pressure", jPanel);
            MidiSynth.this.revbS = this.createSlider("Reverb", jPanel);
            MidiSynth.this.bendS = this.create14BitSlider("Bend", jPanel);
            jPanel.add(Box.createHorizontalStrut(10));
            this.add(jPanel);
            jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.setPreferredSize(new Dimension(120, 25));
            jComboBox.setMaximumSize(new Dimension(120, 25));
            int n = 1;
            while (n <= 16) {
                jComboBox.addItem("Channel " + String.valueOf(n));
                ++n;
            }
            jComboBox.addItemListener(this);
            jPanel.add(jComboBox);
            jPanel.add(Box.createHorizontalStrut(20));
            MidiSynth.this.muteCB = this.createCheckBox("Mute", jPanel);
            MidiSynth.this.soloCB = this.createCheckBox("Solo", jPanel);
            MidiSynth.this.monoCB = this.createCheckBox("Mono", jPanel);
            this.createButton("All Notes Off", jPanel);
            jPanel.add(Box.createHorizontalStrut(10));
            jPanel.add(MidiSynth.this.mouseOverCB);
            jPanel.add(Box.createHorizontalStrut(10));
            this.recordB = this.createButton("Record...", jPanel);
            this.add(jPanel);
        }

        public JButton createButton(String string, JPanel jPanel) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            return jButton;
        }

        private JCheckBox createCheckBox(String string, JPanel jPanel) {
            JCheckBox jCheckBox = new JCheckBox(string);
            jCheckBox.addItemListener(this);
            jPanel.add(jCheckBox);
            return jCheckBox;
        }

        private JSlider createSlider(String string, JPanel jPanel) {
            JSlider jSlider = new JSlider(0, 0, 127, 64);
            jSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitle(string + " = 64");
            jSlider.setBorder(titledBorder);
            jPanel.add(jSlider);
            jPanel.add(Box.createHorizontalStrut(5));
            return jSlider;
        }

        private JSlider create14BitSlider(String string, JPanel jPanel) {
            JSlider jSlider = new JSlider(0, 0, 16383, 8192);
            jSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitle(string + " = 8192");
            jSlider.setBorder(titledBorder);
            jPanel.add(jSlider);
            jPanel.add(Box.createHorizontalStrut(5));
            return jSlider;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            String string = titledBorder.getTitle();
            titledBorder.setTitle(string.substring(0, string.indexOf(61) + 1) + String.valueOf(n));
            if (string.startsWith("Velocity")) {
                MidiSynth.this.cc.velocity = n;
            } else if (string.startsWith("Pressure")) {
                MidiSynth.this.cc.pressure = n;
                MidiSynth.this.cc.channel.setChannelPressure(MidiSynth.this.cc.pressure);
            } else if (string.startsWith("Bend")) {
                MidiSynth.this.cc.bend = n;
                MidiSynth.this.cc.channel.setPitchBend(MidiSynth.this.cc.bend);
            } else if (string.startsWith("Reverb")) {
                MidiSynth.this.cc.reverb = n;
                MidiSynth.this.cc.channel.controlChange(91, MidiSynth.this.cc.reverb);
            }
            jSlider.repaint();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                MidiSynth.this.cc = MidiSynth.this.channels[jComboBox.getSelectedIndex()];
                MidiSynth.this.cc.setComponentStates();
            } else {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                String string = jCheckBox.getText();
                if (string.startsWith("Mute")) {
                    MidiSynth.this.cc.mute = jCheckBox.isSelected();
                    MidiSynth.this.cc.channel.setMute(MidiSynth.this.cc.mute);
                } else if (string.startsWith("Solo")) {
                    MidiSynth.this.cc.solo = jCheckBox.isSelected();
                    MidiSynth.this.cc.channel.setSolo(MidiSynth.this.cc.solo);
                } else if (string.startsWith("Mono")) {
                    MidiSynth.this.cc.mono = jCheckBox.isSelected();
                    MidiSynth.this.cc.channel.setMono(MidiSynth.this.cc.mono);
                } else if (string.startsWith("Sustain")) {
                    MidiSynth.this.cc.sustain = jCheckBox.isSelected();
                    MidiSynth.this.cc.channel.controlChange(64, MidiSynth.this.cc.sustain ? 127 : 0);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.getText().startsWith("All")) {
                int n = 0;
                while (n < MidiSynth.this.channels.length) {
                    MidiSynth.this.channels[n].channel.allNotesOff();
                    ++n;
                }
                int n2 = 0;
                while (n2 < MidiSynth.this.keys.size()) {
                    ((Key)MidiSynth.this.keys.get(n2)).setNoteState(1);
                    ++n2;
                }
            } else if (jButton.getText().startsWith("Record")) {
                if (MidiSynth.this.recordFrame != null) {
                    MidiSynth.this.recordFrame.toFront();
                } else {
                    MidiSynth.this.recordFrame = new RecordFrame();
                }
            }
        }
    }

    class InstrumentsTable
    extends JPanel {
        private String[] names = new String[]{"Piano", "Chromatic Perc.", "Organ", "Guitar", "Bass", "Strings", "Ensemble", "Brass", "Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Effects", "Ethnic", "Percussive", "Sound Effects"};
        private int nRows = 8;
        private int nCols = this.names.length;

        public InstrumentsTable() {
            Serializable serializable;
            this.setLayout(new BorderLayout());
            AbstractTableModel abstractTableModel = new AbstractTableModel(this){
                private final /* synthetic */ InstrumentsTable this$1;
                {
                    this.this$1 = instrumentsTable;
                }

                public int getColumnCount() {
                    return InstrumentsTable.access$100(this.this$1);
                }

                public int getRowCount() {
                    return InstrumentsTable.access$200(this.this$1);
                }

                public Object getValueAt(int n, int n2) {
                    if (InstrumentsTable.access$300((InstrumentsTable)this.this$1).instruments != null) {
                        return InstrumentsTable.access$300((InstrumentsTable)this.this$1).instruments[n2 * InstrumentsTable.access$200(this.this$1) + n].getName();
                    }
                    return Integer.toString(n2 * InstrumentsTable.access$200(this.this$1) + n);
                }

                public String getColumnName(int n) {
                    return InstrumentsTable.access$400(this.this$1)[n];
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                public void setValueAt(Object object, int n, int n2) {
                }
            };
            MidiSynth.this.table = new JTable(abstractTableModel);
            MidiSynth.this.table.setSelectionMode(0);
            ListSelectionModel listSelectionModel = MidiSynth.this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ InstrumentsTable this$1;
                {
                    this.this$1 = instrumentsTable;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (!listSelectionModel.isSelectionEmpty()) {
                        InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.row = listSelectionModel.getMinSelectionIndex();
                    }
                    InstrumentsTable.access$500(this.this$1, InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.col * InstrumentsTable.access$200(this.this$1) + InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.row);
                }
            });
            listSelectionModel = MidiSynth.this.table.getColumnModel().getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ InstrumentsTable this$1;
                {
                    this.this$1 = instrumentsTable;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (!listSelectionModel.isSelectionEmpty()) {
                        InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.col = listSelectionModel.getMinSelectionIndex();
                    }
                    InstrumentsTable.access$500(this.this$1, InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.col * InstrumentsTable.access$200(this.this$1) + InstrumentsTable.access$300((InstrumentsTable)this.this$1).cc.row);
                }
            });
            MidiSynth.this.table.setPreferredScrollableViewportSize(new Dimension(this.nCols * 110, 200));
            MidiSynth.this.table.setCellSelectionEnabled(true);
            MidiSynth.this.table.setColumnSelectionAllowed(true);
            int n = 0;
            while (n < this.names.length) {
                serializable = MidiSynth.this.table.getColumn(this.names[n]);
                ((TableColumn)serializable).setPreferredWidth(110);
                ++n;
            }
            MidiSynth.this.table.setAutoResizeMode(0);
            serializable = new JScrollPane(MidiSynth.this.table);
            ((JScrollPane)serializable).setVerticalScrollBarPolicy(21);
            ((JScrollPane)serializable).setHorizontalScrollBarPolicy(32);
            this.add((Component)serializable);
        }

        public Dimension getPreferredSize() {
            return new Dimension(800, 170);
        }

        public Dimension getMaximumSize() {
            return new Dimension(800, 170);
        }

        private void programChange(int n) {
            if (MidiSynth.this.instruments != null) {
                MidiSynth.this.synthesizer.loadInstrument(MidiSynth.this.instruments[n]);
            }
            MidiSynth.this.cc.channel.programChange(n);
            if (MidiSynth.this.record) {
                MidiSynth.this.createShortEvent(192, n);
            }
        }

        static /* synthetic */ int access$100(InstrumentsTable instrumentsTable) {
            return instrumentsTable.nCols;
        }

        static /* synthetic */ int access$200(InstrumentsTable instrumentsTable) {
            return instrumentsTable.nRows;
        }

        static /* synthetic */ MidiSynth access$300(InstrumentsTable instrumentsTable) {
            return instrumentsTable.MidiSynth.this;
        }

        static /* synthetic */ String[] access$400(InstrumentsTable instrumentsTable) {
            return instrumentsTable.names;
        }

        static /* synthetic */ void access$500(InstrumentsTable instrumentsTable, int n) {
            instrumentsTable.programChange(n);
        }
    }

    class ChannelData {
        MidiChannel channel;
        boolean solo;
        boolean mono;
        boolean mute;
        boolean sustain;
        int velocity;
        int pressure;
        int bend;
        int reverb;
        int row;
        int col;
        int num;

        public ChannelData(MidiChannel midiChannel, int n) {
            this.channel = midiChannel;
            this.num = n;
            this.reverb = 64;
            this.bend = 64;
            this.pressure = 64;
            this.velocity = 64;
        }

        public void setComponentStates() {
            MidiSynth.this.table.setRowSelectionInterval(this.row, this.row);
            MidiSynth.this.table.setColumnSelectionInterval(this.col, this.col);
            MidiSynth.this.soloCB.setSelected(this.solo);
            MidiSynth.this.monoCB.setSelected(this.mono);
            MidiSynth.this.muteCB.setSelected(this.mute);
            JSlider[] jSliderArray = new JSlider[]{MidiSynth.this.veloS, MidiSynth.this.presS, MidiSynth.this.bendS, MidiSynth.this.revbS};
            int[] nArray = new int[]{this.velocity, this.pressure, this.bend, this.reverb};
            int n = 0;
            while (n < jSliderArray.length) {
                TitledBorder titledBorder = (TitledBorder)jSliderArray[n].getBorder();
                String string = titledBorder.getTitle();
                titledBorder.setTitle(string.substring(0, string.indexOf(61) + 1) + String.valueOf(nArray[n]));
                jSliderArray[n].repaint();
                ++n;
            }
        }
    }

    class Piano
    extends JPanel
    implements MouseListener {
        Vector blackKeys = new Vector();
        Key prevKey;
        final int kw = 16;
        final int kh = 80;

        public Piano() {
            int n;
            int n2;
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(672, 81));
            int n3 = 24;
            int[] nArray = new int[]{0, 2, 4, 5, 7, 9, 11};
            int n4 = 0;
            int n5 = 0;
            while (n4 < 6) {
                n2 = 0;
                while (n2 < 7) {
                    n = n4 * 12 + nArray[n2] + n3;
                    MidiSynth.this.whiteKeys.add(new Key(n5, 0, 16, 80, n));
                    ++n2;
                    n5 += 16;
                }
                ++n4;
            }
            n2 = 0;
            n = 0;
            while (n2 < 6) {
                int n6 = n2 * 12 + n3;
                this.blackKeys.add(new Key((n += 16) - 4, 0, 8, 40, n6 + 1));
                this.blackKeys.add(new Key((n += 16) - 4, 0, 8, 40, n6 + 3));
                n += 16;
                this.blackKeys.add(new Key((n += 16) - 4, 0, 8, 40, n6 + 6));
                this.blackKeys.add(new Key((n += 16) - 4, 0, 8, 40, n6 + 8));
                this.blackKeys.add(new Key((n += 16) - 4, 0, 8, 40, n6 + 10));
                ++n2;
                n += 16;
            }
            MidiSynth.this.keys.addAll(this.blackKeys);
            MidiSynth.this.keys.addAll(MidiSynth.this.whiteKeys);
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ Piano this$1;
                {
                    this.this$1 = piano;
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (Piano.access$000((Piano)this.this$1).mouseOverCB.isSelected()) {
                        Key key = this.this$1.getKey(mouseEvent.getPoint());
                        if (this.this$1.prevKey != null && this.this$1.prevKey != key) {
                            this.this$1.prevKey.off();
                        }
                        if (key != null && this.this$1.prevKey != key) {
                            key.on();
                        }
                        this.this$1.prevKey = key;
                        this.this$1.repaint();
                    }
                }
            });
            this.addMouseListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.prevKey = this.getKey(mouseEvent.getPoint());
            if (this.prevKey != null) {
                this.prevKey.on();
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.prevKey != null) {
                this.prevKey.off();
                this.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.prevKey != null) {
                this.prevKey.off();
                this.repaint();
                this.prevKey = null;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public Key getKey(Point point) {
            int n = 0;
            while (n < MidiSynth.this.keys.size()) {
                if (((Key)MidiSynth.this.keys.get(n)).contains(point)) {
                    return (Key)MidiSynth.this.keys.get(n);
                }
                ++n;
            }
            return null;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            graphics2D.setBackground(this.getBackground());
            graphics2D.clearRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 672, 80);
            int n = 0;
            while (n < MidiSynth.this.whiteKeys.size()) {
                Key key = (Key)MidiSynth.this.whiteKeys.get(n);
                if (key.isNoteOn()) {
                    graphics2D.setColor(MidiSynth.this.record ? MidiSynth.this.pink : MidiSynth.this.jfcBlue);
                    graphics2D.fill(key);
                }
                graphics2D.setColor(Color.black);
                graphics2D.draw(key);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.blackKeys.size()) {
                Key key = (Key)this.blackKeys.get(n2);
                if (key.isNoteOn()) {
                    graphics2D.setColor(MidiSynth.this.record ? MidiSynth.this.pink : MidiSynth.this.jfcBlue);
                    graphics2D.fill(key);
                    graphics2D.setColor(Color.black);
                    graphics2D.draw(key);
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.fill(key);
                }
                ++n2;
            }
        }

        static /* synthetic */ MidiSynth access$000(Piano piano) {
            return piano.MidiSynth.this;
        }
    }

    class Key
    extends Rectangle {
        int noteState = 1;
        int kNum;

        public Key(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4);
            this.kNum = n5;
        }

        public boolean isNoteOn() {
            return this.noteState == 0;
        }

        public void on() {
            this.setNoteState(0);
            MidiSynth.this.cc.channel.noteOn(this.kNum, MidiSynth.this.cc.velocity);
            if (MidiSynth.this.record) {
                MidiSynth.this.createShortEvent(144, this.kNum);
            }
        }

        public void off() {
            this.setNoteState(1);
            MidiSynth.this.cc.channel.noteOff(this.kNum, MidiSynth.this.cc.velocity);
            if (MidiSynth.this.record) {
                MidiSynth.this.createShortEvent(128, this.kNum);
            }
        }

        public void setNoteState(int n) {
            this.noteState = n;
        }
    }
}

