/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;

public class CapturePlayback
extends JPanel
implements ActionListener,
ControlContext {
    final int bufSize = 16384;
    FormatControls formatControls = new FormatControls();
    Capture capture = new Capture();
    Playback playback = new Playback();
    AudioInputStream audioInputStream;
    SamplingGraph samplingGraph;
    JButton playB;
    JButton captB;
    JButton pausB;
    JButton loadB;
    JButton auB;
    JButton aiffB;
    JButton waveB;
    JTextField textField;
    String fileName = "untitled";
    String errStr;
    double duration;
    double seconds;
    File file;
    Vector lines = new Vector();

    public CapturePlayback() {
        this.setLayout(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.formatControls);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(softBevelBorder);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(10, 0, 5, 0));
        this.playB = this.addButton("Play", jPanel3, false);
        this.captB = this.addButton("Record", jPanel3, true);
        this.pausB = this.addButton("Pause", jPanel3, false);
        this.loadB = this.addButton("Load...", jPanel3, true);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        emptyBorder = new EmptyBorder(10, 20, 20, 20);
        jPanel4.setBorder(new CompoundBorder(emptyBorder, softBevelBorder));
        this.samplingGraph = new SamplingGraph();
        jPanel4.add(this.samplingGraph);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel("File to save:  "));
        this.textField = new JTextField(this.fileName);
        jPanel6.add(this.textField);
        this.textField.setPreferredSize(new Dimension(140, 25));
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        this.auB = this.addButton("Save AU", jPanel7, false);
        this.aiffB = this.addButton("Save AIFF", jPanel7, false);
        this.waveB = this.addButton("Save WAVE", jPanel7, false);
        jPanel5.add(jPanel7);
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        this.add(jPanel);
    }

    public void open() {
    }

    public void close() {
        if (this.playback.thread != null) {
            this.playB.doClick(0);
        }
        if (this.capture.thread != null) {
            this.captB.doClick(0);
        }
    }

    private JButton addButton(String string, JPanel jPanel, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setEnabled(bl);
        jPanel.add(jButton);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.auB)) {
            this.saveToFile(this.textField.getText().trim(), AudioFileFormat.Type.AU);
        } else if (object.equals(this.aiffB)) {
            this.saveToFile(this.textField.getText().trim(), AudioFileFormat.Type.AIFF);
        } else if (object.equals(this.waveB)) {
            this.saveToFile(this.textField.getText().trim(), AudioFileFormat.Type.WAVE);
        } else if (object.equals(this.playB)) {
            if (this.playB.getText().startsWith("Play")) {
                this.playback.start();
                this.samplingGraph.start();
                this.captB.setEnabled(false);
                this.pausB.setEnabled(true);
                this.playB.setText("Stop");
            } else {
                this.playback.stop();
                this.samplingGraph.stop();
                this.captB.setEnabled(true);
                this.pausB.setEnabled(false);
                this.playB.setText("Play");
            }
        } else if (object.equals(this.captB)) {
            if (this.captB.getText().startsWith("Record")) {
                this.file = null;
                this.capture.start();
                this.fileName = "untitled";
                this.samplingGraph.start();
                this.loadB.setEnabled(false);
                this.playB.setEnabled(false);
                this.pausB.setEnabled(true);
                this.auB.setEnabled(false);
                this.aiffB.setEnabled(false);
                this.waveB.setEnabled(false);
                this.captB.setText("Stop");
            } else {
                this.lines.removeAllElements();
                this.capture.stop();
                this.samplingGraph.stop();
                this.loadB.setEnabled(true);
                this.playB.setEnabled(true);
                this.pausB.setEnabled(false);
                this.auB.setEnabled(true);
                this.aiffB.setEnabled(true);
                this.waveB.setEnabled(true);
                this.captB.setText("Record");
            }
        } else if (object.equals(this.pausB)) {
            if (this.pausB.getText().startsWith("Pause")) {
                if (this.capture.thread != null) {
                    this.capture.line.stop();
                } else if (this.playback.thread != null) {
                    this.playback.line.stop();
                }
                this.pausB.setText("Resume");
            } else {
                if (this.capture.thread != null) {
                    this.capture.line.start();
                } else if (this.playback.thread != null) {
                    this.playback.line.start();
                }
                this.pausB.setText("Pause");
            }
        } else if (object.equals(this.loadB)) {
            try {
                File file = new File(System.getProperty("user.dir"));
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = file.getName();
                        return string.endsWith(".au") || string.endsWith(".wav") || string.endsWith(".aiff") || string.endsWith(".aif");
                    }

                    public String getDescription() {
                        return ".au, .wav, .aif";
                    }
                });
                if (jFileChooser.showOpenDialog(null) == 0) {
                    this.createAudioInputStream(jFileChooser.getSelectedFile(), true);
                }
            }
            catch (SecurityException securityException) {
                JavaSound.showInfoDialog();
                securityException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void createAudioInputStream(File file, boolean bl) {
        if (file != null && file.isFile()) {
            try {
                this.file = file;
                this.errStr = null;
                this.audioInputStream = AudioSystem.getAudioInputStream(file);
                this.playB.setEnabled(true);
                this.fileName = file.getName();
                long l = (long)((float)(this.audioInputStream.getFrameLength() * 1000L) / this.audioInputStream.getFormat().getFrameRate());
                this.duration = (double)l / 1000.0;
                this.auB.setEnabled(true);
                this.aiffB.setEnabled(true);
                this.waveB.setEnabled(true);
                if (bl) {
                    this.formatControls.setFormat(this.audioInputStream.getFormat());
                    this.samplingGraph.createWaveForm(null);
                }
            }
            catch (Exception exception) {
                this.reportStatus(exception.toString());
            }
        } else {
            this.reportStatus("Audio file required.");
        }
    }

    public void saveToFile(String string, AudioFileFormat.Type type) {
        if (this.audioInputStream == null) {
            this.reportStatus("No loaded audio to save");
            return;
        }
        if (this.file != null) {
            this.createAudioInputStream(this.file, false);
        }
        try {
            this.audioInputStream.reset();
        }
        catch (Exception exception) {
            this.reportStatus("Unable to reset stream " + exception);
            return;
        }
        this.fileName = string;
        File file = new File(this.fileName);
        try {
            if (AudioSystem.write(this.audioInputStream, type, file) == -1) {
                throw new IOException("Problems writing to file");
            }
        }
        catch (Exception exception) {
            this.reportStatus(exception.toString());
        }
        this.samplingGraph.repaint();
    }

    private void reportStatus(String string) {
        this.errStr = string;
        if (this.errStr != null) {
            System.out.println(this.errStr);
            this.samplingGraph.repaint();
        }
    }

    public static void main(String[] stringArray) {
        CapturePlayback capturePlayback = new CapturePlayback();
        capturePlayback.open();
        JFrame jFrame = new JFrame("Capture/Playback");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", capturePlayback);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 720;
        int n2 = 340;
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setSize(n, n2);
        jFrame.show();
    }

    class SamplingGraph
    extends JPanel
    implements Runnable {
        private Thread thread;
        private Font font10 = new Font("serif", 0, 10);
        private Font font12 = new Font("serif", 0, 12);
        Color jfcBlue = new Color(204, 204, 255);
        Color pink = new Color(255, 175, 175);

        public SamplingGraph() {
            this.setBackground(new Color(20, 20, 20));
        }

        public void createWaveForm(byte[] byArray) {
            int n;
            int n2;
            CapturePlayback.this.lines.removeAllElements();
            AudioFormat audioFormat = CapturePlayback.this.audioInputStream.getFormat();
            if (byArray == null) {
                try {
                    byArray = new byte[(int)(CapturePlayback.this.audioInputStream.getFrameLength() * (long)audioFormat.getFrameSize())];
                    CapturePlayback.this.audioInputStream.read(byArray);
                }
                catch (Exception exception) {
                    CapturePlayback.this.reportStatus(exception.toString());
                    return;
                }
            }
            Dimension dimension = this.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height - 15;
            int[] nArray = null;
            if (audioFormat.getSampleSizeInBits() == 16) {
                byte by;
                byte by2;
                n2 = byArray.length / 2;
                nArray = new int[n2];
                if (audioFormat.isBigEndian()) {
                    n = 0;
                    while (n < n2) {
                        by2 = byArray[2 * n];
                        by = byArray[2 * n + 1];
                        nArray[n] = by2 << 8 | 0xFF & by;
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < n2) {
                        by2 = byArray[2 * n];
                        by = byArray[2 * n + 1];
                        nArray[n] = by << 8 | 0xFF & by2;
                        ++n;
                    }
                }
            } else if (audioFormat.getSampleSizeInBits() == 8) {
                n2 = byArray.length;
                nArray = new int[n2];
                if (audioFormat.getEncoding().toString().startsWith("PCM_SIGN")) {
                    n = 0;
                    while (n < byArray.length) {
                        nArray[n] = byArray[n];
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < byArray.length) {
                        nArray[n] = byArray[n] - 128;
                        ++n;
                    }
                }
            }
            n2 = byArray.length / audioFormat.getFrameSize() / n3;
            n = 0;
            double d = 0.0;
            int n5 = audioFormat.getChannels();
            double d2 = 0.0;
            while (d2 < (double)n3 && nArray != null) {
                int n6 = (int)((double)(n2 * n5) * d2);
                n = audioFormat.getSampleSizeInBits() == 8 ? (int)((byte)nArray[n6]) : (int)((byte)(128 * nArray[n6] / 32768));
                double d3 = n4 * (128 - n) / 256;
                CapturePlayback.this.lines.add(new Line2D.Double(d2, d, d2, d3));
                d = d3;
                d2 += 1.0;
            }
            this.repaint();
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = 15;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(this.getBackground());
            graphics2D.clearRect(0, 0, n, n2);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, n2 - n3, n, n3);
            if (CapturePlayback.this.errStr != null) {
                graphics2D.setColor(this.jfcBlue);
                graphics2D.setFont(new Font("serif", 1, 18));
                graphics2D.drawString("ERROR", 5, 20);
                AttributedString attributedString = new AttributedString(CapturePlayback.this.errStr);
                attributedString.addAttribute(TextAttribute.FONT, this.font12, 0, CapturePlayback.this.errStr.length());
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = 5.0f;
                float f2 = 25.0f;
                lineBreakMeasurer.setPosition(0);
                while (lineBreakMeasurer.getPosition() < CapturePlayback.this.errStr.length()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout((float)n - f - 5.0f);
                    if (!textLayout.isLeftToRight()) {
                        f = (float)n - textLayout.getAdvance();
                    }
                    textLayout.draw(graphics2D, f, f2 += textLayout.getAscent());
                    f2 += textLayout.getDescent() + textLayout.getLeading();
                }
            } else if (CapturePlayback.this.capture.thread != null) {
                graphics2D.setColor(Color.black);
                graphics2D.setFont(this.font12);
                graphics2D.drawString("Length: " + String.valueOf(CapturePlayback.this.seconds), 3, n2 - 4);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.setFont(this.font12);
                graphics2D.drawString("File: " + CapturePlayback.this.fileName + "  Length: " + String.valueOf(CapturePlayback.this.duration) + "  Position: " + String.valueOf(CapturePlayback.this.seconds), 3, n2 - 4);
                if (CapturePlayback.this.audioInputStream != null) {
                    graphics2D.setColor(this.jfcBlue);
                    int n4 = 1;
                    while (n4 < CapturePlayback.this.lines.size()) {
                        graphics2D.draw((Line2D)CapturePlayback.this.lines.get(n4));
                        ++n4;
                    }
                    if (CapturePlayback.this.seconds != 0.0) {
                        double d = CapturePlayback.this.seconds / CapturePlayback.this.duration * (double)n;
                        graphics2D.setColor(this.pink);
                        graphics2D.setStroke(new BasicStroke(3.0f));
                        graphics2D.draw(new Line2D.Double(d, 0.0, d, n2 - n3 - 2));
                    }
                }
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName("SamplingGraph");
            this.thread.start();
            CapturePlayback.this.seconds = 0.0;
        }

        public void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            CapturePlayback.this.seconds = 0.0;
            block4: while (this.thread != null) {
                if (CapturePlayback.this.playback.line != null && CapturePlayback.this.playback.line.isOpen()) {
                    long l = CapturePlayback.this.playback.line.getMicrosecondPosition() / 1000L;
                    CapturePlayback.this.seconds = (double)l / 1000.0;
                } else if (CapturePlayback.this.capture.line != null && CapturePlayback.this.capture.line.isActive()) {
                    long l = CapturePlayback.this.capture.line.getMicrosecondPosition() / 1000L;
                    CapturePlayback.this.seconds = (double)l / 1000.0;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    break;
                }
                this.repaint();
                while (CapturePlayback.this.capture.line != null && !CapturePlayback.this.capture.line.isActive() || CapturePlayback.this.playback.line != null && !CapturePlayback.this.playback.line.isOpen()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        continue block4;
                    }
                }
            }
            CapturePlayback.this.seconds = 0.0;
            this.repaint();
        }
    }

    class FormatControls
    extends JPanel {
        Vector groups = new Vector();
        JToggleButton linrB;
        JToggleButton ulawB;
        JToggleButton alawB;
        JToggleButton rate8B;
        JToggleButton rate11B;
        JToggleButton rate16B;
        JToggleButton rate22B;
        JToggleButton rate44B;
        JToggleButton size8B;
        JToggleButton size16B;
        JToggleButton signB;
        JToggleButton unsignB;
        JToggleButton litB;
        JToggleButton bigB;
        JToggleButton monoB;
        JToggleButton sterB;

        public FormatControls() {
            this.setLayout(new GridLayout(0, 1));
            EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 5);
            BevelBorder bevelBorder = new BevelBorder(1);
            CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, bevelBorder);
            this.setBorder(new CompoundBorder(compoundBorder, new EmptyBorder(8, 5, 5, 5)));
            JPanel jPanel = new JPanel();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.linrB = this.addToggleButton(jPanel, buttonGroup, "linear", true);
            this.ulawB = this.addToggleButton(jPanel, buttonGroup, "ulaw", false);
            this.alawB = this.addToggleButton(jPanel, buttonGroup, "alaw", false);
            this.add(jPanel);
            this.groups.addElement(buttonGroup);
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.rate8B = this.addToggleButton(jPanel2, buttonGroup2, "8000", false);
            this.rate11B = this.addToggleButton(jPanel2, buttonGroup2, "11025", false);
            this.rate16B = this.addToggleButton(jPanel3, buttonGroup2, "16000", false);
            this.rate22B = this.addToggleButton(jPanel3, buttonGroup2, "22050", false);
            this.rate44B = this.addToggleButton(jPanel3, buttonGroup2, "44100", true);
            this.add(jPanel2);
            this.add(jPanel3);
            this.groups.addElement(buttonGroup2);
            JPanel jPanel4 = new JPanel();
            ButtonGroup buttonGroup3 = new ButtonGroup();
            this.size8B = this.addToggleButton(jPanel4, buttonGroup3, "8", false);
            this.size16B = this.addToggleButton(jPanel4, buttonGroup3, "16", true);
            this.add(jPanel4);
            this.groups.addElement(buttonGroup3);
            JPanel jPanel5 = new JPanel();
            ButtonGroup buttonGroup4 = new ButtonGroup();
            this.signB = this.addToggleButton(jPanel5, buttonGroup4, "signed", true);
            this.unsignB = this.addToggleButton(jPanel5, buttonGroup4, "unsigned", false);
            this.add(jPanel5);
            this.groups.addElement(buttonGroup4);
            JPanel jPanel6 = new JPanel();
            ButtonGroup buttonGroup5 = new ButtonGroup();
            this.litB = this.addToggleButton(jPanel6, buttonGroup5, "little endian", false);
            this.bigB = this.addToggleButton(jPanel6, buttonGroup5, "big endian", true);
            this.add(jPanel6);
            this.groups.addElement(buttonGroup5);
            JPanel jPanel7 = new JPanel();
            ButtonGroup buttonGroup6 = new ButtonGroup();
            this.monoB = this.addToggleButton(jPanel7, buttonGroup6, "mono", false);
            this.sterB = this.addToggleButton(jPanel7, buttonGroup6, "stereo", true);
            this.add(jPanel7);
            this.groups.addElement(buttonGroup6);
        }

        private JToggleButton addToggleButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl) {
            JToggleButton jToggleButton = new JToggleButton(string, bl);
            jPanel.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            return jToggleButton;
        }

        public AudioFormat getFormat() {
            int n;
            Object object;
            Object object2;
            Vector<String> vector = new Vector<String>(this.groups.size());
            int n2 = 0;
            while (n2 < this.groups.size()) {
                object2 = (ButtonGroup)this.groups.get(n2);
                object = ((ButtonGroup)object2).getElements();
                while (object.hasMoreElements()) {
                    AbstractButton abstractButton = (AbstractButton)object.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    vector.add(abstractButton.getText());
                    break;
                }
                ++n2;
            }
            object2 = AudioFormat.Encoding.ULAW;
            object = (String)vector.get(0);
            float f = Float.valueOf((String)vector.get(1)).floatValue();
            int n3 = Integer.valueOf((String)vector.get(2));
            String string = (String)vector.get(3);
            boolean bl = ((String)vector.get(4)).startsWith("big");
            int n4 = n = ((String)vector.get(5)).equals("mono") ? 1 : 2;
            if (((String)object).equals("linear")) {
                object2 = string.equals("signed") ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
            } else if (((String)object).equals("alaw")) {
                object2 = AudioFormat.Encoding.ALAW;
            }
            return new AudioFormat((AudioFormat.Encoding)object2, f, n3, n, n3 / 8 * n, f, bl);
        }

        public void setFormat(AudioFormat audioFormat) {
            AudioFormat.Encoding encoding = audioFormat.getEncoding();
            if (encoding == AudioFormat.Encoding.ULAW) {
                this.ulawB.doClick();
            } else if (encoding == AudioFormat.Encoding.ALAW) {
                this.alawB.doClick();
            } else if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                this.linrB.doClick();
                this.signB.doClick();
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                this.linrB.doClick();
                this.unsignB.doClick();
            }
            float f = audioFormat.getFrameRate();
            if (f == 8000.0f) {
                this.rate8B.doClick();
            } else if (f == 11025.0f) {
                this.rate11B.doClick();
            } else if (f == 16000.0f) {
                this.rate16B.doClick();
            } else if (f == 22050.0f) {
                this.rate22B.doClick();
            } else if (f == 44100.0f) {
                this.rate44B.doClick();
            }
            switch (audioFormat.getSampleSizeInBits()) {
                case 8: {
                    this.size8B.doClick();
                    break;
                }
                case 16: {
                    this.size16B.doClick();
                }
            }
            if (audioFormat.isBigEndian()) {
                this.bigB.doClick();
            } else {
                this.litB.doClick();
            }
            if (audioFormat.getChannels() == 1) {
                this.monoB.doClick();
            } else {
                this.sterB.doClick();
            }
        }
    }

    class Capture
    implements Runnable {
        TargetDataLine line;
        Thread thread;
        static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

        Capture() {
        }

        public void start() {
            CapturePlayback.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName("Capture");
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String string) {
            CapturePlayback.this.errStr = string;
            if (CapturePlayback.this.errStr != null && this.thread != null) {
                this.thread = null;
                CapturePlayback.this.samplingGraph.stop();
                CapturePlayback.this.loadB.setEnabled(true);
                CapturePlayback.this.playB.setEnabled(true);
                CapturePlayback.this.pausB.setEnabled(false);
                CapturePlayback.this.auB.setEnabled(true);
                CapturePlayback.this.aiffB.setEnabled(true);
                CapturePlayback.this.waveB.setEnabled(true);
                CapturePlayback.this.captB.setText("Record");
                System.err.println(CapturePlayback.this.errStr);
                CapturePlayback.this.samplingGraph.repaint();
            }
        }

        public void run() {
            AudioFormat audioFormat;
            CapturePlayback.this.duration = 0.0;
            CapturePlayback.this.audioInputStream = null;
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = Capture.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormat = CapturePlayback.this.formatControls.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown("Line matching " + info + " not supported.");
                return;
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(audioFormat, this.line.getBufferSize());
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.shutDown("Unable to open the line: " + lineUnavailableException);
                return;
            }
            catch (SecurityException securityException) {
                this.shutDown(securityException.toString());
                JavaSound.showInfoDialog();
                return;
            }
            catch (Exception exception) {
                this.shutDown(exception.toString());
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = audioFormat.getFrameSize();
            int n2 = this.line.getBufferSize() / 8;
            int n3 = n2 * n;
            byte[] byArray = new byte[n3];
            this.line.start();
            while (this.thread != null) {
                int n4 = this.line.read(byArray, 0, n3);
                if (n4 == -1) break;
                byteArrayOutputStream.write(byArray, 0, n4);
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            CapturePlayback.this.audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray2.length / n);
            long l = (long)((float)(CapturePlayback.this.audioInputStream.getFrameLength() * 1000L) / audioFormat.getFrameRate());
            CapturePlayback.this.duration = (double)l / 1000.0;
            try {
                CapturePlayback.this.audioInputStream.reset();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            CapturePlayback.this.samplingGraph.createWaveForm(byArray2);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class Playback
    implements Runnable {
        SourceDataLine line;
        Thread thread;
        static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

        public void start() {
            CapturePlayback.this.errStr = null;
            this.thread = new Thread(this);
            this.thread.setName("Playback");
            this.thread.start();
        }

        public void stop() {
            this.thread = null;
        }

        private void shutDown(String string) {
            CapturePlayback.this.errStr = string;
            if (CapturePlayback.this.errStr != null) {
                System.err.println(CapturePlayback.this.errStr);
                CapturePlayback.this.samplingGraph.repaint();
            }
            if (this.thread != null) {
                this.thread = null;
                CapturePlayback.this.samplingGraph.stop();
                CapturePlayback.this.captB.setEnabled(true);
                CapturePlayback.this.pausB.setEnabled(false);
                CapturePlayback.this.playB.setText("Play");
            }
        }

        public void run() {
            if (CapturePlayback.this.file != null) {
                CapturePlayback.this.createAudioInputStream(CapturePlayback.this.file, false);
            }
            if (CapturePlayback.this.audioInputStream == null) {
                this.shutDown("No loaded audio to play back");
                return;
            }
            try {
                CapturePlayback.this.audioInputStream.reset();
            }
            catch (Exception exception) {
                this.shutDown("Unable to reset the stream\n" + exception);
                return;
            }
            AudioFormat audioFormat = CapturePlayback.this.formatControls.getFormat();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioFormat, CapturePlayback.this.audioInputStream);
            if (audioInputStream == null) {
                this.shutDown("Unable to convert stream of format " + CapturePlayback.this.audioInputStream + " to format " + audioFormat);
                return;
            }
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = Playback.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown("Line matching " + info + " not supported.");
                return;
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(audioFormat, 16384);
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.shutDown("Unable to open the line: " + lineUnavailableException);
                return;
            }
            int n = audioFormat.getFrameSize();
            int n2 = this.line.getBufferSize() / 8;
            int n3 = n2 * n;
            byte[] byArray = new byte[n3];
            int n4 = 0;
            this.line.start();
            while (this.thread != null) {
                try {
                    n4 = audioInputStream.read(byArray);
                    if (n4 == -1) break;
                    int n5 = n4;
                    while (n5 > 0) {
                        n5 -= this.line.write(byArray, 0, n5);
                    }
                }
                catch (Exception exception) {
                    this.shutDown("Error during playback: " + exception);
                    break;
                }
            }
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
            this.shutDown(null);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

