/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.ConvertFile;
import sun.plugin.converter.engine.ConvertSet;
import sun.plugin.converter.engine.Converter;
import sun.plugin.converter.engine.ConverterProgressEvent;
import sun.plugin.converter.engine.ConverterProgressListener;
import sun.plugin.converter.engine.DefaultSet;
import sun.plugin.converter.util.FlexFilter;
import sun.plugin.converter.util.NotDirectoryException;
import sun.plugin.converter.util.PrintManyPlaces;
import sun.plugin.converter.util.StdUtils;

public class PluginConverter
implements Converter,
Runnable {
    private String templateFilePath = null;
    private static String defaultTemplateFileName = "templates/default.tpl";
    private File logFile = null;
    private boolean createLog = false;
    private boolean processSubDirs = false;
    private boolean stopConversion = false;
    private static ConverterProgressEvent event = null;
    private String cabFileLocation = null;
    private String nsFileLocation = null;
    private String smartUpdateLocation = null;
    private String mimeType = null;
    private String version = "1.3.1";
    private String nodotVersion = "131";
    private String cabVersion = "1,3,1,0";
    private String urlString = "http://java.sun.com/products/plugin/" + this.version;
    private String defaultCabFileLocation = this.urlString + "/jinstall-" + this.nodotVersion + "-win32.cab#Version=" + this.cabVersion;
    private String defaultNsFileLocation = this.urlString + "/newuser.html";
    private String defaultSmartUpdateLocation = this.urlString + "/jre-" + this.nodotVersion + "-win32.jar";
    private String defaultMimeType = "application/x-java-applet;jpi-version=" + this.version;
    private String userPropsFileName = "converter.props";
    private String defaultPropsFileName = "default.props";
    private String defaultLogFileName = "convertlog.txt";
    private String caption = null;
    private boolean commandLineInvocation = false;
    private static final String propFileHeader = "#  Java Plug-in HTML Converter Properties";
    private ConvertSet convertSet = null;
    private boolean showProgressStdOut = true;
    private PrintManyPlaces printer = null;
    private OutputStream log = null;
    private PrintStream progress = null;
    private boolean debug = false;
    private Vector listeners = new Vector();
    private Thread runConvert = null;

    public PluginConverter() throws FileNotFoundException {
        this(false, false);
    }

    public PluginConverter(boolean bl, boolean bl2) throws FileNotFoundException {
        this.setCreateLog(bl);
        this.setShowProgressStdOut(bl2);
        try {
            this.setTemplateFilePath(this.getDefaultTemplateFilePath());
            if (this.createLog) {
                this.setLogFile(this.getDefaultLogFile());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        try {
            try {
                Properties properties = new Properties();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.defaultPropsFileName);
                properties.load(inputStream);
                inputStream.close();
                inputStream = null;
                this.defaultCabFileLocation = properties.getProperty("converter.cab.file.loc", "");
                this.defaultNsFileLocation = properties.getProperty("converter.plugin.file.loc", "");
                this.defaultSmartUpdateLocation = properties.getProperty("converter.smartupdate.file.loc", "");
                this.defaultMimeType = properties.getProperty("converter.template.mimetype", "");
                File file = new File(this.userPropsFileName);
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, propFileHeader);
                    fileOutputStream.close();
                }
                this.cabFileLocation = properties.getProperty("converter.cab.file.loc", this.defaultCabFileLocation);
                this.nsFileLocation = properties.getProperty("converter.plugin.file.loc", this.defaultNsFileLocation);
                this.smartUpdateLocation = properties.getProperty("converter.smartupdate.file.loc", this.defaultSmartUpdateLocation);
                this.mimeType = properties.getProperty("converter.template.mimetype", this.defaultMimeType);
                this.caption = ResourceHandler.getMessage("caption.warning");
            }
            catch (IOException iOException) {
                String string = ResourceHandler.getMessage("plugin_converter.propnotfound2");
                JOptionPane.showMessageDialog(null, string, this.caption, 2);
                Object var9_13 = null;
                if (this.cabFileLocation == null) {
                    this.cabFileLocation = this.defaultCabFileLocation;
                }
                if (this.nsFileLocation == null) {
                    this.nsFileLocation = this.defaultNsFileLocation;
                }
            }
            Object var9_12 = null;
            if (this.cabFileLocation == null) {
                this.cabFileLocation = this.defaultCabFileLocation;
            }
            if (this.nsFileLocation == null) {
                this.nsFileLocation = this.defaultNsFileLocation;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (this.cabFileLocation == null) {
                this.cabFileLocation = this.defaultCabFileLocation;
            }
            if (this.nsFileLocation == null) {
                this.nsFileLocation = this.defaultNsFileLocation;
            }
            throw throwable;
        }
    }

    public void persistConverterSetting() {
        Properties properties = new Properties();
        File file = null;
        try {
            file = new File(this.userPropsFileName);
            if (this.nsFileLocation != null) {
                ((Hashtable)properties).put("converter.plugin.file.loc", this.nsFileLocation);
            }
            if (this.cabFileLocation != null) {
                ((Hashtable)properties).put("converter.cab.file.loc", this.cabFileLocation);
            }
            if (this.smartUpdateLocation != null) {
                ((Hashtable)properties).put("converter.smartupdate.file.loc", this.smartUpdateLocation);
            }
            if (this.mimeType != null) {
                ((Hashtable)properties).put("converter.template.mimetype", this.mimeType);
            }
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, propFileHeader);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.saveerror"));
        }
    }

    public void setConvertSet(ConvertSet convertSet) {
        this.convertSet = convertSet;
    }

    public ConvertSet getConvertSet() {
        return this.convertSet;
    }

    public void setShowProgressStdOut(boolean bl) {
        if (this.showProgressStdOut != bl) {
            this.showProgressStdOut = bl;
        }
    }

    public boolean isShowProgressStdOut() {
        return this.showProgressStdOut;
    }

    public void setCommandLine(boolean bl) {
        this.commandLineInvocation = bl;
    }

    public boolean getCommandLine() {
        return this.commandLineInvocation;
    }

    public void addConverterProgressListener(ConverterProgressListener converterProgressListener) {
        this.listeners.addElement(converterProgressListener);
    }

    public void removedConverterProgressListener(ConverterProgressListener converterProgressListener) {
        this.listeners.removeElement(converterProgressListener);
    }

    public void fireEvent(ConverterProgressEvent converterProgressEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ConverterProgressListener converterProgressListener = (ConverterProgressListener)vector.elementAt(n);
            converterProgressListener.converterProgressUpdate(converterProgressEvent);
            ++n;
        }
    }

    public void startConversion() {
        if (this.debug) {
            System.out.println("Debug is on");
        }
        if (this.runConvert == null) {
            this.runConvert = new Thread(this);
            this.runConvert.start();
        }
    }

    public void stopConversion() {
        if (this.runConvert != null && this.runConvert.isAlive()) {
            this.stopConversion = true;
            if (this.progress != null) {
                this.progress.println(ResourceHandler.getMessage("plugin_converter.cancel"));
            }
        }
        this.runConvert = null;
    }

    public void run() {
        try {
            this.setPrintOutput();
        }
        catch (IOException iOException) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.logerror"));
        }
        Date date = new Date();
        if (this.progress != null) {
            this.progress.println(ResourceHandler.getMessage("plugin_converter.appletconv") + DateFormat.getDateInstance(1).format(date) + " " + DateFormat.getTimeInstance(1).format(date));
        }
        event = new ConverterProgressEvent(this);
        this.stopConversion = false;
        try {
            this.runConversion(this.convertSet);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        event.setStatus(-14);
        this.fireEvent(event);
        if (this.progress != null) {
            this.progress.println(ResourceHandler.getMessage("plugin_converter.done") + event.getFilesProcessed() + ResourceHandler.getMessage("plugin_converter.appletfound") + event.getAppletsFound());
        }
        if (this.getCommandLine()) {
            System.exit(0);
        }
    }

    private void runConversion(ConvertSet convertSet) throws IOException {
        Enumeration enumeration = convertSet.getFilesEnumeration();
        while (enumeration.hasMoreElements() && !this.stopConversion) {
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            File file = new File(convertSet.getDestinationPath(), "temp.conv");
            File file2 = new File(convertSet.getSourcePath(), string);
            if (file2.isDirectory()) {
                if (!this.processSubDirs) continue;
                object2 = new DefaultSet();
                boolean bl = ((FlexFilter)convertSet.getFilenameFilter()).isFilesOnly();
                ((FlexFilter)((DefaultSet)object2).getFilenameFilter()).setFilesOnly(bl);
                try {
                    object2.setSourcePath(file2, convertSet.getFilenameFilter());
                }
                catch (NotDirectoryException notDirectoryException) {
                    notDirectoryException.printStackTrace();
                }
                object2.setDestinationPath(new File(convertSet.getDestinationPath(), string));
                object2.setBackupPath(new File(convertSet.getBackupPath(), string));
                this.runConversion((ConvertSet)object2);
                continue;
            }
            if (file2.exists()) {
                if (!file2.canWrite()) {
                    JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_unwritable.info") + file2, this.caption, 0);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_notexists.info") + file2, this.caption, 0);
                return;
            }
            object2 = this.getClass().getClassLoader().getResourceAsStream(this.getTemplateFilePath());
            if (object2 == null) {
                object = new File(this.getTemplateFilePath());
                object2 = new FileInputStream((File)object);
            }
            object = new ConvertFile((InputStream)object2);
            ((ConvertFile)object).setSource(file2);
            ((ConvertFile)object).guessEncoding();
            if (StdUtils.countWords(file2, "<APPLET", true, ((ConvertFile)object).getEncoding()) > 0) {
                if (this.progress != null) {
                    this.progress.print(new File(convertSet.getSourcePath(), string) + ResourceHandler.getMessage("plugin_converter.processing"));
                }
                event.setSourcePath(convertSet.getSourcePath().getAbsolutePath());
                event.setDestinationPath(convertSet.getDestinationPath().getAbsolutePath());
                event.setBackupPath(convertSet.getBackupPath().getAbsolutePath());
                event.setCurrentFile(string);
                event.setStatus(-11);
                this.fireEvent(event);
                ((ConvertFile)object).setSource(file2);
                ((ConvertFile)object).setDestination(file);
                ((ConvertFile)object).setCabFileLocation(this.getCabFileLocation());
                ((ConvertFile)object).setNSFileLocation(this.getNSFileLocation());
                ((ConvertFile)object).setSmartUpdateLocation(this.getSmartUpdateLocation());
                ((ConvertFile)object).setMimeType(this.getMimeType());
                try {
                    boolean bl = ((ConvertFile)object).convert();
                    if (!bl) {
                        if (this.progress != null) {
                            this.progress.print(ResourceHandler.getMessage("plugin_converter.converted"));
                        }
                        file.delete();
                    } else {
                        if (!StdUtils.createDirs(convertSet.getBackupPath())) {
                            if (this.progress != null) {
                                this.progress.println(ResourceHandler.getMessage("plugin_converter.nobackuppath"));
                            }
                            event.setStatus(-15);
                            this.fireEvent(event);
                            JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_unwritable.info") + convertSet.getBackupPath().getAbsolutePath(), this.caption, 0);
                            return;
                        }
                        System.gc();
                        System.runFinalization();
                        File file3 = new File(convertSet.getBackupPath().getAbsolutePath(), string);
                        File file4 = new File(file.getParent() + File.separator + string);
                        if (!this.updateFiles(file3, file4, file)) {
                            JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("plugin_converter.failure") + file.getParent() + File.separator + string, this.caption, 0);
                        }
                    }
                    event.setStatus(-13);
                    event.setFilesProcessed(event.getFilesProcessed() + 1);
                    event.setAppletsFound(event.getAppletsFound() + ((ConvertFile)object).getAppletsFound());
                    event.setErrorsFound(event.getErrorsFound() + ((ConvertFile)object).getErrors());
                    this.fireEvent(event);
                    if (this.progress == null) continue;
                    this.progress.println(ResourceHandler.getMessage("plugin_converter.donefound") + ((ConvertFile)object).getAppletsFound());
                }
                catch (Exception exception) {
                    event.setStatus(-16);
                    event.setFilesProcessed(event.getFilesProcessed());
                    event.setAppletsFound(event.getAppletsFound() + ((ConvertFile)object).getAppletsFound());
                    event.setErrorsFound(event.getErrorsFound() + 1);
                    this.fireEvent(event);
                    if (this.progress == null) continue;
                    this.progress.println(ResourceHandler.getMessage("plugin_converter.seetrace"));
                    exception.printStackTrace(this.progress);
                }
                continue;
            }
            if (this.progress == null) continue;
            this.progress.println(ResourceHandler.getMessage("plugin_converter.noapplet") + file2);
        }
    }

    public boolean updateFiles(File file, File file2, File file3) {
        return this.backupFileIsWritable(file, file2) && file2.renameTo(file) && file3.renameTo(file2);
    }

    public boolean backupFileIsWritable(File file, File file2) {
        if (file.exists()) {
            if (JOptionPane.showConfirmDialog(null, ResourceHandler.getMessage("plugin_converter.overwrite1") + file2.getAbsolutePath() + ResourceHandler.getMessage("plugin_converter.overwrite2"), this.caption, 0) == 0) {
                file.delete();
            } else {
                return false;
            }
        }
        return true;
    }

    public static String getDefaultTemplateFileName() {
        return defaultTemplateFileName;
    }

    public void setTemplateFilePath(String string) throws FileNotFoundException {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                this.templateFilePath = string;
                return;
            }
            File file = new File(string);
            if (file.isFile()) {
                this.templateFilePath = string;
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        throw new FileNotFoundException(string);
    }

    public String getTemplateFilePath() {
        return this.templateFilePath;
    }

    public String getDefaultTemplateFilePath() throws FileNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new FileNotFoundException(defaultTemplateFileName);
        }
        InputStream inputStream = classLoader.getResourceAsStream(defaultTemplateFileName);
        if (inputStream == null) {
            throw new FileNotFoundException(defaultTemplateFileName);
        }
        return defaultTemplateFileName;
    }

    public void setLogFile(File file) throws IllegalArgumentException {
        if (file.exists()) {
            if (this.progress != null) {
                this.progress.println(ResourceHandler.getMessage("plugin_converter.writelog"));
            }
        } else if (file.getParent() == null) {
            file = new File(System.getProperty("user.dir"), file.getName());
        } else {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        this.logFile = file;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getDefaultLogFile() {
        return new File(System.getProperty("user.dir"), this.defaultLogFileName);
    }

    public void setPrintOutput() throws IOException {
        if (this.printer != null) {
            this.printer.closeAll();
        }
        this.printer = new PrintManyPlaces();
        if (this.showProgressStdOut || this.debug) {
            this.printer.addPlace(System.out);
        }
        if (this.createLog) {
            this.printer.addPlace(new FileOutputStream(this.getLogFile()));
        }
        this.progress = this.printer.countPlaces() > 0 ? new PrintStream(this.printer) : null;
    }

    public void setCreateLog(boolean bl) {
        if (bl != this.createLog) {
            this.createLog = bl;
        }
    }

    public boolean isCreateLog() {
        return this.createLog;
    }

    public void setRecurse(boolean bl) {
        ((FlexFilter)this.convertSet.getFilenameFilter()).setFilesOnly(!bl);
        this.processSubDirs = bl;
    }

    public boolean isRecurse() {
        return this.processSubDirs;
    }

    public String getCabFileLocation() {
        return this.cabFileLocation;
    }

    public String getDefaultCabFileLocation() {
        return this.defaultCabFileLocation;
    }

    public void setCabFileLocation(String string) {
        this.cabFileLocation = string;
    }

    public String getNSFileLocation() {
        return this.nsFileLocation;
    }

    public String getDefaultNSFileLocation() {
        return this.defaultNsFileLocation;
    }

    public void setNSFileLocation(String string) {
        this.nsFileLocation = string;
    }

    public String getSmartUpdateLocation() {
        return this.smartUpdateLocation;
    }

    public String getDefaultSmartUpdateLocation() {
        return this.defaultSmartUpdateLocation;
    }

    public void setSmartUpdateLocation(String string) {
        this.smartUpdateLocation = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String toString() {
        String string = "";
        string = string + "\nShow Progress StdOut:  " + this.showProgressStdOut;
        string = string + "\ndebug:  " + this.debug;
        string = string + "\nTemplate File Path:  " + this.templateFilePath.toString();
        string = string + "\nCount Listeners:  " + this.listeners.size();
        string = string + "\nLog File Path:  " + this.logFile.toString();
        string = string + "\nCreate Log:  " + this.createLog;
        string = string + "\nConvert Set:  " + this.convertSet.toString();
        string = string + "\nProcess Sub Dirs:  " + this.processSubDirs;
        return string;
    }
}

