/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mpeg3private.h"
#include "mpeg3protos.h"

#include <stdio.h>
#include <mntent.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>

mpeg3_fs_t* mpeg3_new_fs(xmps_media_plugin_t *media)
{
  mpeg3_fs_t *fs = calloc(1, sizeof(mpeg3_fs_t));
  
  if(media == NULL) {
    
    XMPS_DEBUG("null media!");

    free(fs);
    return NULL;
  }

  fs->media = media;
  
  return fs;
}

int mpeg3_delete_fs(mpeg3_fs_t *fs)
{
  free(fs);
  
  return 0;
}

int mpeg3_copy_fs(mpeg3_fs_t *dst, mpeg3_fs_t *src)
{
  dst->media = src->media;
  dst->current_byte = 0;
  
  return 0;
}

long mpeg3io_get_total_bytes(mpeg3_fs_t *fs)
{
  fs->total_bytes = fs->media->seek(fs->media, 0, XMPS_SEEK_END);
  
  fs->media->seek(fs->media, 0, XMPS_SEEK_SET);

  return fs->total_bytes;
}

int mpeg3io_open_file(mpeg3_fs_t *fs)
{
  if(fs->media == NULL) {

    XMPS_DEBUG("open media error!!");
    return 1;
  }
  
  fs->total_bytes = mpeg3io_get_total_bytes(fs);
	
  if(!fs->total_bytes) {
    return 1;
  }
  
  fs->current_byte = 0;
  return 0;
}

int mpeg3io_close_file(mpeg3_fs_t *fs)
{
  return 0;
}

int mpeg3io_read_data(unsigned char *buffer, long bytes, mpeg3_fs_t *fs)
{
  int result = 0;
  
  result = fs->media->read(fs->media, buffer, bytes);
  
  fs->current_byte += bytes;

  return 0;
}

int mpeg3io_seek(mpeg3_fs_t *fs, long byte)
{
  fs->current_byte = byte;
  
  fs->media->seek(fs->media, byte, XMPS_SEEK_SET);

  return 0;
}

int mpeg3io_seek_relative(mpeg3_fs_t *fs, long bytes)
{
  fs->current_byte += bytes;

  fs->media->seek(fs->media, fs->current_byte, XMPS_SEEK_SET);

  return 0;
}










