/*  XMPS - X Movie Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "libxmps.h"

/*
 * functions
 *
 */

unsigned int xmps_plugin_graph_add_node(xmps_plugin_graph_t *plugin_graph,
                                        xmps_plugin_types_t type,
                                        void *plugin)
{
  xmps_plugin_graph_node_t *node;

  if(plugin_graph == NULL) {
    return 0;
  }

  node = (xmps_plugin_graph_node_t *) malloc(sizeof(xmps_plugin_graph_node_t));

  node->plugin_type = type;
  node->plugin      = plugin;

  plugin_graph->nodes = g_list_append(plugin_graph->nodes, (void *) node);

  return 1;
}


unsigned int xmps_plugin_graph_add_link(xmps_plugin_graph_t *plugin_graph,
                                        void *plugin1, void *plugin2)
{
  xmps_plugin_graph_link_t *link;

  if(plugin_graph == NULL) {
    return 0;
  }

  link = (xmps_plugin_graph_link_t *) malloc(sizeof(xmps_plugin_graph_link_t));

  link->plugin_source = plugin1;
  link->plugin_dest   = plugin2;

  plugin_graph->links = g_list_append(plugin_graph->links, (void *) link);

  return 1;
}
