/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_events.c
 *
 *  Code file for the internal event queue.
 *  @Author : Damien Chavarria (1999)
 *
 */

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

/*
 * includes : local
 *
 */

#include "libxmps.h"

/*********************************************************************
 *                            VARIABLES                              *
 *********************************************************************/

GList *xmps_event_list = NULL;

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/

/*
 * push_xmps_event
 * 
 * - add an event to the queue 
 *
 */

void push_xmps_event(gint event)
{
	gint *item;

	/* 
	 * make the item 
	 *
	 */
	
	item = (gint *) g_malloc(sizeof(gint));
	
	(*item) = event;
  
	/* 
	 * we add it 
	 *
	 */
	
	xmps_event_list = g_list_append(xmps_event_list, item);
}

/*
 * push_xmps_event
 * 
 * - removes oldest event in queue
 *
 */

gint pop_xmps_event(void)
{
	gint event;
  
	if(xmps_event_list == NULL)
	{
		return XMPS_EVENT_NO_EVENT;
	}
	else
	{
		event = (gint) (* (gint*) xmps_event_list->data);
		xmps_event_list = g_list_next(xmps_event_list);
		
		return event;
	}
}
