/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_graphics.c
 *
 *  Functions for handling the graphic stucture
 *  of the program (mouse clics...) 
 *  @Author : Damien Chavarria (1999)
 *
 */


/* includes */

#include "xmps_graphics.h"

/* functions */

/****************** is_inside_rect ********************
 * 						      *
 * Return TRUE if the point (x,y) is inside the rect  *
 * 						      *
 ******************************************************/

gint is_inside_rect(gint x, gint y, xmps_rect rect)
 {
  if ((x >= rect.start_x) && (x <= rect.start_x + rect.size_x) &&
      (y >= rect.start_y) && (y <= rect.start_y + rect.size_y))
   return TRUE;
  else
  return FALSE; 
 }

/***************** get_selected_zone ******************
 * 						      *
 * Return the zone corresponding to the mouse clic    *
 * 						      *
 ******************************************************/

gint get_selected_zone(gint x, gint y) 
 {
  if (is_inside_rect(x, y, xmps_config.progress_bar.cursor_rect))
    return PROGRESS_BAR_CURSOR;

  if (is_inside_rect(x, y, xmps_config.volume_bar.cursor_rect))
   return VOLUME_BAR_CURSOR;

  if (is_inside_rect(x, y, xmps_config.balance_bar.cursor_rect))
   return BALANCE_BAR_CURSOR;

  if (is_inside_rect(x, y, ABOUT_MENU_RECT))
   return ABOUT_MENU;
   
  if (is_inside_rect(x, y, TITLE_RECT))
   return TITLE;

  if (is_inside_rect(x, y, CLOSE_RECT))
   return CLOSE;
   
  if (is_inside_rect(x, y, INVERT_TIME_RECT))
   return INVERT_TIME;
   
  if (is_inside_rect(x, y, LOOP_RECT))
   return LOOP;
   
  if (is_inside_rect(x, y, DIGITS_RECT))
   return DIGITS;
   
  if (is_inside_rect(x, y, SMALL_DIGITS_RECT))
   return SMALL_DIGITS;
   
  if (is_inside_rect(x, y, FULL_SCREEN_BUTTON_RECT))
   return FULL_SCREEN_BUTTON;
   
  if (is_inside_rect(x, y, LOOP_BUTTON_RECT))
   return LOOP_BUTTON;
   
  if (is_inside_rect(x, y, BALANCE_BAR_RECT))
   return BALANCE_BAR;
   
  if (is_inside_rect(x, y, VOLUME_BAR_RECT))
   return VOLUME_BAR;
   
  if (is_inside_rect(x, y, PLAYLIST_BUTTON_RECT))
   return PLAYLIST_BUTTON;
   
  if (is_inside_rect(x, y, REWIND_BUTTON_RECT))
   return REWIND_BUTTON;
   
  if (is_inside_rect(x, y, STOP_BUTTON_RECT))
   return STOP_BUTTON;
  
  if (is_inside_rect(x, y, PLAY_BUTTON_RECT))
   return PLAY_BUTTON;
  
  if (is_inside_rect(x, y, PAUSE_BUTTON_RECT))
   return PAUSE_BUTTON;

  if (is_inside_rect(x, y, FAST_FORWARD_BUTTON_RECT))
   return FAST_FORWARD_BUTTON;
  
  if (is_inside_rect(x, y, LOAD_BUTTON_RECT))
   return LOAD_BUTTON;
  
  if (is_inside_rect(x, y, RESIZE_RECT))
   return RESIZE;

  if (is_inside_rect(x, y, PROGRESS_BAR_RECT))
   return PROGRESS_BAR;
  else
   return OTHER;
 }

/************ playlist_get_selected_zone **************
 * 						      *
 * Return the zone corresponding to the mouse clic    *
 * 						      *
 ******************************************************/

gint playlist_get_selected_zone(gdouble x, gdouble y)
 {
  if (is_inside_rect(x, y, PLAYLIST_CURSOR_RECT))
   return PLAYLIST_CURSOR;

  if (is_inside_rect(x, y, PLAYLIST_MENU_RECT))
   return PLAYLIST_MENU;
   
  if (is_inside_rect(x, y, PLAYLIST_TITLE_RECT))
   return PLAYLIST_TITLE;

  if (is_inside_rect(x, y, PLAYLIST_CLOSE_RECT))
   return PLAYLIST_CLOSE;
   
  if (is_inside_rect(x, y, PLAYLIST_ITEMS_RECT))
   return PLAYLIST_ITEMS;
   
  if (is_inside_rect(x, y, PLAYLIST_ADD_BUTTON_RECT))
   return PLAYLIST_ADD_BUTTON;
   
  if (is_inside_rect(x, y, PLAYLIST_REMOVE_BUTTON_RECT))
   return PLAYLIST_REMOVE_BUTTON;
   
  if (is_inside_rect(x, y, PLAYLIST_SORT_BUTTON_RECT))
   return PLAYLIST_SORT_BUTTON;
   
  if (is_inside_rect(x, y, PLAYLIST_RAND_BUTTON_RECT))
   return PLAYLIST_RAND_BUTTON;
   
  if (is_inside_rect(x, y, PLAYLIST_RESIZE_RECT))
   return PLAYLIST_RESIZE;
  else
   return OTHER;
 
 }


/***************** refresh zones rects ****************
 * 						      *
 * reinitialize the variables (rects, pixmaps)	      *
 * 						      *
 ******************************************************/

void refresh_zone_rects()
{
  gint dx, dy, p_dy = 0, nbr_pos;
  dx = xmps_config.window_size_x - 275;
  dy = xmps_config.window_size_y - 150;
  
  p_dy = 15*(xmps_config.playlist_nbr_lines-3);
  
  /* Initialisation of description rectangles for the zones */
  
  /* ABOUT_MENU */
  ABOUT_MENU_RECT.start_x = 5;
  ABOUT_MENU_RECT.start_y = 5;
  ABOUT_MENU_RECT.size_x = 18;
  ABOUT_MENU_RECT.size_y = 18;

  /* TITLE */
  TITLE_RECT.start_x = 23;
  TITLE_RECT.start_y =  5;
  TITLE_RECT.size_x = 229+dx;
  TITLE_RECT.size_y = 18;

  /* CLOSE */
  CLOSE_RECT.start_x = 252+dx;
  CLOSE_RECT.start_y = 5;
  CLOSE_RECT.size_x = 18;
  CLOSE_RECT.size_y = 18;

  /* INVERT_TIME */
  INVERT_TIME_RECT.start_x = 129+dx;
  INVERT_TIME_RECT.start_y = 32;
  INVERT_TIME_RECT.size_x = 10;
  INVERT_TIME_RECT.size_y = 7;

  /* LOOP */
  LOOP_RECT.start_x = 129+dx;
  LOOP_RECT.start_y = 41;
  LOOP_RECT.size_x = 10;
  LOOP_RECT.size_y = 9;

  /* DIGITS */
  DIGITS_RECT.start_x = 144+dx;
  DIGITS_RECT.start_y = 31 ;
  DIGITS_RECT.size_x = 75;
  DIGITS_RECT.size_y = 31;

  /* SMALL_DIGITS */
  SMALL_DIGITS_RECT.start_x = 223+dx;
  SMALL_DIGITS_RECT.start_y = 42;
  SMALL_DIGITS_RECT.size_x = 37;
  SMALL_DIGITS_RECT.size_y = 11;

  /* FULL_SCREEN_BUTTON */
  FULL_SCREEN_BUTTON_RECT.start_x = 124+dx;
  FULL_SCREEN_BUTTON_RECT.start_y = 75;
  FULL_SCREEN_BUTTON_RECT.size_x = 22;
  FULL_SCREEN_BUTTON_RECT.size_y = 16;

  /* LOOP_BUTTON */
  LOOP_BUTTON_RECT.start_x = 124+dx;
  LOOP_BUTTON_RECT.start_y = 94;
  LOOP_BUTTON_RECT.size_x = 22;
  LOOP_BUTTON_RECT.size_y = 16;

  /* BALANCE_BAR */
  BALANCE_BAR_RECT.start_x = 155+dx;
  BALANCE_BAR_RECT.start_y = 82;
  BALANCE_BAR_RECT.size_x = 81;
  BALANCE_BAR_RECT.size_y = 11;

  /* VOLUME_BAR */
  VOLUME_BAR_RECT.start_x = 155+dx;
  VOLUME_BAR_RECT.start_y = 100;
  VOLUME_BAR_RECT.size_x = 111;
  VOLUME_BAR_RECT.size_y = 11;

  /* PLAYLIST_BUTTON */
  PLAYLIST_BUTTON_RECT.start_x = 243+dx;
  PLAYLIST_BUTTON_RECT.start_y = 81;
  PLAYLIST_BUTTON_RECT.size_x = 22;
  PLAYLIST_BUTTON_RECT.size_y = 15;

  /* REWIND_BUTTON */
  REWIND_BUTTON_RECT.start_x = 12;
  REWIND_BUTTON_RECT.start_y = 125+dy;
  REWIND_BUTTON_RECT.size_x = 25;
  REWIND_BUTTON_RECT.size_y = 17;

  /* STOP_BUTTON */
  STOP_BUTTON_RECT.start_x = 47;
  STOP_BUTTON_RECT.start_y = 125+dy;
  STOP_BUTTON_RECT.size_x = 25;
  STOP_BUTTON_RECT.size_y = 17;

  /* PLAY_BUTTON */
  PLAY_BUTTON_RECT.start_x = 82;
  PLAY_BUTTON_RECT.start_y = 125+dy;
  PLAY_BUTTON_RECT.size_x = 25;
  PLAY_BUTTON_RECT.size_y = 17;

  /* PAUSE_BUTTON */
  PAUSE_BUTTON_RECT.start_x = 117;
  PAUSE_BUTTON_RECT.start_y = 125+dy;
  PAUSE_BUTTON_RECT.size_x = 25;
  PAUSE_BUTTON_RECT.size_y = 17;

  /* FAST_FORWARD_BUTTON */
  FAST_FORWARD_BUTTON_RECT.start_x = 152;
  FAST_FORWARD_BUTTON_RECT.start_y = 125+dy;
  FAST_FORWARD_BUTTON_RECT.size_x = 25;
  FAST_FORWARD_BUTTON_RECT.size_y = 17;

  /* LOAD_BUTTON */
  LOAD_BUTTON_RECT.start_x = 189;
  LOAD_BUTTON_RECT.start_y = 125+dy;
  LOAD_BUTTON_RECT.size_x = 51;
  LOAD_BUTTON_RECT.size_y = 17;

  /* RESIZE */
  RESIZE_RECT.start_x = 253+dx;
  RESIZE_RECT.start_y = 126+dy;
  RESIZE_RECT.size_x = 17;
  RESIZE_RECT.size_y = 19;

  /* PROGRESS_BAR */
  PROGRESS_BAR_RECT.start_x = 5;
  PROGRESS_BAR_RECT.start_y = 111+dy;
  PROGRESS_BAR_RECT.size_x = 265+dx;
  PROGRESS_BAR_RECT.size_y = 10;

 /* initialisation of progress bars */

  xmps_config.balance_bar.bar_rect.start_x = 155+dx; 
  xmps_config.balance_bar.bar_rect.start_y = 82;
  xmps_config.balance_bar.bar_rect.size_x = 81;
  xmps_config.balance_bar.bar_rect.size_y = 11;

  xmps_config.balance_bar.cursor_rect.size_x = 18;
  xmps_config.balance_bar.cursor_rect.size_y = 7 ;

  xmps_config.balance_bar.pos_x = 2;
  xmps_config.balance_bar.pos_y = 37;
  xmps_config.balance_bar.cursor_pos_x = 85;
  xmps_config.balance_bar.cursor_pos_y = 37;

  xmps_config.volume_bar.bar_rect.start_x = 155+dx;
  xmps_config.volume_bar.bar_rect.start_y = 100;
  xmps_config.volume_bar.bar_rect.size_x = 111;
  xmps_config.volume_bar.bar_rect.size_y = 11;

  xmps_config.volume_bar.cursor_rect.size_x = 18;
  xmps_config.volume_bar.cursor_rect.size_y = 7 ;

  xmps_config.volume_bar.pos_x = 2;
  xmps_config.volume_bar.pos_y = 50;
  xmps_config.volume_bar.cursor_pos_x = 115;
  xmps_config.volume_bar.cursor_pos_y = 50;

  xmps_config.progress_bar.bar_rect.start_x = 5;
  xmps_config.progress_bar.bar_rect.start_y = 111+dy;
  xmps_config.progress_bar.bar_rect.size_x = 265+dx;
  xmps_config.progress_bar.bar_rect.size_y = 10 ;

  xmps_config.progress_bar.cursor_rect.size_x = 25;
  xmps_config.progress_bar.cursor_rect.size_y = 8 ;

  xmps_config.progress_bar.pos_x = 2;
  xmps_config.progress_bar.pos_y = 63;
  xmps_config.progress_bar.cursor_pos_x = 269;
  xmps_config.progress_bar.cursor_pos_y = 63;

  /* la playlist */
  
  PLAYLIST_MENU_RECT.start_x = 5;
  PLAYLIST_MENU_RECT.start_y = 5;
  PLAYLIST_MENU_RECT.size_x = 18;
  PLAYLIST_MENU_RECT.size_y = 18;

  PLAYLIST_TITLE_RECT.start_x = 23;
  PLAYLIST_TITLE_RECT.start_y = 5;
  PLAYLIST_TITLE_RECT.size_x = 229+dx;
  PLAYLIST_TITLE_RECT.size_y = 18;

  PLAYLIST_CLOSE_RECT.start_x = 252 +dx;
  PLAYLIST_CLOSE_RECT.start_y = 5;
  PLAYLIST_CLOSE_RECT.size_x = 18;
  PLAYLIST_CLOSE_RECT.size_y = 18;

  PLAYLIST_ITEMS_RECT.start_x = 9;
  PLAYLIST_ITEMS_RECT.start_y = 29;
  PLAYLIST_ITEMS_RECT.size_x = 242+dx;
  PLAYLIST_ITEMS_RECT.size_y = 45+p_dy;

  PLAYLIST_ADD_BUTTON_RECT.start_x = 5;
  PLAYLIST_ADD_BUTTON_RECT.start_y = 81+p_dy;
  PLAYLIST_ADD_BUTTON_RECT.size_x = 25;
  PLAYLIST_ADD_BUTTON_RECT.size_y = 20;

  PLAYLIST_REMOVE_BUTTON_RECT.start_x = 40;
  PLAYLIST_REMOVE_BUTTON_RECT.start_y = 81+p_dy;
  PLAYLIST_REMOVE_BUTTON_RECT.size_x = 25;
  PLAYLIST_REMOVE_BUTTON_RECT.size_y = 20;

  PLAYLIST_SORT_BUTTON_RECT.start_x = 75;
  PLAYLIST_SORT_BUTTON_RECT.start_y = 81+p_dy;
  PLAYLIST_SORT_BUTTON_RECT.size_x = 25;
  PLAYLIST_SORT_BUTTON_RECT.size_y = 20;

  PLAYLIST_RAND_BUTTON_RECT.start_x = 110;
  PLAYLIST_RAND_BUTTON_RECT.start_y = 81+p_dy;
  PLAYLIST_RAND_BUTTON_RECT.size_x = 25;
  PLAYLIST_RAND_BUTTON_RECT.size_y = 20;

  PLAYLIST_RESIZE_RECT.start_x = 255+dx;
  PLAYLIST_RESIZE_RECT.start_y = 85+p_dy;
  PLAYLIST_RESIZE_RECT.size_x = 15;
  PLAYLIST_RESIZE_RECT.size_y = 15;

  PLAYLIST_PROGRESS_BAR_RECT.start_x = 257+dx;
  PLAYLIST_PROGRESS_BAR_RECT.start_y = 26;
  PLAYLIST_PROGRESS_BAR_RECT.size_x = 12;
  PLAYLIST_PROGRESS_BAR_RECT.size_y = 52+p_dy;
  
  PLAYLIST_CURSOR_RECT.start_x = 257+dx;
  
  if (xmps_config.playlist->nbr_items > xmps_config.playlist_nbr_lines)
  {
    nbr_pos = (xmps_config.playlist->nbr_items - xmps_config.playlist_nbr_lines ) +1;
    
    if (xmps_config.playlist_current_display_position == nbr_pos)
      PLAYLIST_CURSOR_RECT.start_y = PLAYLIST_PROGRESS_BAR_RECT.size_y-1;
    else
      {
	dy = (PLAYLIST_PROGRESS_BAR_RECT.size_y - 25) / (nbr_pos - 1);
	PLAYLIST_CURSOR_RECT.start_y = 26+(dy*(xmps_config.playlist_current_display_position -1));
      }
  }
  else
    PLAYLIST_CURSOR_RECT.start_y = 26;

  PLAYLIST_CURSOR_RECT.size_x = 12;
  PLAYLIST_CURSOR_RECT.size_y = 25;

}

/************ get_playlist_item_selected **************
 * 						      *
 * Return the item index corresp. to the mouse clic   *
 * 						      *
 ******************************************************/

gint get_playlist_item_selected(gdouble y)
{
 gint index;
 gdouble newy;
 
 newy  = y - 30;
 index = (xmps_config.playlist_current_display_position - 1) + (gint) (newy /15);
 
 XMPS_DEBUG("selected item : %d", index);

 if (index < xmps_config.playlist->nbr_items)
   return index;
 else
   return -1; 
}


