/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_digits.h
 *
 *  Functions for handling the digits.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include  <stdlib.h>
#include "skins_draw_digits.h"

/******************** draw_loop_digit *****************
 * 						      *
 ******************************************************/

void draw_loop_digit(gint state, GtkWidget *widget)
{
  gint dx;
  dx = xmps_config.window_size_x - 275;
  switch (state)
  {
  case ACTIVE :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   38, 40,
				   129+dx, 41,
				   10, 9,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    digits_pixmap,
		    38, 40,
		    129+dx, 41,
		    10, 9);
#endif
    break;

  case INACTIVE :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   26, 40,
				   129+dx, 41,
				   10, 9,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    digits_pixmap,
		    26, 40,
		    129+dx, 41,
		    10, 9);
#endif
    break;
 }
}

/******************** draw_minus_digit ****************
 * 						      *
 ******************************************************/

void draw_minus_digit(gint state, GtkWidget *widget)
{
  gint dx;
  dx = xmps_config.window_size_x - 275;
  switch (state)
    {
    case ACTIVE :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     14, 40,
				     129+dx, 32,
				     10, 7,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      digits_pixmap,
		      14, 40,
		      129+dx, 32,
		      10, 7);
#endif
      break;
      
    case INACTIVE :
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     2, 40,
				     129+dx, 32,
				     10, 7,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      digits_pixmap,
		      2, 40,
		      129+dx, 32,
		      10, 7);
#endif
      break;
    }
}

/******************** draw_digit **********************
 * 						      *
 ******************************************************/

void draw_digit(gint value, gint position, GtkWidget *widget)
{
 gint x;
 gint dx;
 dx = xmps_config.window_size_x - 275;

 switch (position)
 {
  case 1 : x = 144+dx;
  	   break;
  case 2 : x = 162+dx;
  	   break;
  case 3 : x = 175+dx;
  	   break;
  case 4 : x = 194+dx;
  	   break;
  case 5 : x = 207+dx;
  	   break;
  default : x = 144+dx;
 }

#ifdef HAVE_GDKPIXBUF

 switch (value)
 {
  /* NONE */
  case -1 :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
					    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
					    2, 2,
					    x, 30,
					    12, 23,GDK_RGB_DITHER_NONE, 0, 0);
  	    break;
  case 0  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    16, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 1  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    30, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 2  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    44, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 3  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    58, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 4  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    72, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 5  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    86, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 6  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    100, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 7  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    114, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 8  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    128, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
  case 9  :  gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
                  	    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  	    
                  	    142, 2,
                  	    x, 30,
                  	    12, 23,GDK_RGB_DITHER_NONE, 0, 0);

	    break;  	   
 }		 	   

#else

 switch (value)
 {
  /* NONE */
  case -1 : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            2, 2,
                            x, 30,
                            12, 23);
            break;
  case 0  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            16, 2,
                            x, 30,
                            12, 23);

            break;
  case 1  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            30, 2,
                            x, 30,
                            12, 23);

            break;
  case 2  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            44, 2,
                            x, 30,
                            12, 23);

            break;
  case 3  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            58, 2,
                            x, 30,
                            12, 23);

            break;
  case 4  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            72, 2,
                            x, 30,
                            12, 23);

            break;
  case 5  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            86, 2,
                            x, 30,
                            12, 23);

            break;
  case 6  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            100, 2,
                            x, 30,
                            12, 23);

            break;
  case 7  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            114, 2,
                            x, 30,
                            12, 23);

            break;
  case 8  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            128, 2,
                            x, 30,
                            12, 23);

            break;
  case 9  : gdk_draw_pixmap(widget->window,
                            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                            digits_pixmap,
                            142, 2,
                            x, 30,
                            12, 23);

            break;
 }
 


#endif

}

/********************* draw_time **********************
 * 						      *
 ******************************************************/

void draw_time(gint time, GtkWidget *widget)
{
 gint hour, minutes, seconds;

 if (time == -1)
  {
   draw_digit(-1, 1, widget);
   draw_digit(-1, 2, widget);
   draw_digit(-1, 3, widget);
   draw_digit(-1, 4, widget);
   draw_digit(-1, 5, widget);
  }
 else 
  {
   hour = time / (60*60);
   minutes = (time - hour*(60*60)) / 60;
   seconds = ((time - hour*(60*60)) - minutes*60);

   draw_digit(hour, 1, widget);
   draw_digit(minutes / 10, 2, widget);
   draw_digit((minutes - (minutes /10)*10), 3, widget);
   draw_digit(seconds / 10, 4, widget);
   draw_digit((seconds - (seconds /10)*10), 5, widget);
  }
}

/***************** draw_small_digit *******************
 * 						      *
 ******************************************************/

void draw_small_digit(gint value, gint position, GtkWidget *widget)
{

 gint x;
 gint dx;
 dx = xmps_config.window_size_x - 275;
 
 switch (position)
 {
  case 1 : x = 223+dx;
  	   break;
  case 2 : x = 232+dx;
  	   break;
  case 3 : x = 238+dx;
  	   break;
  case 4 : x = 247+dx;
  	   break;
  case 5 : x = 253+dx;
  	   break;
  default : x = 223+dx;
 }
 
 switch (value)
   {
     /* NONE */
   case -1 :  
#ifdef HAVE_GDKPIXBUF
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    2, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     2, 27,
		     x, 42,
		     6, 11);
#endif
     break;
   case 0  :  
#ifdef HAVE_GDKPIXBUF
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    10, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     10, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 1  :  
#ifdef HAVE_GDKPIXBUF
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    18, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     18, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 2  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    26, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     26, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 3  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    34, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     34, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 4  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    42, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     42, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 5  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    50, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     50, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 6  :  
#ifdef HAVE_GDKPIXBUF
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    58, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     58, 27,
		     x, 42,
		     6, 11);
#endif
   break;  	   
   case 7  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    66, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     66, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 8  :  
#ifdef HAVE_GDKPIXBUF 
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    74, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     74, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   case 9  :  
#ifdef HAVE_GDKPIXBUF
     gdk_pixbuf_render_to_drawable (digits_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    82, 27,
				    x, 42,
				    6, 11,GDK_RGB_DITHER_NONE, 0, 0);
#else
     gdk_draw_pixmap(widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     digits_pixmap,
		     82, 27,
		     x, 42,
		     6, 11);
#endif
     break;  	   
   }		 	   
}

/****************** draw_small_time *******************
 * 						      *
 ******************************************************/

void draw_small_time(gint time, GtkWidget *widget)
{
 gint hour, minutes, seconds;
 
 if (time == -1)
  {
   draw_digit(-1, 1, widget);
   draw_digit(-1, 2, widget);
   draw_digit(-1, 3, widget);
   draw_digit(-1, 4, widget);
   draw_digit(-1, 5, widget);
  }
 else 
  {
   hour = time / (60*60);
   minutes = (time - hour*(60*60)) / 60;
   seconds = ((time - hour*(60*60)) - minutes*60);

   draw_small_digit(hour, 1, widget);
   draw_small_digit(minutes / 10, 2, widget);
   draw_small_digit((minutes - (minutes /10)*10), 3, widget);
   draw_small_digit(seconds / 10, 4, widget);
   draw_small_digit((seconds - (seconds /10)*10), 5, widget);
  }
}


void draw_file_name(GtkWidget *widget, char * name) {

 gint dx;
 char *name2; 
 GdkGC *gc; 
 GdkFont *font;
 
 name2 = (char *) malloc(strlen(name));
 strcpy(name2, name);
 g_strup(name2);
 
 dx = xmps_config.window_size_x - 275;
 
 // We erase the preceding one

 gc = gdk_gc_new(widget->window);
 gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->filename_bgcolor.red*65536 + xmps_config.current_skin->filename_bgcolor.green*256 + xmps_config.current_skin->filename_bgcolor.blue);
 gdk_draw_rectangle(widget->window, gc, TRUE, 127+dx, 62, 135, 8);
 
 // And write the new one
 
 gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->filename_font_color.red*65536 + xmps_config.current_skin->filename_font_color.green*256 + xmps_config.current_skin->filename_font_color.blue);
 font = gdk_font_load(g_strdup("-adobe-helvetica-bold-r-*-*-8-*"));
 gdk_draw_text(widget->window, font, gc, 128+dx, 69, name2, strlen(name2) < 28 ? strlen(name2) : 28);
 //gdk_gc_destroy(gc);
 gdk_flush();
}





