/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * ring.c
 *
 * Audio Queue.
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "ring.h"

/*
 * some ring data for
 * the bufferisation
 *
 */

#define RING_SIZE   256000

char                ring[RING_SIZE];
unsigned int        read_pos;
unsigned int        write_pos;

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/

void ring_init()
{
  read_pos  = 0;
  write_pos = 0;
}

void ring_read(char *data, int size)
{
  if(write_pos <= read_pos) {
    
    if(read_pos + size < RING_SIZE) {
      memcpy(data, ring + read_pos, size);
      read_pos += size;
    }
    else {
      if(read_pos + size < RING_SIZE + write_pos) {
	
	unsigned int before, after;
	
	before = (RING_SIZE - 1) - read_pos;
	after = size - before;
	
	memcpy(data, ring + read_pos, before);
	memcpy(data + before, ring, after);
	
	read_pos = after;
      }
      else {
	XMPS_DEBUG("!!!!!!!!!!!!! could not read data !!!!!!!!!!!");
      }
    }
  }
  else {
    if(read_pos + size <= write_pos) {
      memcpy(data, ring + read_pos, size);
      read_pos += size;
    }
    else {
      XMPS_DEBUG("!!!!!!!!!!!!! could not read data !!!!!!!!!!!");
    }
  } 
}

void ring_write(char *data, int size)
{
  if(write_pos >= read_pos) {
    
    if(write_pos + size < RING_SIZE) {
      memcpy(ring + write_pos, data, size);
      write_pos += size;
    }
    else {
      if(write_pos + size < RING_SIZE + read_pos) {
	
	unsigned int before, after;

	before = (RING_SIZE - 1) - write_pos;
	after = size - before;

	memcpy(ring + write_pos, data, before);
	memcpy(ring, data + before, after);


	write_pos = after;
      }
    }
  }
  else {
    if(write_pos + size <= read_pos) {
      memcpy(ring + write_pos, data, size);
      write_pos += size;
    }

    return;
  }
}

int ring_full(int size)
{
  if(write_pos == read_pos)
    return 0;

  if(write_pos > read_pos) {

    if(write_pos + size < read_pos + RING_SIZE)
      return 0;

    return 1;
  }
  else {
    if(write_pos + size < read_pos)
      return 0;

    return 1;
  }
}



