/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  As a special exception, you have permission to link this program
 *  with the Qt library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from Qt.
 */
//---------------------------------------------------------------------------
#ifndef SETTINGS_H
#define SETTINGS_H
//---------------------------------------------------------------------------
#include "toolbox.h"
#include "userdata.h"

#include <qdialog.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qlist.h>
#include <qlistview.h>
#include <qtimer.h>
//---------------------------------------------------------------------------
class SettTabBase : public QWidget
{
	Q_OBJECT;

public:
   SettTabBase( QWidget *parent );
   ~SettTabBase();

   virtual void setData( UDataUser *data ) = 0;

private:
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class SettPersonalWidget : public SettTabBase
{
	Q_OBJECT;
public:
   SettPersonalWidget( QWidget *parent );
   ~SettPersonalWidget();

   void setupWidget();
   void setData( UDataUser *data );

private:
	QLineEdit *edName;
   QComboBox *cmbSoftware, *cmbType;
   QCheckBox *chkbAuto7, *chkbAutoBIN, *chkbAutoR, *chkbRecConn;
   QCheckBox *chkbRecReconn, *chkbRemote, *chkbCOMP, *chkbHUFallowed;
   QCheckBox *chkbHUFTX, *chkbHUFRX;
};
//---------------------------------------------------------------------------
class SettPasswordsWidget : public SettTabBase
{
	Q_OBJECT;
public:
   SettPasswordsWidget( QWidget *parent );
   ~SettPasswordsWidget();

   void setupWidget();
   void setData( UDataUser *data );

public slots:
	void slotAddClicked();
   void slotDelClicked();

private:
	QListView *table;
   QPushButton *btnAdd, *btnDel;
};
//---------------------------------------------------------------------------
class UserSettings : public QDialog
{
   Q_OBJECT;

public:
   UserSettings( QWidget *parent );
   ~UserSettings();

public slots:
	void slotBtnOkClicked();
   void slotBtnHelpClicked();
   void slotCallHighlighted( const QString & );
	void slotShowCall();

private:
	void addTab( SettTabBase *settingsTab, const QString & label );

	UDataUser *currentData;
   bool changed;

   QTimer *callShowTimer;
   QListBox *lbCalls;
   QPushButton *btnOk, *btnCancel, *btnHelp;
   QTabWidget *tabs;
   QList<SettTabBase> *listTabs;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

