/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                              
 * As a special exception, you have permission to link this program             
 * with the Qt library and distribute executables, as long as you               
 * follow the requirements of the GNU GPL in regard to all of the               
 * software in the executable aside from Qt.                                         
 */


#include "auto7.h"
#include "auto7.moc"

#include "channel.h"
#include "toolbox.h"
#include "version.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <dirent.h>

#include <kmessagebox.h>


Auto7Plus::Auto7Plus( Channel *chan, const char *filename, s_sqsendinfo *info )
			: FileTransfer( chan, filename )
{
	char tmp[100];


   f = NULL;
   this->chan = chan;
   sendinfo = info;
   ready = false;
   filecount = 0;
   fileroot = NULL;

   sprintf(tmp, "/tmp/linkt_%lx/", time(NULL));
   dirname = (char *) strdup( tmp );
   mkdir( dirname, 0700 );

   encode7plusFiles();
   nextfile = sendinfo->startwith;
	getSendFilelist();
}


Auto7Plus::~Auto7Plus()
{
   DIR *dir;
   struct dirent *entry;


   if (f != NULL)
   {
   	fclose(f);
      f = NULL;
   }

	dir = opendir(dirname);

	while ((entry = readdir(dir)) != NULL)
   {
   	if (entry->d_name[0] == '.') continue;

      unlink(entry->d_name);
	}

   while (fileroot != NULL)
		deleteFileRoot();

	rmdir( dirname );
   free( dirname );
}


void Auto7Plus::encode7plusFiles()
{
	pid_t pid;
   int i;
   char tmp[100];
   char directory[500];


	if ((pid = fork()) == 0)
   {
   	sprintf(tmp, "%i", sendinfo->splitsize);
      i = lPOS('/', longname);
      memcpy(directory, longname, i);
      directory[i] = '\0';
      chdir(directory);
      execlp("7plus", "7plus", "-sb", tmp, shortname.latin1(), dirname, 0);

		// Fehlermeldung, wenn das 7plus-Binary nicht geoeffnet werden konnte
/*    	KMessageBox::error( chan,
								i18n("Cannot open 7plus-binary."),
								i18n("7plus"));*/
		exit(0);
   }
   waitpid(pid, NULL, 0);
}


void Auto7Plus::getSendFilelist()
{
   DIR *dir;
   struct dirent *entry;
   char ext[10];
   int i;


   // Eine Liste der auszusendenden Dateien erzeugen
	dir = opendir(dirname);

	while ((entry = readdir(dir)) != NULL)
   {
   	if (entry->d_name[0] == '.') continue;

      filecount++;

		if ((i = POS('.', entry->d_name)) != -1)
      {
         strncpy(ext, entry->d_name+i+1, 9);
			if (!strncmp(ext, "7pl", 9))
         {
         	addFile( entry->d_name, 1 );
            return;
         }

         if ((i = atoi(ext+1)) > 0)
            if (i >= sendinfo->startwith)
               addFile( entry->d_name, i );
      }
   }
}


void Auto7Plus::addFile( const char *filename, int nr )
{
   s_7files *tmp;
   char str[500];


   if (fileroot == NULL)
   {
      // Erster Eintrag
      fileroot = (s_7files *)malloc(sizeof(s_7files));
      tmp = fileroot;
   }
   else
   {
      tmp = fileroot;
      while (tmp->next != NULL) tmp = tmp->next;

      tmp->next = (s_7files *)malloc(sizeof(s_7files));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   sprintf(str, "%s%s", dirname, filename);
   tmp->name = (char *) strdup(str);
   tmp->nr = nr;
}


void Auto7Plus::SendString( const char *data )
{
	emit sendString( data, strlen(data), true );
}


void Auto7Plus::slotReceivedString( const char *, int )
{
}


void Auto7Plus::getFileData()
{
	char tmp[500], sndcmd[3], lt[5], titel[200];
   int bytessent=0, i;


	if (f == NULL)
   {
      while (fileroot != NULL && (f = fopen(fileroot->name, "r")) == NULL)
      	deleteFileRoot();
		if (fileroot == NULL)
      {
      	ready = true;
      	return;
      }

		switch (sendinfo->sendcmd)
      {
      	case 1: strcpy(sndcmd, "S"); break;
         case 2: strcpy(sndcmd, "SP"); break;
         case 3: strcpy(sndcmd, "SB"); break;
		}

      if (sendinfo->lt == -1)
      	lt[0] = '\0';
		else
      	sprintf(lt, " #%i", sendinfo->lt);

		macroLine( titel, sendinfo->titel, fileroot->nr );
      sprintf(tmp, "%s %s%s %s\r", sndcmd, sendinfo->user, lt, titel);
      SendString(tmp);
      bytessent += strlen(tmp);
   }


   while (fgets(tmp, 499, f) != NULL)
   {
   	if ((i = POS('\r', tmp)) != -1) tmp[i] = '\0';
   	if ((i = POS('\n', tmp)) != -1) tmp[i] = '\0';
   	SendString(tmp);
      SendString("\r");
	}

   sprintf(tmp, "\r\r** LinKT %s: 7plus-autosend **\r\r***end\r", LINKT_VERSION);
   SendString(tmp);

   fclose(f);
   f = NULL;

   deleteFileRoot();
}


void Auto7Plus::deleteFileRoot()
{
	s_7files *tmp;

   tmp = fileroot;
   fileroot = fileroot->next;
   free(tmp->name);
}


void Auto7Plus::startSending()
{
}


int Auto7Plus::sentReady()
{
   if (ready)
   	return SQTRSTAT_STDSTOP;
   else
      return 0;
}


void Auto7Plus::macroLine( char *dest, const char *src, int filenr )
{
  int i,k,count;
  char help[500];


  count = strlen(src);

  i = 0;
  k = 0;
  while (i < count)
  {
    switch(src[i])
    {
      case '%': i++;
                if (i < count)
                   switch(src[i])
                   {
                     case '%': dest[k] = '%';
                               k++;
                               break;
                     case 'a': // Die Nummer des aktuellen Files
                               dest[k] = '\0';
                               sprintf(help,"%i", filenr);
                               memcpy(dest+k,help,strlen(help));
                               k = k + strlen(help);
                               break;
                     case 'c': // Anzahl der 7plus-Dateien
                               dest[k] = '\0';
                               sprintf(help,"%i",filecount);
                               memcpy(dest+k,help,strlen(help));
                               k = k + strlen(help);
                               break;
                     case 'A': // Die Nummer des aktuellen Files (hex)
                               dest[k] = '\0';
                               sprintf(help,"%.2x", filenr);
                               memcpy(dest+k,help,strlen(help));
                               k = k + strlen(help);
                               break;
                     case 'C': // Anzahl der 7plus-Dateien (hex)
                               dest[k] = '\0';
                               sprintf(help,"%.2x",filecount);
                               memcpy(dest+k,help,strlen(help));
                               k = k + strlen(help);
                               break;
                     default: dest[k] = '%'; k++;
                              dest[k] = src[i]; k++;
                   }
                break;
      default: dest[k] = src[i];
               k++;
    }
    
    i++;
  }

  dest[k] = '\0';
}


void Auto7Plus::abortTransmission()
{
   ready = true;
}



