/* This file implements the tab to edit contact information.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.2 $
 */

#ifndef KAB_LOOK_EDIT_TABCONTACT_H
#define KAB_LOOK_EDIT_TABCONTACT_H "$ID$"

#include "look_edit_basictab.h"

class QPushButton;
class QGridLayout;

class TabContact : public TabBasic
{
  Q_OBJECT
public:
  TabContact(KabAPI*, QWidget *parent=0);
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
protected:
  QPushButton *buttonEmail;
  QPushButton *buttonTalk;
  QPushButton *buttonTelephone;
  QPushButton *buttonURLs;
  QGridLayout *layout;
  AddressBook::Entry entry;
protected slots:
  void editTelephoneNumbers();
  void editEmailAddresses();
  void editTalkAddresses();
  void editURLs();
};

#endif // KAB_LOOK_EDIT_TABCONTACT_H

