/* This file implements the tab to edit the addresses.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.7 $
 */

#ifndef KAB_LOOK_EDIT_TABADDRESSES_H
#define KAB_LOOK_EDIT_TABADDRESSES_H "$ID$"

#include "look_edit_basictab.h"
#include <addressbook.h>
#include <list>

class QComboBox;
class QPushButton;
class QPopupMenu;
class QToolButton;
class QGridLayout;
class QLineEdit;
class QLabel;
class QString;
class KabAPI;

class TabAddresses : public TabBasic
{
  Q_OBJECT
public:
  TabAddresses(KabAPI*, QWidget *parent=0);
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
protected:
  /** Used to select the address to edit. */
  QComboBox *selector;
  /** The button to create a new address. */
  QPushButton *newAddress;
  /** The button to delete an address. */
  QPushButton *delAddress;
  /** The label for the street. */
  QLabel *l_street;
  /** The label for the zip code. */
  QLabel *l_zip;
  /** The label for the city. */
  QLabel *l_city;
  /** The label for the state. */
  QLabel *l_state;
  /** The label for the country. */
  QLabel *l_country;
  /** The label for the position. */
  QLabel *l_position;
  /** The input field to edit the headline. */
  QLineEdit *headline;
  /** The input field to edit the street. */
  QLineEdit *street;
  /** The input field for the zip code. */
  QLineEdit *zip;
  /** The input field for the city. */
  QLineEdit *city;
  /** The input field for the state. */
  QLineEdit *state;
  /** The input field for the country. */
  QLineEdit *country;
  /** The line edit for the position. The position is meant to be the
      task/responsibility/assignment of the person according to this
      address. This makes sense for, for example, working addresses in
      different enterprises.
  */
  QLineEdit *position;
  /** The button to enter the organisational data. */
  QPushButton *orgdata;
  /** The layout manager. */
  QGridLayout *layout;
  /** The index of the item currently displayed. Set by highlighted (exclusivly). */
  int currentItem;
  /** The list of addresses. */
  std::list<AddressBook::Entry::Address> addresses;
  /** A method to fill the selector with the address headlines. */
  void fillSelector();
  /** A method to fill all fields with the values of this address. */
  void fillFields();
  /** A method to write all changes back to the current address object. */
  void storeChanges();
  /** Remember user input. */
  bool modified;
  /** An iterator to the currently selected Address object. */
  std::list<AddressBook::Entry::Address>::iterator currentAddress();
  /** QPopupMenu to display "type of address" choices. */
  QPopupMenu *popupAddresses;
protected slots:
  /** Create a new address. */
  void addAddress();
  /** Delete an address. */
  void deleteAddress();
  /** Edit the organisational fields. */
  void insinuation();
  /** An address has been highlighted by the user. */
  void highlighted(int);
  /** The currently selected address has been changed. */
  void addressChanged();
  /** The same, for line edits. */
  void addressChanged(const QString &);
  /** The headline has been changed. */
  void headlineChanged(const QString &);
};

#endif // KAB_LOOK_EDIT_TABADDRESSES_H
