/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 * 
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLCopyDesc.c,v 1.2 1999/12/10 01:50:32 harvey Exp $
 *
 * $Log: SQLCopyDesc.c,v $
 * Revision 1.2  1999/12/10 01:50:32  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.7  1999/11/13 23:40:58  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.6  1999/10/24 23:54:17  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.5  1999/09/21 22:34:24  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.4  1999/07/10 21:10:16  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:07  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:54  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:05  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:17  pharvey
 * Imported sources
 *
 * Revision 1.2  1999/05/09 23:27:11  nick
 * All the API done now
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLCopyDesc.c,v $ $Revision: 1.2 $";

SQLRETURN SQLCopyDesc( SQLHDESC source_desc_handle,
           SQLHDESC target_desc_handle )
{
    DMHDESC src_descriptor = (DMHDESC)source_desc_handle;
    DMHDESC target_descriptor = (DMHDESC)target_desc_handle;
    SQLCHAR s0[ 20 ];

    /*
     * check descriptor
     */

    if ( !__validate_desc( src_descriptor ))
    {
        return SQL_INVALID_HANDLE;
    }
    if ( !__validate_desc( target_descriptor ))
    {
        return SQL_INVALID_HANDLE;
    }

    function_entry( src_descriptor );
    function_entry( target_descriptor );

    if ( src_descriptor -> log_handle )
    {
        sprintf( src_descriptor -> msg, "\n\t\tEntry:\
            \n\t\t\tSource Descriptor = %p\
            \n\t\t\tTarget Descriptor = %p", 
                src_descriptor,
                target_descriptor );

        dm_log_write( src_descriptor -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                src_descriptor -> msg );
    }

    /*
     * if both descriptors are from the same connection the we can just
     * pass it on
     */

    thread_protect( SQL_HANDLE_DESC, src_descriptor );
    thread_protect( SQL_HANDLE_DESC, target_descriptor );

    if ( src_descriptor -> connection == 
            target_descriptor -> connection )
    {
        SQLRETURN ret;

        if ( !CHECK_SQLCOPYDESC( src_descriptor -> connection ))
        {
            dm_log_write( src_descriptor -> log_handle, 
                    __get_pid( s0 ), 
                    __FILE__, 
                    __LINE__, 
                    LOG_INFO, 
                    LOG_INFO, 
                    "Error: IM001" );

            __post_internal_error( &src_descriptor -> error,
                    ERROR_IM001, NULL,
                    src_descriptor -> connection -> environment -> requested_version );

            thread_release( SQL_HANDLE_DESC, src_descriptor );
            thread_release( SQL_HANDLE_DESC, target_descriptor );

            return function_return( src_descriptor, SQL_ERROR );
        }
        ret = SQLCOPYDESC( src_descriptor -> connection,
                src_descriptor -> driver_desc,
                target_descriptor -> driver_desc );

        if ( src_descriptor -> log_handle )
        {
            sprintf( src_descriptor -> msg, 
                    "\n\t\tExit:[%s]",
                        __get_return_status( ret ));

            dm_log_write( src_descriptor -> log_handle, 
                    __get_pid( s0 ), 
                    __FILE__, 
                    __LINE__, 
                    LOG_INFO, 
                    LOG_INFO, 
                    src_descriptor -> msg );
        }

        thread_release( SQL_HANDLE_DESC, src_descriptor );
        thread_release( SQL_HANDLE_DESC, target_descriptor );

        return function_return( src_descriptor, ret );
    }
    else
    {
        /*
         * TODO copy from one to the other
         */

        dm_log_write( src_descriptor -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: IM001" );

        __post_internal_error( &src_descriptor -> error,
                ERROR_IM001, NULL,
                src_descriptor -> connection -> environment -> requested_version );

        thread_release( SQL_HANDLE_DESC, src_descriptor );
        thread_release( SQL_HANDLE_DESC, target_descriptor );

        return function_return( src_descriptor, SQL_ERROR );
    }
}
