#ifndef __KVIEWPART_H
#define __KVIEWPART_H


#include <qlist.h>


#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <klibloader.h>
#include <kdirwatch.h>


class KAction;
class KSelectAction;
class KToggleAction;
class ScrollBox;
class MarkList;
class KInstance;
class KViewPartExtension;
class KAccel;
class GotoDialog;
class QSize;
class PaperSize;


#include "kmultipage.h"


class KViewPartFactory : public KLibFactory
{
  Q_OBJECT

public:

  KViewPartFactory();
  virtual ~KViewPartFactory();

  virtual QObject* create(QObject* parent = 0, const char* name = 0,
                          const char* classname = "KViewPart",
                          const QStringList &args = QStringList() );

  static KInstance *instance();

private:

  static KInstance *s_instance;

};


class KViewPart : public KParts::ReadOnlyPart
{
  Q_OBJECT

public:

  KViewPart(QString partname, QWidget *parent=0, const char *name=0);
  virtual ~KViewPart();

  void readSettings();
  void writeSettings();


public slots:

  virtual bool openURL(const KURL &url);
  virtual bool closeURL();
 
  QStringList fileFormats();


protected slots:

  void slotShowMarkList();

  void slotOrientation (int);
  void slotMedia (int);

  void prevPage();
  void nextPage();
  void firstPage();
  void lastPage();
  void goToPage();

  void zoomIn();
  void zoomOut();

  void fitToPage();
  void fitSize();
  void fitToHeight();
  void fitToWidth();

  void scrollUp();
  void scrollDown();
  void scrollLeft();
  void scrollRight();

  void scrollUpPage();
  void scrollDownPage();
  void scrollLeftPage();
  void scrollRightPage();

  void readDown();

  void slotPrint();

  void fileChanged(const QString&);

  void updatePreview(bool previewAvailable=false);
  
  void slotPreview();


protected:

  KToggleAction *showmarklist, *showPreview;
  KSelectAction *orientation, *media;

  virtual bool openFile();

  int page() { return _currentPage; };
  int pages() { return _numberOfPages; };
  void setPage(int page);

  bool eventFilter(QObject *obj, QEvent *ev);

  QList<PaperSize> _paperSizes;
  void fillPaperSizes();

  void setPaperSize(double w, double h);
    

private slots:

  void numberOfPages(int nr);
  void pageSelected(int nr);
  void contentsMoving(int x, int y);
  void scrollBoxChanged(QPoint np);
  void updateScrollBox();
  void scrollTo(int x, int y);
  void slotGotoDialog(const QString &page);


private:

  KDirWatch watch;

  QString _partname;

  void checkActions();

  QSize pageSize();

  KAccel *accel;

  KAction *zoomInAct, *zoomOutAct, *backAct, *forwardAct,
    *startAct, *endAct, *endDocAct, *markAct, *gotoAct,
    *fitAct, *fitPageAct, *fitHeightAct, *fitWidthAct,
    *saveAction, *printAction, *readDownAct;
  KToggleAction *watchAct;

  KMultiPage *multiPage;

  ScrollBox *scrollBox;
  MarkList  *markList;

  KViewPartExtension *m_extension;

  int _numberOfPages, _currentPage;
  double _zoom;

  QWidget *mainWidget;

  GotoDialog *_gotoDialog;

  double _paperWidth, _paperHeight;

  QPoint mousePos;

};


class KViewPartExtension : public KParts::BrowserExtension
{
  Q_OBJECT
  friend class KViewPart;

public:

  KViewPartExtension(KViewPart *parent);
  virtual ~KViewPartExtension() {}

};


#endif


