#ifndef __KGVSHELL_H__
#define __KGVSHELL_H__

#include <qstring.h>

#include <kparts/mainwindow.h>

class QTimer;

class KRecentFilesAction;
class ScrollBox;
class KGVPart;
class KToggleAction;
class KAction;

class KGVShell : public KParts::MainWindow
{
  Q_OBJECT
public:
  KGVShell();
  virtual ~KGVShell();

public slots:
  void openURL( const KURL & url );
  void slotShowMarkList ();
 
protected slots:

  void slotFileOpen();
  void slotFitToPage();
  void slotResize();
  void slotShowToolBar();
  void slotShowStatusBar();
  void slotWatchFile();
  void slotWriteSettings();
  void slotQuit();
  void slotMarkListShown(bool);

 protected:
  void startWatching();
  void stopWatching();
  void readSettings();
  void keyPressEvent (QKeyEvent *);
  void enableAllActions( bool enable );

private:
  KGVPart *m_gvpart;
  KRecentFilesAction *recent;
  KAction *openact;
  QString cwd;
  KToggleAction *showtoolbar, *showstatusbar, *watchaction,*showmarklist;
  
  QTimer *watch;
};

#endif
