/*
 * itemview.h. 
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#ifndef _ITEMVIEW_H_
#define _ITEMVIEW_H_

#include <qframe.h>
#include <qwidget.h>
#include <qlist.h>

class QPopupMenu;
class Item;

class ItemView: public QFrame
{
   Q_OBJECT
   
   Item *mItem;
public:
   ItemView(QWidget *parent, Item *item);
   ~ItemView();

   Item *item() { return mItem; }

   void autoSize();
   virtual void paintEvent(QPaintEvent *ev);
   virtual void mousePressEvent(QMouseEvent *ev);

public slots:
   void slotDelete();
   void slotView();
protected:

   QPopupMenu *mRMBMenu;
};

class ItemViewList : public QList<ItemView>
{
public:
   ItemViewList() { }
   void deleteAll() { setAutoDelete(true); clear(); setAutoDelete(false); }
};

#endif
