/*
 * item.h 
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#ifndef _ITEM_H_
#define _ITEM_H_

#include <kurl.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qstring.h>
#include <qsize.h>
#include <qobject.h>

class Catalog;
class KTarGz;
class KTarDirectory;

class Item : public QObject
{
   Q_OBJECT

   QImage mTnImg;
   QPixmap mTn;
   QString mComment;
   QString mKeywords;
   QString mLocation;
   int mSize;
   QSize mDimensions;
   QImage *mImg;
   Catalog *mCat;
public:
   Item(QSize tnSize);
   Item(const QString &path);
   ~Item();

   bool loadImage(const KURL &location);
   bool setImage(const QImage &img);
   bool saveTo(KTarGz *tarFile, const QString &path);
   bool loadFrom(const KTarDirectory *tarDir, const QString &path);

   void setCatalog(Catalog *cat) { mCat = cat; }
   Catalog *catalog() { return mCat; }

   QPixmap thumbNail() { if (mTn.isNull()) mTn = mTnImg; return mTn; }
   QString comment() { return mComment; }
   QString location() { return mLocation; }
   QString name();
   int size() { return mSize; }
   QSize dimensions() { return mDimensions; }

   bool loadOk() { return mLoadOk; }   

signals:
   void destroyed(Item *);

protected:
   QSize mTnSize;
   bool mLoadOk;
};

#endif
