#include <klocale.h>
#include "main.h"
#include "fe_board.h"
#include "fe_piece.h"
#include "fe_ai.h"
#include "lib/mp_interface.h"
#include "version.h"

const MPGameInfo FE_GAME_INFO = {
        FE_MULTIPLAYER_ID,
        4,
        500,
        TRUE,
        0, 0
};

const MPGameInfo &gameInfo()
{
	return FE_GAME_INFO;
}

Board *createBoard(QWidget *parent)
{
	return new FEBoard(TRUE, parent);
}

GPieceInfo *createPieceInfo()
{
	return new FEPieceInfo;
}

AI *createAI()
{
	return new FEAI(0, 200); // times needs tuning ?
}

static const char *FE_DESCRIPTION =
    I18N_NOOP("KFoulEggs is a clone of the well-known (at least in Japan)"
			  " PuyoPuyo game.");

int main(int argc, char **argv)
{
	return generic_main(argc, argv, "kfouleggs", I18N_NOOP("KFoulEggs"),
						FE_DESCRIPTION, TRUE);
}
