/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// QT includes
#include <qtooltip.h>

// KDE includes
#include <kapp.h>
#include <kglobal.h>

// own includes
#include "betbox.h"
#include "kpoker.h"
#include "kpaint.h"
#include "defines.h"

extern CardImages* cardImage;

void kpok::initSomeStuff()
{
//init Some Stuff -> called by kpok::kpok only. And only once.

	done = new bool[highestCard];

//	TODO: read from menu 
	blinking = true;

//       KKeyCode initialization
	kacc = new KAccel( this );
	kacc->insertItem(i18n("Quit"), "Quit", KStdAccel::key(KStdAccel::Quit));
	kacc->insertItem(i18n("New game"), "New", "F2");
	kacc->insertItem(i18n("Help"), "Help", KStdAccel::key(KStdAccel::Help));
	kacc->insertItem(i18n("Draw"), "Draw", Key_Return);
	// kacc->insertItem(i18n("Ok dialog"), "ok", "Return"); ??
	// kacc->insertItem(i18n("Cancel dialog"), "dialog", "Escape"); ??


//	 connections
	kacc->connectItem("Quit", qApp, SLOT(quit()));
	kacc->connectItem("New", this, SLOT(newGame()));
	kacc->connectItem("Draw", this, SLOT(drawClick())); // same as drawButton


	QFont myFixedFont("Helvetica",12);

	drawButton = new QPushButton(this, 0);
	drawButton->setAccel(Key_Enter);
	drawButton->setText(i18n("&Draw!"));
	drawButton->adjustSize();
	connect(drawButton, SIGNAL(clicked()), this, SLOT(drawClick()));

        wonLabel = new QLabel(this, 0);
	wonLabel->hide();
	wonLabel->setFont(QFont("Helvetica", 14, QFont::Bold));
	wonLabel->setAutoResize(true); // obsolete but MUCH easier
	wonLabel->move(this->width() /2  - wonLabel->width() / 2, wonLabelVDist);

	clickToHold = new QLabel(this,0);
	clickToHold->hide();
//	clickToHold->setFont(QFont("Helvetica", 11));
//	clickToHold->setText(i18n("Click a card to hold it"));
//	clickToHold->adjustSize();
//	clickToHold->move(this->width() /2  - clickToHold->width() / 2, clickToHoldVDist);

/*
//	last hand label:
	LHLabel= new QLabel(this, 0);
	LHLabel->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	LHLabel->setGeometry(this->width() - CLHBorderDistance - CLHWidth, CLHDistFromTop - 150, CLHWidth, 30);
	LHLabel->setAutoResize(true);
        LHLabel->setFont(myFixedFont);
*/

//	timers
	blinkTimer = new QTimer(this);
	connect( blinkTimer, SIGNAL(timeout()), SLOT(bTimerEvent()) );
	blinkStat=0;

	waveTimer = new QTimer(this);
	connect( waveTimer, SIGNAL(timeout()), SLOT(waveTimerEvent()) );

	drawTimer = new QTimer(this);
	connect (drawTimer, SIGNAL(timeout()), SLOT(drawCardsEvent()) );

	potLabel = new QLabel(this, 0);
	potLabel->setFont(myFixedFont);
	potLabel->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	potLabel->setAutoResize(true);

//and now the betUp/Down Buttons
	betBox = new BetBox(this, 0);
	betBox->move(400, CLHDistFromTop);
	connect(betBox, SIGNAL(betChanged(int)), this, SLOT(betChange(int)));
	connect(betBox, SIGNAL(betAdjusted()), this, SLOT(adjustBet()));
	connect(betBox, SIGNAL(out()), this, SLOT(out()));

	weWillAdjustLabel = new QLabel(this, 0);
	weWillAdjustLabel->hide();
	weWillAdjustLabel->setFont(QFont("Helvetica"), 11);

//	some tips 
	QToolTip::add(drawButton, i18n("draw new cards"));
//	QToolTip::add(LHLabel, i18n("your last hand"));
	QToolTip::add(potLabel, i18n("the current pot"));

//load all cards into pixmaps first -> in the constructor
	cardImage = new CardImages(this, 0);

	random.setSeed(0);

	blinkingBox = 0;
}

