/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// QT includes
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

// own includes
#include "defines.h"
#include "newgamedlg.h"

NewGameDlg::NewGameDlg(QWidget* parent, const char* name) : QDialog(parent, name, true)
{
 resize(500, 400);

 const int labelPos = 10;
 const int widgetPos = 300;
 int y = 0;

 QPushButton* ok = new QPushButton(i18n("OK"), this);
 //ok->move(this->width() /2 - ok->width() - 20, 350);
 ok->move(this->width() /4 - ok->width() /2, 350);
 ok->setDefault(true);
 connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
 
 QPushButton* cancel = new QPushButton(i18n("Cancel"), this);
 cancel->move(this->width() /2 + this->width() /4 - cancel->width() /2, 350);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));


 KConfig* conf = kapp->config();
 conf->setGroup("General");
 bool showOptions = conf->readBoolEntry("showOptionsOnStartup", true);
 bool readConfig = conf->readBoolEntry("readFromConfig", false);
 int playerNr = conf->readNumEntry("players", DEFAULT_PLAYERS);
 int money = conf->readNumEntry("startMoney", START_MONEY);
 conf->setGroup("Save");
 QString names[MAX_PLAYERS];
 names[0] = conf->readEntry("Name_0", i18n("You"));
 for (int i = 1; i < MAX_PLAYERS; i++) {
 	names[i] = conf->readEntry(QString("Name_%1").arg(i), i18n("Computer %1").arg(i));
 }

 readFromConfig = new QCheckBox(i18n("Try readingFrom config file"), this);
 readFromConfig->adjustSize();
 readFromConfig->setChecked(readConfig);
 readFromConfig->move(20, 20);
 readFromConfigLabel = new QLabel(i18n("The following values are used if reading from config fails"), this);
 if (!readFromConfig->isChecked())
	 readFromConfigLabel->hide();
 readFromConfigLabel->adjustSize();
 readFromConfigLabel->move(10, 50);
 connect(readFromConfig, SIGNAL(toggled(bool)), this, SLOT(changeReadFromConfig(bool)));

 y = 80;
 QLabel* playersLabel = new QLabel(i18n("How many players do you want?"), this);
 playersLabel->adjustSize();
 playersLabel->move(labelPos, y);
 
 players = new QComboBox(this);
 players->insertItem(QString(i18n("1 player")));
 for (int i = 1; i < MAX_PLAYERS; i++) 
	 players->insertItem(QString(i18n("%1 players")).arg(i+1));
 players->setCurrentItem(playerNr-1);
 players->move(widgetPos, y);

 y += 35;
 QLabel* player1NameLabel = new QLabel(i18n("Your Name"), this);
 player1NameLabel->adjustSize();
 player1NameLabel->move(labelPos, y);

 player1Name = new QLineEdit(names[0], this);
 player1Name->move(widgetPos, y);

 y += 35;
 QLabel* moneyLabel = new QLabel(i18n("Start money of the players"), this);
 moneyLabel->adjustSize();
 moneyLabel->move(labelPos, y);

 moneyOfPlayers = new QLineEdit(QString("%1").arg(money), this);
 moneyOfPlayers->move(widgetPos, y);

 y += 40;
 QLabel* computerNamesLabel = new QLabel(i18n("The names of your enemies"), this);
 computerNamesLabel->adjustSize();
 computerNamesLabel->move(labelPos, y);

 computerNames = new QComboBox(true, this);
 computerNames->setInsertionPolicy(QComboBox::AtCurrent);
 computerNames->move(widgetPos, y);
 for (int i=1; i < MAX_PLAYERS; i++)
	 computerNames->insertItem(names[i]);

 y += 45;
 QLabel* showLabel = new QLabel(i18n("Show this dialog every time on startup"), this);
 showLabel->adjustSize();
 showLabel->move(labelPos, y);
 
 showDialogOnStartup = new QCheckBox(this);
 showDialogOnStartup->setChecked(showOptions);
 showDialogOnStartup->adjustSize();
 showDialogOnStartup->move(widgetPos, y); 

}

void NewGameDlg::changeReadFromConfig(bool s)
{
 if (s)
	readFromConfigLabel->show();
 else
	readFromConfigLabel->hide();
}

bool NewGameDlg::showOnStartup()
{ return showDialogOnStartup->isChecked(); }

int NewGameDlg::getPlayers()
{ return players->currentItem() + 1; }

bool NewGameDlg::readFromConfigFile()
{ return readFromConfig->isChecked(); }

int NewGameDlg::money()
{
 bool ok = true;
 int m = moneyOfPlayers->text().toInt(&ok);
 if (ok) return m;
 else return START_MONEY;
}

QString NewGameDlg::name(int nr)
{
if (computerNames->currentText() != computerNames->text(computerNames->currentItem()))
	computerNames->changeItem(computerNames->currentText(), computerNames->currentItem());
	
 if (nr == 0)
	return player1Name->text();
 if (nr <= computerNames->count())
	 return computerNames->text(nr-1);
 return i18n("Player");
}

void NewGameDlg::hideReadingFromConfig()
{
readFromConfig->hide();
readFromConfigLabel->hide();
readFromConfig->setChecked(false);
}



