/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Some defines for the outlook etc. */
#ifndef DEFINES_H
#define DEFINES_H

#define highestCard 52
#define CARDS 5

#define drawDelay 300

#define cardDistFromTop 18
#define cardDistFromBottom 10
#define cardHDist 10

#define cardHeight 96 
#define cardWidth 72

//#define CLHBorderDistance 15
#define CLHBorderDistance 5
#define CLHDistFromTop 180
#define CLHWidth 140
#define PLAYERBOX_WIDTH ((cardWidth + cardHDist) * CARDS + cardHDist + 10 + 110)
#define PLAYERBOX_HEIGHT (cardHeight + cardDistFromTop + cardDistFromBottom)
#define DISTANCE_FROM_2ND_BOX 90

#define wonLabelVDist (cardHeight + cardDistFromTop + cardDistFromBottom + 10)
#define clickToHoldVDist 130

#define START_MONEY 100

#define DEFAULT_PLAYERS 1 // change to 2 later
#define MAX_PLAYERS 2 // TODO: maximal 4


// menu IDs
#define ID_NEWGAME 100
#define ID_SAVEGAME 110
#define ID_EXIT 190
#define ID_BLINKING 200
#define ID_SOUND 210
#define ID_ADJUST 220

#endif
