/*
 *	--- highscore.h ---
 * Highscore list for kasteroids
 *
 * Written by Krzysztof "Kristoff" Godlewski (krzygod@kki.net.pl)
 * Hmm, I feel bad about it, because this is almost copied from ksame...ah well....
 */

#ifndef __HIGHSCORE_H__
#define __HIGHSCORE_H__

#include <qdialog.h>
#include <qlabel.h>
#include <qlist.h>

#define HS_PLACES 10

class HighscoreList : public QDialog
{
  Q_OBJECT
public:
  HighscoreList( QWidget *parent );
  ~HighscoreList();

  void addEntry( int _score, int _level, bool _show );

private slots:
  void slotClose();

signals:
  void dialogClosed();
  
private:
  struct HScore
  {
    QString name;
    int score;
    int level;
  };
  HScore hiscores[HS_PLACES];

  void addEntry( const QString &_name, int _score, int _level );
  void showList();
  void readList();
  void saveList();

  QString playername;
  int places;	// number of places in Hiscore list used
  QLabel *label;
};

#endif	// __HIGHSCORE_H__
