/*
 *  Copyright (c) 2000 Matthias Elter <elter@kde.org>
 *  based on keyes (C) 1999 by Jerome Tollet <tollet@magic.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 */


#include <stdlib.h>


#include <qpainter.h>
#include <qstringlist.h>


#include <klocale.h>
#include <kglobal.h>
#include <kapp.h>
#include <kdebug.h>
#include <kwinmodule.h>
#include <kcmdlineargs.h>
#include <kprocess.h>


#include <X11/Xlib.h>
#include <X11/Xutil.h>


#include "swallow.h"


void parseCommand(KProcess *proc, QString cmd)
{
  int pos;

  cmd += " ";

  pos = cmd.find(' ');
  *proc << cmd.left(pos);
  kdDebug() << "CMD: exe=" << cmd.left(pos) << endl;
  cmd.remove(0,pos);
  cmd = cmd.stripWhiteSpace();

  // FIXME: Honour quoting!
  QStringList args = QStringList::split(' ', cmd);
  QStringList::ConstIterator it;
  for (it=args.begin(); it != args.end(); ++it)
    {
      *proc << *it;
      kdDebug() << "CMD: arg=" << *it << endl;
    }
}


SwallowApplet::SwallowApplet(QWidget* parent, const char* name)
  : KPanelApplet(parent, name), process(0)
{
  embed = new QXEmbed(this);

  winModule = new KWinModule(this);
  connect(winModule, SIGNAL(windowAdd(WId)), this, SLOT(windowAdd(WId)));

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QCString cmd = args->getOption("c");
  if (!cmd.isEmpty())
    {
      KProcess *process = new KProcess;
      parseCommand(process, cmd);

      // move window out of sight
      *process << "-geometry";
      *process << QString("32x32+%1+%2").arg(kapp->desktop()->width()).arg(kapp->desktop()->height());

      connect(process, SIGNAL(processExited(KProcess*)),
	      this, SLOT(processExited(KProcess*)));

      process->start();
    }
}


SwallowApplet::~SwallowApplet() 
{
  delete winModule;
  delete process;
}


int SwallowApplet::widthForHeight(int h)
{
  // I want to have a quadratic shape.
  return h;
}


int SwallowApplet::heightForWidth(int w)
{
  // I want to have a quadratic shape.
  return w;
}


void SwallowApplet::resizeEvent(QResizeEvent *e)
{
  KPanelApplet::resizeEvent(e);
  embed->resize(width(), height());
}


void SwallowApplet::windowAdd(WId win)
{
  // determine title of newly mapped window
  XTextProperty nameProp;
  XGetWMName(qt_xdisplay(), win, &nameProp);
  char **names;
  int count;
  XTextPropertyToStringList(&nameProp, &names, &count);
  if (count < 1)
    {
      XFreeStringList(names);
      return;
    }

  // is this our client?
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QCString title = args->getOption("t");
  if (!title.isEmpty() && title == names[0])
    {
      kdDebug()<< "embedded window!" << endl;

      embed->embed(win);
      XReparentWindow(qt_xdisplay(), win, embed->winId(), 0, 0);

      disconnect(winModule, SIGNAL(windowAdd(WId)), this, SLOT(windowAdd(WId)));
    }

  XFreeStringList(names);
}


void SwallowApplet::processExited(KProcess */*proc*/)
{
  // the process died, so we terminate the applet as well
  kapp->quit();
}


#include "swallow.moc"
