#ifndef SECURITY_H
#define SECURITY_H

#include "ftpaccess.h"
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>

class Security : public QWidget {
	Q_OBJECT
public:
	Security(QWidget *parent=0, const char *name=0);
	~Security();
public slots:
	void ftpaccessLoaded(ftpaccess *xs);
	void update();
	void addNoRetPressed();
	void delNoRetPressed();
	void noRetAdded(char const * const filename);
private:
	void		redrawNoRetrieves();
	ftpaccess *	ftpxs;
	QListBox *	noretrieves;
	QPushButton *	addNoRet;
	QPushButton *	delNoRet;
	QSpinBox *	loginfails;
	QCheckBox *	priv;
	QCheckBox *	chmodAnon;
	QCheckBox *	chmodGuest;
	QCheckBox *	chmodReal;
	QCheckBox *	deleteAnon;
	QCheckBox *	deleteGuest;
	QCheckBox *	deleteReal;
	QCheckBox *	overwriteAnon;
	QCheckBox *	overwriteGuest;
	QCheckBox *	overwriteReal;
	QCheckBox *	renameAnon;
	QCheckBox *	renameGuest;
	QCheckBox *	renameReal;
	QCheckBox *	umaskAnon;
	QCheckBox *	umaskGuest;
	QCheckBox *	umaskReal;
	QRadioButton *	PasswdNone;
	QRadioButton *	PasswdTrivial;
	QRadioButton *	PasswdRFC;
	QCheckBox *	PasswdEnforce;
};

#endif

