/***************************************************************************
                          ksv_core.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#pragma implementation

#include <qpushbutton.h>
#include <qstylesheet.h>
#include <kapp.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include "ksv_conf.h"
#include "ksvdraglist.h"
#include "kservice.h"
#include "minmax.h"
#include "ksv_core.h"


extern "C" {
#include <ctype.h>
#include <unistd.h>
#include <netdb.h>
}


KAboutData* KSVCore::mAbout = 0L;

void KSVCore::goodSize (QPushButton* button)
{
//   const int w = button->sizeHint().width();
//   const int h = button->sizeHint().height();

  button->setMinimumSize (button->sizeHint());
  //  button->setMinimumSize( (w<75) ? 75 : w, (h<25) ? 25 : h);
}

bool KSVCore::getServiceDescription (const QString& path, QString& res)
{
  KService* tmp = KService::newService (path, KSVConfig::self()->runlevelPath());
  res = i18n ("No description available.");
  bool result = false;

  if (tmp)
    {
      res = tmp->description();
      result = true;
    }

  delete tmp;

  return result;
}

QString KSVCore::breakWords (const QString& s, int amount)
{
#define FUZZ amount/5

  QString res;

  int left = s.length();
  int maximum = amount;
  QString str = s;

  while (left > maximum)
    {
      int pos = -1;
      for (int i = 1; i < FUZZ; ++i)
        {
          if ((pos = str.find(' ', amount - i, false)) < 0 || (pos > maximum + i))
            continue;
          else
            break;
        }

      maximum = max(maximum, pos);
      res += str.left(pos) + "\n";
      left += -pos - 1;
      str = str.right(left);
    }

  res += str;
//  debug("breaking %s", s.data());
//  const int len = s.length();

//  if (len <= amount + FUZZ)
//    return s;

//  int pos = -1;
//  for (int i = 1; i <= ITER; ++i)
//    {
//      if ((pos = s.find(' ', amount - FUZZ * i, false)) < 0 || (pos > amount + FUZZ * i))
//        continue;
//      else
//        break;
//    }

//  QString left = s.left(pos);
//  QString right = s.right(len - pos - 1);

//  return left + "\n" + breakWords (right, amount);
  return res;
}

const QString& KSVCore::copyrightSymbol ()
{
  static QString c = QString::fromUtf8 ("©");

  return c;
}

QString KSVCore::hostname ()
{
#ifndef BUFFER_LEN
#define BUFFER_LEN 255
#endif
  char buffer[BUFFER_LEN];
  QString hostname;

  if (!gethostname (buffer, BUFFER_LEN))
    {
      hostent* info = gethostbyname (buffer);

      hostname = info->h_name;
    }
  else
    {
      hostname = i18n("Unknown Host");
    }
#ifdef BUFFER_LEN
#undef BUFFER_LEN
#endif

  return hostname;
}

QStyleSheet* KSVCore::styleSheet ()
{
  static QStyleSheet style;
  static bool initialized = false;

  if (!initialized)
	{
	  QStyleSheetItem* item = new QStyleSheetItem (&style, "vip"); // very important
	  item->setLogicalFontSize (5);
	  item->setFontWeight (QFont::Bold);

	  item = new QStyleSheetItem (&style, "rl"); // runlevel
	  item->setLogicalFontSize (4);
	  item->setFontWeight (QFont::Bold);

	  item = new QStyleSheetItem (&style, "start"); // start section
	  item->setColor (Qt::green);

	  item = new QStyleSheetItem (&style, "stop"); // stop section
	  item->setColor (Qt::red);

	  item = new QStyleSheetItem (&style, "error"); // signal an error
	  item->setColor (Qt::red);
	  item->setLogicalFontSizeStep (1);

	  item = new QStyleSheetItem (&style, "cmd"); // command line
	  item->setFontFamily (KGlobalSettings::fixedFont().family());
	}

  return &style;
}
