// (c) 2000 Peter Putzer

#pragma implementation

#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <kdualcolorbtn.h>
#include <kapp.h>
#include <kfiledialog.h>

#include "ksv_conf.h"
#include "ksv_core.h"

#include "PreferencesDialog.h"

#define MIN_SIZE(A) A->setMinimumSize (A->sizeHint())

KSVPreferences::KSVPreferences (QWidget* parent)
  :  KDialogBase (IconList, i18n("Preferences"), Help|Ok|Apply|Cancel, Ok,
				  parent, "KSysV Preferences", true, true),
  mConfig (KSVConfig::self())
{
  setMinimumSize (sizeHint ());
  
  /**
   * Colors Page
   */
  QFrame* colorPage = addPage (i18n("Colors"), QString::null, DesktopIcon ("colors", 32));
  mNewColors = new KDualColorButton(black, white, colorPage, "NewColors Button");
  mChangedColors = new KDualColorButton(black, white, colorPage, "ChangedColors Button");

  QLabel* newColorsLabel = new QLabel(i18n("Colors for &new entries"), colorPage);
  QLabel* changedColorsLabel = new QLabel(i18n("Colors for c&hanged entries"), colorPage);
  newColorsLabel->setBuddy(mNewColors);
  changedColorsLabel->setBuddy(mChangedColors);
  MIN_SIZE(newColorsLabel);
  MIN_SIZE(changedColorsLabel);

  QBoxLayout* colorLayout = new QVBoxLayout(colorPage, 5);
  QBoxLayout* newColorsLayout = new QHBoxLayout();
  QBoxLayout* changedColorsLayout = new QHBoxLayout();
  colorLayout->addLayout(newColorsLayout, 5);
  colorLayout->addLayout(changedColorsLayout, 5);

  newColorsLayout->addWidget(newColorsLabel, 0, AlignLeft);
  newColorsLayout->addStretch(10);
  newColorsLayout->addWidget(mNewColors, 0, AlignRight);

  changedColorsLayout->addWidget(changedColorsLabel, 0, AlignLeft);
  changedColorsLayout->addStretch(10);
  changedColorsLayout->addWidget(mChangedColors, 0, AlignRight);

  // some more connections
  connect (mNewColors, SIGNAL(changed(const QColor&)), this, SLOT(colorChanged()));
  connect (mChangedColors, SIGNAL(changed(const QColor&)), this, SLOT(colorChanged()));

  colorLayout->addStretch(2*10);


  /**
   * Paths Page
   */
  QFrame* pathPage = addPage (i18n ("Paths"), QString::null, DesktopIcon ("konqueror", 32));

  QBoxLayout* pathLayout = new QVBoxLayout(pathPage, 5);

  QLabel* prefix = new QLabel(i18n("Directory containing your init-scripts (&services)"), pathPage);
  MIN_SIZE(prefix);
  pathLayout->addWidget(prefix);

  QBoxLayout* scripts = new QHBoxLayout();
  pathLayout->addLayout(scripts, 1);
  pathLayout->addSpacing(10);

  // script path
  mScriptPath = new KLineEdit(pathPage);
  prefix->setBuddy(mScriptPath);
  MIN_SIZE(mScriptPath);

  mBrowseScripts = new QPushButton(i18n("Browse..."), pathPage);
  mBrowseScripts->setAutoDefault(FALSE);
  MIN_SIZE(mBrowseScripts);

  scripts->addWidget(mScriptPath, 10);
  scripts->addWidget(mBrowseScripts, 1);

  // Runlevel Path
  QLabel* runlevelsLabel = new QLabel(i18n("Directory containing your &runlevel-directories"), pathPage);
  MIN_SIZE(runlevelsLabel);
  pathLayout->addWidget(runlevelsLabel);

  QBoxLayout* Runlevels = new QHBoxLayout();
  pathLayout->addLayout(Runlevels, 1);
  pathLayout->addStretch( 2*10 );

  mRunlevelsPath = new KLineEdit(pathPage);
  runlevelsLabel->setBuddy(mRunlevelsPath);
  MIN_SIZE(mRunlevelsPath);

  mBrowseRunlevels = new QPushButton(i18n("Browse..."), pathPage);
  mBrowseRunlevels->setAutoDefault(FALSE);
  MIN_SIZE(mBrowseRunlevels);

  Runlevels->addWidget(mRunlevelsPath, 10);
  Runlevels->addWidget(mBrowseRunlevels, 1);

  // some connections
  connect(mBrowseScripts, SIGNAL(clicked()), this, SLOT(scriptDir()));
  connect(mBrowseRunlevels, SIGNAL(clicked()), this, SLOT(runlevelDir()));

  /**
   * Miscellaneous Page
   */
  QFrame* miscPage = addPage (i18n("Miscellaneous"), i18n("Settings not fitting anywhere else"),
							  DesktopIcon ("ksysv", 32));

  reReadConfig();
}

KSVPreferences::~KSVPreferences ()
{
}

void KSVPreferences::colorChanged()
{
  mColorsChanged = true;
}

void KSVPreferences::scriptDir()
{
  QString tmp = KFileDialog::getExistingDirectory(mScriptPath->text(), this);

  if (!tmp.isEmpty())
    mScriptPath->setText(tmp);
  
  mScriptPath->setFocus();
}

void KSVPreferences::runlevelDir()
{
  QString tmp = KFileDialog::getExistingDirectory(mRunlevelsPath->text(), this);

  if (!tmp.isEmpty())
    mRunlevelsPath->setText(tmp);

  mRunlevelsPath->setFocus();
}

void KSVPreferences::reReadConfig()
{
  mRunlevelsPath->setText(mConfig->runlevelPath());
  mScriptPath->setText(mConfig->scriptPath());

  mNewColors->setForeground (mConfig->newNormalColor());
  mNewColors->setBackground (mConfig->newSelectedColor());

  mChangedColors->setForeground (mConfig->changedNormalColor ());
  mChangedColors->setBackground (mConfig->changedSelectedColor ());
}

void KSVPreferences::slotCancel ()
{
  KDialogBase::slotCancel ();
  
  reReadConfig();
}

void KSVPreferences::slotApply ()
{
  KDialogBase::slotApply();

  setConfig();
}

void KSVPreferences::slotOk ()
{
  KDialogBase::slotOk ();
  
  setConfig ();
}

KSVPreferences* KSVPreferences::self ()
{
  KSVPreferences* prefs = new KSVPreferences (kapp->mainWidget());

  return prefs;
}

void KSVPreferences::setConfig ()
{
  mConfig->setScriptPath (mScriptPath->text());
  mConfig->setRunlevelPath (mRunlevelsPath->text());
}
