/***************************************************************************
                          OldView.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-2000 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

/*****************************************
 **                                     **
 **            Main Widget              **
 **                                     **
 *****************************************/

#include "IOCore.h"
#include <qprogdlg.h>
#include <qkeycode.h>
#include <qmsgbox.h>
#include <qmlined.h>
#include <qgrpbox.h>
#include <qaccel.h>
#include <qscrbar.h>
#include <qtextview.h>
#include <qcstring.h>
#include <qclipboard.h>
#include <qheader.h>
#include <qlabel.h>
#include <qstylesheet.h>
#include <qwhatsthis.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qmime.h>
#include <qvaluelist.h>
#include <qsplitter.h>

#include <kapp.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kprocess.h>
#include <kstddirs.h>
#include <kcursor.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kglobalsettings.h>
#include <kdialog.h>

#include "ksvdraglist.h"
#include "trash.h"
#include "ksv_core.h"
#include "ksv_conf.h"
#include "PropDlg.h"
#include "OldView.h"
#include "ActionList.h"
#include "TopWidget.h"
extern "C" {
#include <unistd.h>
}

// define macros
#include "Constants.h"
#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

KSVContent::KSVContent(KSVTopLevel* parent, const char* name)
  : QWidget (parent, name),
    conf(KSVConfig::self()),
    mClearing(false),
	mScriptBox (0L)
{
  KXMLGUIFactory* factory = parent->factory();
  mItemMenu = static_cast<KPopupMenu*> (factory->container ("item_menu", parent));
  mItemMenu->insertTitle (i18n ("Runlevel Menu"), -1, 0);
  mContextMenu = static_cast<KPopupMenu*> (factory->container ("list_menu", parent));
  mContextMenu->insertTitle (i18n ("Runlevel Menu"), -1, 0);
  mScriptMenu = static_cast<KPopupMenu*> (factory->container ("script_menu", parent));
  mScriptMenu->insertTitle (i18n ("Services Menu"), -1, 0);

  // main content window
  panner = new QSplitter (QSplitter::Vertical, this, "Panner");
  scroller = new QScrollView (panner);

  QBoxLayout* top = new QHBoxLayout (scroller->viewport());
  //content = new QWidget(scroller->viewport());
  //  mContent = new QSplitter (QSplitter::Horizontal, scroller->viewport(), "ServicesPanner");
  mContent = new QFrame (scroller->viewport(), "KSysV Real Content");

  mContent->installEventFilter (this); // update panningFactor
  top->addWidget (mContent);

  scroller->addChild (mContent);
  scroller->setResizePolicy (QScrollView::AutoOne);

  initLList();

  panner->setSizes(KSVContent::panningFactorToSplitter (conf->panningFactor()));

  initLayout();

  // someone must have focus
  scripts->setFocus();

  mContent->setMinimumSize (mContent->minimumSizeHint());
  setMinimumSize (kapp->desktop()->size() / 2);

  // show/hide everything
  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  if (conf->showRunlevel (i))
		mRunlevels[i]->show();		
	  else
		mRunlevels[i]->hide();
	}

  textDisplay->setStyleSheet (KSVCore::styleSheet());
}

KSVContent::~KSVContent()
{
}

void KSVContent::initLList()
{
  mScriptBox = new QVBox (mContent);
  mScriptBox->setSpacing (KDialog::spacingHint());

  QVBox* scriptLabelBox = new QVBox (mScriptBox);
  new QLabel (i18n("Available"), scriptLabelBox);
  QLabel* servL = new QLabel (i18n("&Services"), scriptLabelBox);

//   // DEBUG
  QMimeSourceFactory::defaultFactory()->addFilePath ("/home/jester/Personal/kdeadmin/ksysv/pics");
//   // DEBUG

  // provide quickhelp
  QWhatsThis::add (scriptLabelBox,
				   i18n("<p>These are the <img src=\"ksysv_exec.xpm\"/> <strong>services</strong> available on your computer." \
						"To start a service, drag it onto the <em>Start</em> " \
						"section of a runlevel.</p>" \
						"<p>To stop one, do the same for the <em>Stop</em> section.</p>"));


  QFont bold_font = QFont(KGlobalSettings::generalFont());
  bold_font.setBold(TRUE);
  servL->setFont(bold_font);

  scripts = new KSVDragList (scriptLabelBox, "Scripts");
  scripts->setAcceptDrops (false);
  scripts->setDragMode (QDragObject::DragCopy);
  scripts->setColumnWidthMode (KSVItem::SortNumber, QListView::Manual);
  scripts->setColumnWidth(KSVItem::SortNumber,0);
  scripts->setSorting (KSVItem::ServiceName);
  scripts->header()->setResizeEnabled (false, 0);
  scripts->setCommonToolTips (true);

  scripts->setDefaultIcon (SmallIcon("ksysv_exec"));

  // setBuddy
  servL->setBuddy(scripts);

  // doubleclick && return
  connect (scripts, SIGNAL(executed(QListViewItem*)),
		   this, SLOT(slotScriptProperties(QListViewItem*)));
  connect (scripts, SIGNAL (returnPressed (QListViewItem*)),
		   this, SLOT (slotScriptProperties (QListViewItem*)));
	
  // context menus
  connect (scripts, SIGNAL (contextMenu (KListView*, QListViewItem*, const QPoint&)),
 		   this, SLOT (popupServicesMenu (KListView*, QListViewItem*, const QPoint&)));

  // for cut & copy
  connect (scripts, SIGNAL (mouseButtonPressed (int, QListViewItem*, const QPoint&, int)),
		   this, SLOT (fwdSelectedScripts (int, QListViewItem*, const QPoint&, int)));

  trash = new KSVTrash(mScriptBox, "Trash");
  connect (trash, SIGNAL (undoAction (KSVAction*)), this, SLOT (fwdUndoAction (KSVAction*)));

  for(int i = 0; i < RUNLEVEL_NR; ++i)
    {
      mRunlevels[i] = new QVBox (mContent);
	  mRunlevels[i]->setSpacing (KDialog::spacingHint());

      // create QString for label
      QString _label (i18n("Runlevel &%1").arg(i));
      // and for the name
      QString _name (i18n("Runlevel %1").arg(i));

	  QVBox* startBox = new QVBox (mRunlevels[i]);
      QLabel* rlL = new QLabel(_label, startBox);
      new QLabel(i18n("Start"), startBox);
      rlL->setFont(bold_font);

      // create the "START" list:
      startRL[i] = new KSVDragList(startBox, (_name + " START").data());
	  startRL[i]->setDragMode (QDragObject::DragCopyOrMove);
	  startRL[i]->setDefaultIcon(SmallIcon("ksysv_start"));
	  startRL[i]->setCommonToolTips (true);

	  QVBox* stopBox = new QVBox (mRunlevels[i]);
      new QLabel(i18n("Stop"), stopBox);

      // create the "STOP" list:
      stopRL[i] = new KSVDragList(stopBox, (_name + " STOP").data());
	  stopRL[i]->setDragMode (QDragObject::DragCopyOrMove);
	  stopRL[i]->setDefaultIcon(SmallIcon("ksysv_stop"));
      stopRL[i]->setCommonToolTips (true);

      // set the buddy widget for the "Runlevel %i" label... => the corresponding runlevel
      rlL->setBuddy(startRL[i]);
      
      // for cut & copy // FIXME
	  connect (startRL[i], SIGNAL (mouseButtonPressed (int, QListViewItem*, const QPoint&, int)),
			   this, SLOT (fwdSelected (int, QListViewItem*, const QPoint&, int)));
	  connect (startRL[i], SIGNAL (currentChanged (QListViewItem*)),
			   this, SLOT (fwdEmpty (QListViewItem*)));

      connect (stopRL[i], SIGNAL (mouseButtonPressed (int, QListViewItem*, const QPoint&, int)),
			   this, SLOT (fwdSelected (int, QListViewItem*, const QPoint&, int)));
	  connect (stopRL[i], SIGNAL (currentChanged (QListViewItem*)),
			   this, SLOT (fwdEmpty (QListViewItem*)));
    }

  connect (scripts, SIGNAL(undoAction(KSVAction*)),
		   this, SLOT(fwdUndoAction(KSVAction*)));

  // add text-diplay widget
  textDisplay = new QTextView (QString::null, QString::null, panner, "TextDisplayWidget");

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  connect (startRL[i], SIGNAL(newOrigin()), stopRL[i], SLOT(slotNewOrigin()));
	  connect (stopRL[i], SIGNAL(newOrigin()), startRL[i], SLOT(slotNewOrigin()));

	  connect (startRL[i], SIGNAL(undoAction(KSVAction*)),
			   this, SLOT(fwdUndoAction(KSVAction*)));
	  connect (stopRL[i], SIGNAL(undoAction(KSVAction*)),
			   this, SLOT(fwdUndoAction(KSVAction*)));
	
	  // doubleclick && return
	  connect (startRL[i], SIGNAL(executed(QListViewItem*)),
			   this, SLOT(slotDoubleClick(QListViewItem*)));
	  connect (stopRL[i], SIGNAL(executed(QListViewItem*)),
			   this, SLOT(slotDoubleClick(QListViewItem*)));
	  connect (startRL[i], SIGNAL(returnPressed(QListViewItem*)),
			   this, SLOT(slotDoubleClick(QListViewItem*)));
	  connect (stopRL[i], SIGNAL(returnPressed(QListViewItem*)),
			   this, SLOT(slotDoubleClick(QListViewItem*)));
	  
	  // context menus
	  connect (startRL[i], SIGNAL (contextMenu (KListView*, QListViewItem*, const QPoint&)),
			   this, SLOT (popupRunlevelMenu (KListView*, QListViewItem*, const QPoint&)));
	  connect (stopRL[i], SIGNAL (contextMenu (KListView*, QListViewItem*, const QPoint&)),
			   this, SLOT (popupRunlevelMenu (KListView*, QListViewItem*, const QPoint&)));

	  // cannot generate sorting number
	  connect (startRL[i], SIGNAL(cannotGenerateNumber()),
			   this, SLOT(fwdCannotGenerateNumber()));
	  connect (stopRL[i], SIGNAL(cannotGenerateNumber()),
			   this, SLOT(fwdCannotGenerateNumber()));
	
	  // connecting origin things for "Scripts", too
	  connect (scripts, SIGNAL(newOrigin()), startRL[i], SLOT(slotNewOrigin()));
	  connect (scripts, SIGNAL(newOrigin()), stopRL[i], SLOT(slotNewOrigin()));
	  connect (startRL[i], SIGNAL(newOrigin()), scripts, SLOT(slotNewOrigin()));
	  connect (stopRL[i], SIGNAL(newOrigin()), scripts, SLOT(slotNewOrigin()));
	
	  // something changed
	  connect( startRL[i], SIGNAL(changed()), this, SLOT(slotChanged()));
	  connect( stopRL[i], SIGNAL(changed()), this, SLOT(slotChanged()));
	
	
	  // use this loop for setting tooltips
	  startRL[i]->setToolTip (i18n("Drag here to start services\nwhen entering Runlevel %1").arg(i));
	  stopRL[i]->setToolTip (i18n("Drag here to stop services\nwhen entering Runlevel %1").arg(i));
	
	  for (int j = 0; j < RUNLEVEL_NR; ++j)
		{
		  if (i != j)
			{		
			  connect (startRL[i], SIGNAL (newOrigin()), startRL[j], SLOT (slotNewOrigin()));
			  connect (stopRL[i], SIGNAL (newOrigin()), stopRL[j], SLOT (slotNewOrigin()));
			
			  connect (startRL[i], SIGNAL(newOrigin()), stopRL[j], SLOT(slotNewOrigin()));
			  connect (stopRL[i], SIGNAL(newOrigin()), startRL[j], SLOT(slotNewOrigin()));
			}
		}
	}
}

void KSVContent::fwdUndoAction (KSVAction* a)
{
  emit undoAction(a);
}

void KSVContent::initScripts() {
  QDir scriptDir = QDir(conf->scriptPath());
  if (!scriptDir.exists())
	return;

  scriptDir.setFilter( QDir::Files | QDir::Hidden |
		       QDir::NoSymLinks | QDir::Executable);

  scriptDir.setSorting( QDir::Name );

  const QFileInfoList *scriptList = scriptDir.entryInfoList();
  QFileInfoListIterator it( *scriptList );
  QFileInfo* fi;
  while ((fi=it.current()))
    {
      scripts->initItem(fi->fileName(),
			IOCore::relToAbs(conf->scriptPath(),
					 fi->dirPath(FALSE)),
			fi->fileName(), 0);
      ++it;

      // keep GUI alive
      qApp->processEvents();
    }

  scripts->setToolTip (i18n("The services available on your computer"));
}

void KSVContent::initRunlevels()
{
  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      const QString _path = conf->runlevelPath() + QString("/rc%1.d").arg(i);

      if (!QDir(_path).exists())
		continue;

      QDir d = QDir(_path);
      d.setFilter( QDir::Files );
      d.setSorting( QDir::Name );

      const QFileInfoList *rlList = d.entryInfoList();
      QFileInfoListIterator it( *rlList ); // create list iterator
      QFileInfo* fi;                       // pointer for traversing

      // progress
      emit advance(1);

      while ( (fi=it.current()) )
		{                       // for each file...
		  info2Widget( fi, i);
		  ++it;        	      // goto next list element
	
		  // keep GUI alive
		  qApp->processEvents();
		}

      // progress
      emit advance(1);
    }
}

void KSVContent::fwdEmpty (QListViewItem* item)
{
  if (!item)
	emit selected (0L);
}

void KSVContent::info2Widget( QFileInfo* info, int index ) {
  if (!info->exists())
    return;

  //QString l_name = info->readLink();
  QString f_name = info->fileName();

  QFileInfo link_info = QFileInfo(info->readLink());
  QString l_base = link_info.fileName();

  QString l_path = IOCore::relToAbs(conf->scriptPath(), link_info.dirPath(FALSE));

  QString name;
  int number;
  IOCore::dissectFilename( f_name, name, number );

  // finally insert the items...
  if ( f_name.left(1) == "S" )
    startRL[index]->initItem( l_base, l_path, name, number );
  else
    stopRL[index]->initItem( l_base, l_path, name, number );
}

void KSVContent::slotWriteSysV()
{
  appendLog(i18n("<vip>** WRITING CONFIGURATION **</vip>"));

  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
	  appendLog(i18n("<rl>** RUNLEVEL %1 **</rl>").arg(i));

      clearRL(i); // rm changed/deleted entries
	
      // process "Start"
	  KSVItem* item = 0L;
	  for (QListViewItemIterator it (startRL[i]);
		   (item = static_cast<KSVItem*> (it.current()));
		   ++it)
		{
		  if (item->isChanged() || item->isNew())
			writeToDisk (*item->data(), i, true);
		}

	  // process "Stop"
	  for (QListViewItemIterator it (stopRL[i]);
		   (item = static_cast<KSVItem*> (it.current()));
		   ++it)
		{
		  if (item->isChanged() || item->isNew())
			writeToDisk (*item->data(), i, false);
		}

	  appendLog("<br/><br/>");
	}

  appendLog("<br/>");
}

void KSVContent::writeToDisk(const KSVData& _w, int _rl, bool _start) {
  appendLog(IOCore::makeSymlink(_w, _rl, _start));
}

void KSVContent::clearRL(int _rl)
{
  QString path = conf->runlevelPath() + QString("/rc%1.d").arg(_rl);

  QDir dir (path);

  KSVData* d = 0L;

  for (QListIterator<KSVData> it (startRL[_rl]->getDeletedItems());
	   (d = it.current());
	   ++it)
	{
	  // ugly hack -> dont try to delete if entry is new (i.e. not save to disk)
	  if (d->newEntry() && d->originalRunlevel() != startRL[_rl]->name())
		break;

	  QFileInfo file (path + QString("/S%1%2").arg(d->number(), 2).arg(d->label()));
// 											   d->number(),
// 											   d->label().data()));
	  appendLog(IOCore::removeFile(&file, dir));
	}

  // keep GUI alive
  qApp->processEvents();

  for (QListIterator<KSVData> it (stopRL[_rl]->getDeletedItems());
	   (d = it.current());
	   ++it)
	{
	  // ugly, too
	  if (d->newEntry() && d->originalRunlevel() != stopRL[_rl]->name())
		break;
	
	  QFileInfo file (path + QString("/K%1%2").arg(d->number(), 2).arg(d->label()));
// 											   d->number(),
// 											   d->label().data()));
	  appendLog(IOCore::removeFile(&file, dir));
	}

  // keep GUI alive
  qApp->processEvents();
}

void KSVContent::reInit() {

  // MUTEX
  mClearing = true;

  // update GUI
  qApp->processEvents();

  // override cursor
  kapp->setOverrideCursor(KCursor::waitCursor());

  const int total = 2 * 2 * RUNLEVEL_NR + 2;
  emit initProgress(total, i18n("Reading configuration: "));

  // update GUI
  qApp->processEvents();

  // sleep for 0.05 seconds to allow windowmanager
  // gain control of progress dialog (won't work neccessarily,
  // but should in most cases (the faster the system, the better :)
  usleep(DELAY);

  // update GUI
  qApp->processEvents();

  int i = 0;
  for (i = 0; i < RUNLEVEL_NR; ++i) {
    startRL[i]->setEnabled(false);
    startRL[i]->clear();
	startRL[i]->clearRMList();
    emit advance(1);

    // keep GUI alive
    qApp->processEvents();
    usleep(DELAY);

    stopRL[i]->setEnabled(false);
    stopRL[i]->clear();
	stopRL[i]->clearRMList();
    emit advance(1);

    // set new colors
    startRL[i]->setNewNormalColor(conf->newNormalColor());
    startRL[i]->setChangedNormalColor(conf->changedNormalColor());
    stopRL[i]->setNewNormalColor(conf->newNormalColor());
    stopRL[i]->setChangedNormalColor(conf->changedNormalColor());

    // keep GUI alive
    qApp->processEvents();
    usleep(DELAY);
  }

  scripts->setEnabled(false);
  scripts->clear();
  //  emit progress(2*i+1);
  emit advance(1);

  // keep GUI alive
  qApp->processEvents();
  usleep(DELAY);

  initScripts();
  //emit progress(2*i + 2);
  emit advance(1);

  // keep GUI alive
  qApp->processEvents();
  usleep(DELAY);

  initRunlevels();

  // restore cursor
  kapp->restoreOverrideCursor();

  // refresh GUI
  qApp->processEvents();

  // end progress
  emit endProgress();

  scripts->setEnabled(true);
  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      startRL[i]->setEnabled(true);
      stopRL[i]->setEnabled(true);
    }

  startRL[i]->setFocus();
  scripts->setFocus();

  mClearing = false;
}

void KSVContent::slotChanged() {
  emit sigChanged();
}

void KSVContent::infoOnData(KSVItem* data) {
  KSVPropDlg* prop = new KSVPropDlg (data, qApp->mainWidget(), "props");

  KSVData* oldState = data->cloneData();
//   KSVItem* oldState = data->clone();

  connect (prop, SIGNAL(changed(const KSVItem*)),
		   this, SLOT(slotChanged()) );

  connect (prop, SIGNAL(changed(const KSVItem*)),
		   this, SLOT(reSortRL()) );

  int res = prop->exec();
  KSVData* newState = data->cloneData();
  if (res == QDialog::Accepted
      && !(*oldState == *newState && oldState->number() == newState->number()))
    emit undoAction(new ChangeAction(getOrigin(), oldState, newState));

  delete prop;
  delete oldState;
  delete newState;
}

void KSVContent::stopService ()
{
  KSVContent::stopService (getOrigin()->currentItem()->filenameAndPath());
}

void KSVContent::stopService (const QString& path)
{
  KProcess *_proc = new KProcess();
  _proc->clearArguments();

  *_proc << path << "stop";

  connect(_proc, SIGNAL(processExited(KProcess*)), this, SLOT(slotExitedProcess(KProcess*)));
  connect(_proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(slotOutput(KProcess*, char*, int)));
  connect(_proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(slotErr(KProcess*, char*, int)));

  // refresh textDisplay
  appendLog(i18n("** <stop>Stopping</stop> <cmd>%1</cmd> **<br/>").arg(path));
  //appendLog(i18n("** Stopping ") + path + " **<br/>");

  _proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);

  // notify parent
  emit sigRun(path + i18n(" stop"));
}		

void KSVContent::startService ()
{
  KSVContent::startService (getOrigin()->currentItem()->filenameAndPath());
}

void KSVContent::startService (const QString& path)
{
  KProcess* _proc = new KProcess();
  _proc->clearArguments();

  *_proc << path << "start";

  connect(_proc, SIGNAL(processExited(KProcess*)), this, SLOT(slotExitedProcess(KProcess*)));
  connect(_proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(slotOutput(KProcess*, char*, int)));
  connect(_proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(slotErr(KProcess*, char*, int)));

  // refresh textDisplay
  appendLog(i18n("** <start>Starting</start> <cmd>%1</cmd> **<br/>").arg(path));

  _proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);

  // notify parent
  emit sigRun(path + i18n(" start"));
}

void KSVContent::editService()
{
  KSVContent::editService (getOrigin()->currentItem()->filenameAndPath());
}

void KSVContent::editService (const QString& path)
{
  QFileInfo fi (path);

  if (fi.isReadable() && fi.isWritable())
    {
      KProcess proc;
      proc << "kedit" << path;

      proc.start(KProcess::DontCare);
    }
}

void KSVContent::restartService ()
{
  KSVContent::restartService (getOrigin()->currentItem()->filenameAndPath());
}

void KSVContent::restartService (const QString& path)
{
  // stopping
  KProcess *_proc = new KProcess();
  _proc->clearArguments();

  *_proc << path << "stop";

  connect(_proc, SIGNAL(processExited(KProcess*)), this, SLOT(slotExitDuringRestart(KProcess*)));
  connect(_proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(slotOutput(KProcess*, char*, int)));
  connect(_proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(slotErr(KProcess*, char*, int)));

  // refresh textDisplay
  appendLog(i18n("** Re-starting ") + path + " **</br>");

  _proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);

  // notify parent
  emit sigRun(path + i18n(" restart"));
}	

void KSVContent::slotOutput( KProcess*, char* _buffer, int _buflen) {
  if (_buflen > 0) {
    QCString buffer = QCString( _buffer, _buflen + 1 );
    buffer[_buflen]='\0';
    appendLog(buffer);
  }
}

void KSVContent::slotErr( KProcess*, char* _buffer, int _buflen) {
  if (_buflen > 0) {
    QCString buffer = QCString( _buffer, _buflen + 1);
    buffer[_buflen]='\0';
    appendLog(buffer);
  }
}

void KSVContent::slotExitedProcess( KProcess* proc ) {
  appendLog("<hr/>");

  emit sigStop();
  delete proc;
}

void KSVContent::slotToggleOut() {
  const bool showOut = conf->showLog();
  conf->setShowLog(!showOut);

  QValueList<int> l = panner->sizes();

  const QSize tmp = size();
  resize(tmp.width(), tmp.height() - 1);
  resize(tmp);
}

void KSVContent::slotScriptsNotRemovable() {
  emit sigNotRemovable();
}

void KSVContent::slotDoubleClick (QListViewItem* item) {
  infoOnData(static_cast<KSVItem*>(item));
}

void KSVContent::slotScriptProperties(QListViewItem* item)
{
  KSVPropDlg* prop = new KSVPropDlg (static_cast<KSVItem*>(item), kapp->mainWidget(), "props" );
  prop->setEnabled(false);
  prop->exec();

  delete prop;
}

void KSVContent::slotExitDuringRestart( KProcess* proc ) {
  delete proc;
  proc = new KProcess(); // necessary because otherwise we still have some
  			 // signals connected that screw up our output
  proc->clearArguments();

//   QString s_name = getOrigin()->currentItem()->filenameAndPath();
//   *proc << s_name << "start";

  connect(proc, SIGNAL(processExited(KProcess*)), this, SLOT(slotExitedProcess(KProcess*)));
  connect(proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(slotOutput(KProcess*, char*, int)));
  connect(proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(slotErr(KProcess*, char*, int)));

  proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}

void KSVContent::initLayout() {
  QBoxLayout* realTopLayout = new QVBoxLayout(this);
  realTopLayout->addWidget(panner);
//   panner->activate(mContent, textDisplay);
  realTopLayout->activate();

  QBoxLayout* topLayout = new QHBoxLayout(mContent);
  topLayout->setSpacing (KDialog::spacingHint());
  topLayout->setMargin (KDialog::marginHint());

  //  QBoxLayout* scriptLayout = new QVBoxLayout();
  //  topLayout->addLayout(scriptLayout);

  // scripts
  //  MIN_SIZE(avaiL);
  //  MIN_SIZE(servL);
//   MIN_SIZE(scripts);
  //  MIN_SIZE(trash);
  //  trash->setFixedHeight(TRASH_HEIGHT);
  topLayout->addWidget (mScriptBox);
//   scriptLayout->addWidget(avaiL);
//   scriptLayout->addWidget(servL);
//   scriptLayout->addWidget(scripts);
//   scriptLayout->addWidget(trash);

  // runlevels
  for (int i = 0; i < RUNLEVEL_NR; ++i) {
//     // a bit of extra spacing
//     topLayout->addSpacing(1);
	
	topLayout->addWidget (mRunlevels[i]);
//     QBoxLayout* rlLayout = new QVBoxLayout();
//     topLayout->addLayout(rlLayout, KDialog::spacingHint());

//     MIN_SIZE(rlL[i]);
//     MIN_SIZE(startL[i]);
// //     MIN_SIZE(startRL[i]);
//     MIN_SIZE(stopL[i]);
// //     MIN_SIZE(stopRL[i]);

//     rlLayout->addWidget(rlL[i]);
//     rlLayout->addWidget(startL[i]);
//     rlLayout->addWidget(startRL[i], KDialog::spacingHint());
//     rlLayout->addSpacing(KDialog::spacingHint());
//     rlLayout->addWidget(stopL[i]);
//     rlLayout->addWidget(stopRL[i], KDialog::spacingHint());
  }

  topLayout->activate();
}

KSVDragList* KSVContent::getOrigin() {
  KSVDragList* result = 0L;

  for (int i = 0; i < RUNLEVEL_NR; ++i)
	{
	  result = startRL[i]->isOrigin() ? startRL[i] : result;
	  result = stopRL[i]->isOrigin() ? stopRL[i] : result;
	}

  result = scripts->isOrigin() ? scripts : result;

  return result;
}

void KSVContent::setDisplayScriptOutput(bool val)
{
  if (val)
    {
//       QValueList<int> l;
//       l << conf->panningFactor() << 100 - conf->panningFactor();

      panner->setSizes(KSVContent::panningFactorToSplitter (conf->panningFactor()));
      textDisplay->show();
    }
  else
    {
//       QValueList<int> l = panner->sizes();
//       const int cont_size = *l.at(0);
//       const int log_size = *l.at(1);

//       const int panningFactor = KSVContent::splitterToPanningFactor (panner->sizes());

      conf->setPanningFactor (KSVContent::splitterToPanningFactor (panner->sizes()));
      textDisplay->hide();
    }
}

int KSVContent::splitterToPanningFactor (const QValueList<int>& list)
{
  const int cont_size = *list.at(0);
  const int log_size = *list.at(1);

  return cont_size * 100 / (cont_size + log_size);
}

const QValueList<int>& KSVContent::panningFactorToSplitter (int panningFactor)
{
  static QValueList<int> res;
  res.clear();

  res << panningFactor << 100 - panningFactor;

  return res;
}

void KSVContent::appendLog (const QString& txt)
{
  static bool changed = false;

  if (!changed)
    {
      changed = true;
      emit logChanged();
    }

  textDisplay->append (txt);
}

QString KSVContent::log () const
{
  kdDebug() << "Logfile " << textDisplay << " \"" << textDisplay->text() << "\"" << endl;
  return textDisplay->text();
}

void KSVContent::fwdCannotGenerateNumber() {
  emit cannotGenerateNumber();
}

void KSVContent::updatePanningFactor() {
  //  if (conf->showLog() && conf->panningFactor() != panner->separatorPos())
  conf->setPanningFactor(KSVContent::splitterToPanningFactor(panner->sizes()));
}

void KSVContent::fwdSelected (int, QListViewItem* item, const QPoint&, int)
{
  emit selected (dynamic_cast<KSVItem*> (item));
}

void KSVContent::fwdSelectedScripts (int, QListViewItem* item, const QPoint&, int)
{
  emit selectedScripts (dynamic_cast<KSVItem*> (item));
}

void KSVContent::reSortRL()
{
  getOrigin()->sort();
}

void KSVContent::pasteAppend()
{
  KSVDragList* list = getOrigin();

  if (list)
    {
	  KSVData data;
	
	  if (KSVDrag::decodeNative (kapp->clipboard()->data(), data))
		{
		  KSVAction* action = 0L;
		
		  if (list->insert (data, list->lastChild(), action))
			{
			  slotChanged ();
			  emit undoAction (action);
			}
		}
	}
}

bool KSVContent::eventFilter (QObject* o, QEvent* e)
{
  if (e->type() == QEvent::Resize)
	{
	  updatePanningFactor();
	}

  return false;
}

void KSVContent::resizeEvent (QResizeEvent* e)
{
  QWidget::resizeEvent (e);
}

void KSVContent::moveEvent (QMoveEvent* e)
{
  QWidget::moveEvent (e);
}

void KSVContent::setNewNormalColor (const QColor& c)
{
  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      startRL[i]->setNewNormalColor(c);
      stopRL[i]->setNewNormalColor(c);
    }
}

void KSVContent::setChangedNormalColor (const QColor& c)
{
  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      startRL[i]->setChangedNormalColor(c);
      stopRL[i]->setChangedNormalColor(c);
    }
}

void KSVContent::repaintRunlevels (bool val)
{
  for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      startRL[i]->repaint(val);
      stopRL[i]->repaint(val);
    }
}

void KSVContent::multiplexEnabled (bool val)
{
  QListView* list = getOrigin();

  if (list)
	{
	  list->clearSelection();
	  list->setCurrentItem (0L);
	}


    for (int i = 0; i < RUNLEVEL_NR; ++i)
    {
      startRL[i]->setEnabled (val);
      stopRL[i]->setEnabled (val);
    }

	scripts->setEnabled (val);
}

void KSVContent::hideRunlevel (int index)
{
  const int oldPan = conf->panningFactor ();

  mRunlevels[index]->hide();
  mContent->setMinimumSize (mContent->minimumSizeHint());

  doPannerResize (oldPan);

}

void KSVContent::showRunlevel (int index)
{
  const int oldPan = conf->panningFactor ();

  mRunlevels[index]->show();
  mContent->setMinimumSize (mContent->minimumSizeHint());

  doPannerResize (oldPan);
}

void KSVContent::doPannerResize (int oldPan)
{
  const QSize minSize = textDisplay->minimumSize();
  textDisplay->setMinimumSize (QSize (1,1));

  setUpdatesEnabled (false);

  if (!textDisplay->isVisible())
	{
	  conf->setPanningFactor (100);
	  setDisplayScriptOutput (true);
 	  kapp->processOneEvent();
	  setDisplayScriptOutput (false);
	  conf->setPanningFactor (oldPan);
	}
  else
	{
	  panner->setSizes (KSVContent::panningFactorToSplitter (oldPan + 1));
	  kapp->processOneEvent();
	  panner->setSizes (KSVContent::panningFactorToSplitter (oldPan));
	}

  setUpdatesEnabled (true);

  textDisplay->setMinimumSize (minSize);
}

void KSVContent::popupRunlevelMenu (KListView*, QListViewItem* i, const QPoint& p)
{
  if (i)
	mItemMenu->exec (p, 1);
  else
	mContextMenu->exec (p, 1);
}

void KSVContent::popupServicesMenu (KListView*, QListViewItem* i, const QPoint& p)
{
  if (i)
	mScriptMenu->exec (p, 1);
}
