/* -*- C++ -*-

  $Id: Tool.h,v 1.5 1999/04/13 07:30:55 sattler Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by  
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef Tool_h_
#define Tool_h_

#include <qobject.h>
#include <qevent.h>
#include <qkeycode.h>

#include "GObject.h"
#include "version.h"

#if QT_VERSION >= 199
#define QT_ESCAPE Qt::Key_Escape
#else
#define QT_ESCAPE Key_Escape
#endif

class GDocument;
class Canvas;
class CommandHistory;

class Tool : public QObject {
  Q_OBJECT
protected:
  Tool (CommandHistory* chist);
  
public:
  ~Tool () {}
  virtual void processEvent (QEvent* e, GDocument* doc, Canvas* canvas) = 0;
  virtual void activate (GDocument* doc, Canvas* canvas);
  virtual void deactivate (GDocument*, Canvas*) {}

  virtual void configure () {}

  virtual bool consumesRMBEvents () { return true; }

signals:
  void modeSelected (const char* msg);
  void operationDone ();

protected:
  CommandHistory* history;
  char msgbuf[200];
};

#endif
