/* -*- C++ -*-

  $Id: ColorField.h,v 1.3 1999/11/29 02:32:58 mueller Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by  
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef ColorField_h_
#define ColorField_h_

#include <qwidget.h>
#include <qpushbutton.h>
#include <qvector.h>
#include <qbrush.h>

class ColorField : public QButton {
  Q_OBJECT
public:
  ColorField (int idx, const QBrush& b, 
	      QWidget *parent = 0, const char* name = 0);

  void setBrush (const QBrush& b);

public slots:
  void highlight (bool flag);

protected:
  void drawButton (QPainter* p);
  void mouseReleaseEvent (QMouseEvent* e);
    
signals:
  void colorSelected (int flag, int idx, const QBrush& b);

private:
  QBrush brush;
  bool highlighted;
  int id;
};

#endif
