#include <stdio.h>

#include <qapplication.h>
#include <qpushbutton.h>
#include <kapp.h>
#include <qimage.h>
#include <klocale.h>
#include <kimageio.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>

#include "toplevel.h"



void dumpMap(int argc, char **argv)
{
  // guess some default parameters
  QSize   mapSize(kapp->desktop()->size());
  QString mapName("depths_400.jpg");
  QString outName("dump.ppm");
  
  // parse the arguments
  for (int i=2; i<argc; i++)
    {
      if (!strcmp(argv[i], "-size") && (i+1 < argc))
	{
	  int w,h;
	  if (sscanf(argv[i+1], "%dx%d", &w, &h) == 2)
	    {
	      mapSize = QSize(w,h);
	      i++;
	      continue;
	    }
	}
      
      if (!strcmp(argv[i], "-map") && (i+1 < argc))
	{
	  mapName = argv[i+1];
	  i++;
	  continue;
	}
	   
      if (!strcmp(argv[i], "-o") && (i+1 < argc))
	{
	  outName = argv[i+1];
	  i++;
	  continue;
	}	   
    }

  printf("map=%s, out=%s, size=(%d,%d)\n", mapName.ascii(), outName.ascii(), mapSize.width(), mapSize.height());

  // create a toplevel object
  World world;
  world.loadMap(mapName);
  world.loadFlags();

  world.dumpMap(outName, mapSize);
}

static const char* description=I18N_NOOP("KDE's Watch for the Planet!");
static const char* version="0.0.1";

int main( int argc, char **argv )
{
  KAboutData aboutData("kworldwatch", I18N_NOOP("KWorldWatch"),
    version, description, KAboutData::License_GPL,
    "(c) 1998-2000, Matthias Hölzer");
  aboutData.addAuthor("Matthias Hölzer",0, "hoelzer@physik.uni-wuerzburg.de");
  KCmdLineArgs::init( argc, argv, &aboutData );


  KApplication app;
  
  KImageIO::registerFormats();

  // dump mode, used for background drawing
  if ((argc >= 2) && !strcmp(argv[1], "-dump"))
    {
      dumpMap(argc, argv);
      exit(0);
    }

  TopLevel *toplevel;

  if (kapp->isRestored())
    RESTORE(TopLevel)
  else
    {    
      toplevel = new TopLevel();
      toplevel->setCaption(i18n("KDE World Wide Watch"));

      app.setMainWidget(toplevel);
    }
	
  return app.exec();
}
