/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SITE_H_
#define _SITE_H_


#include <qdict.h>

#include <ksimpleconfig.h>


class InputTag {
  
public:
  QString name;
  QString value;
  bool user;

};


/* Needed because KSimpleConfig doesn't allow strings with whitespace */
class SiteConfig : public KSimpleConfig {

public:
  SiteConfig(const char *filename) : KSimpleConfig(filename, true) {}
  QString readEntry(const char *key);

};


class Site {

public:
  Site() { inputs.setAutoDelete(true); }

  QString makeQueryUrl(QString query);

  QString description;
  QString action;
  QString icon;
  QList<InputTag> inputs;
  QString resultListStart;
  QString resultItemStart;
  QString resultListEnd;
  QString resultItemEnd;

};


class SiteManager {

public:
  SiteManager() {}
  virtual ~SiteManager() {}

  void readSites(QString dirname);
  Site *find(QString name);

  QDict<Site> &siteDict() { return map; }

protected:
  /* to be defined by subclasses to allocate a new Site */
  virtual Site *newSite();
  
  /* to be defined by suclasses to read in their specific
     interpretation entries from a SiteConfig.
  */
  virtual void readInterpret(Site *site, SiteConfig *config);
  
private:
  QDict<Site> map;

};

    
#endif
