/*
* kfbrowsebtn.cpp -- Implementation of class KBrowseButton.
* Author:	Sirtaj Singh Kang
* Version:	$Id: kfbrowsebtn.cpp,v 1.4 2000/02/16 11:53:33 pfeiffer Exp $
* Generated:	Tue Aug  4 03:44:44 EST 1998
*/

#include"kfbrowsebtn.h"

#include<assert.h>
#include<kglobal.h>
#include<klocale.h>
#include<qstring.h>
#include<kfiledialog.h>

KBrowseButton::KBrowseButton( const char *caption, 
	const char * path, QWidget *parent, const char *name, 
	bool modal )
	: QPushButton( caption ? QString(caption) : i18n( "Browse..." ), 
			parent, name ),
	_dialog( 0 ),
	_path( new QString(path) ),
	_modal ( modal )
{
	connect( this, SIGNAL(clicked()), this, SLOT(showDialog()) );
}

KBrowseButton::~KBrowseButton()
{
	delete _dialog;
	delete _path;
}

const char *KBrowseButton::path() const
{
	return _path->data();
}

void KBrowseButton::setPath( const char *url )
{
	*_path = url;

	if( _dialog ) {
		// change dialog path
		_dialog->setSelection( url );
	}

	debug( "path set to: %s", _path->data() );
}

void KBrowseButton::showDialog()
{
	// create dialog if needed

	if ( !_dialog ) {
		_dialog = newBrowserDialog( _modal );
		assert( _dialog != 0 );
		connect( _dialog, SIGNAL(fileSelected(const char *)),
			this, SLOT(setPathAndRaise(const char *)) );
	}
	
	_dialog->show();
}

void KBrowseButton::setPathAndRaise( const char *url )
{
	*_path = url;

	emit pathChanged( url );
}

KFileDialog *KFileBrowseButton::newBrowserDialog( bool modal )
{
	return new KFileDialog( path() ? path() : "", 0, 0, 0, modal );
}

KFileDialog *KDirBrowseButton::newBrowserDialog( bool modal )
{
  KFileDialog* fileDialog = new KFileDialog( path() ? path() : "", 0, 0, 0, modal );
  fileDialog->setMode( KFile::Directory );
  return fileDialog;
}
