/*
* mcfgdlg.cpp -- Implementation of class KDropCfgDialog.
* Author:	Sirtaj Singh Kang
* Version:	$Id: dropdlg.cpp,v 1.1 1999/07/22 18:16:50 tibirna Exp $
* Generated:	Wed Jul 29 04:02:28 EST 1998
*/

#include"dropdlg.h"

#include"moncfg.h"

#include<kglobal.h>
#include<klocale.h>
#include<qevent.h>
#include<assert.h>

KDropCfgDialog::KDropCfgDialog( const char *caption, 
		QWidget *parent, const char *name, 
		bool modal, WFlags f )
	: QTabDialog( parent, name, modal, f )
{
	// caption
	QString s = i18n( "Korn Monitor") ;

	s += ": ";
	s += caption;

	setCaption( s );

	// buttons
	
	setApplyButton( i18n("Apply" ) );
	setCancelButton( i18n("Cancel" ) );
	setOkButton( i18n("OK" ) );

	connect( this, SIGNAL(applyButtonPressed()), this, SLOT(apply()) );

	// notifier list
	_notifiers.setAutoDelete( true );
}

KDropCfgDialog::~KDropCfgDialog()
{
}

void KDropCfgDialog::addConfigPage( KMonitorCfg *page )
{
	assert( page );

	QWidget *tab = page->makeWidget( this );

	assert( tab != 0 );
	assert( page->name() );

	addTab( tab, page->name() );

	_notifiers.append( page );
}

void KDropCfgDialog::apply()
{
	QListIterator<KMonitorCfg> iter( _notifiers );

	for( ; iter.current(); ++iter ) {
		iter.current()->updateConfig();
	}
}

void KDropCfgDialog::done( int r )
{
	setResult( r );

	emit disassociate( this );

	delete this;
}
