/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qbrush.h>
#include <qpainter.h>

#include <kapp.h>
#include <klocale.h>

#include "resultview.h"


ResultViewItem::ResultViewItem( QListView *parent, QString host, QString path,
				QString size, QString date)
  : QListViewItem(parent, host, path, size, date) {
}


ResultView::ResultView(QWidget *parent, const char *name)
  : QListView(parent, name) {

  addColumn( i18n("Date") );
  addColumn( i18n("Size") );
  addColumn( i18n("Server"), 100 );
  addColumn( i18n("Path"), 200 );
  
  connect( this, SIGNAL(doubleClicked(QListViewItem*)),
	   SLOT(itemActivated(QListViewItem*)) );
}

void ResultView::insertItem(QString host, QString path, QString size, QString date) {
  (void) new ResultViewItem(this, date, size, host, path);
}


void ResultView::itemActivated(QListViewItem *item) {
  emit urlActivated(static_cast<ResultViewItem*>(item)->m_url);
}
