/* $Id: preferences.cpp,v 1.19 2000/04/20 19:11:14 koss Exp $
   $Log: preferences.cpp,v $
   Revision 1.19  2000/04/20 19:11:14  koss
   Some renaming for consistence :
      ConfigDlg to DlgTransferConfig.
      PreferencesDlg to DlgPreferences.
   Added dlgProgress as a new individual progress dialog.
   Fixed application quitting.
   Fixed action update after job cancelation.

   Revision 1.18  2000/04/17 15:32:10  baumgart
   --enable-final fixes

   Revision 1.17  2000/04/10 11:55:12  koss
   Fixed toggle of windows

   Revision 1.16  2000/03/19 17:54:47  koss
   added qlayout include

   Revision 1.15  1999/11/21 16:46:00  koss
   Readded disableResize(). Should work finally.

   Revision 1.14  1999/11/19 19:01:12  koss
   Dialog now has a parent.
   Removed marginHint().

   Revision 1.13  1999/11/18 21:28:05  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.12  1999/11/16 18:22:08  koss
   Apply settings now works.

   Revision 1.11  1999/11/15 20:19:06  koss
   Added dlgSearch stuff.

   Revision 1.10  1999/11/14 09:05:09  koss
   Fixed layout again.

   Revision 1.9  1999/11/12 13:53:02  feigl
   make it compile with new KDialogBase

   Revision 1.8  1999/11/09 18:25:44  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.7  1999/10/18 21:49:54  koss
   switched from QStrList to QStringList.
   fixed layout.
   removed getIntFromString() and getStringFromInt().
   getBoolFromString() renamed to stringToBool().
   getStringFromBool() renamed to boolToString().

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:14:40  matt
   updated for new setting dialogs


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>
#include <klocale.h>
#include <kaction.h>

#include "dlgConnection.h"
#include "dlgAutomation.h"
#include "dlgLimits.h"
#include "dlgAdvanced.h"
#include "dlgSearch.h"
#include "dlgDirectories.h"
#include "dlgSystem.h"

#ifdef index
#undef index
#endif

#include "kmainwidget.h"
#include "preferences.h"


DlgPreferences::DlgPreferences( QWidget *parent )
  : KDialogBase( Tabbed, i18n("Preferences"),
		 Ok|Apply|Help|Cancel, Ok, parent, "", false ) {
  // add pages
  QFrame *page = addPage( i18n("Connection") );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  conDlg = new DlgConnection( page );
  topLayout->addWidget( conDlg );  

  page = addPage( i18n("Automation") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  autDlg = new DlgAutomation( page );
  topLayout->addWidget( autDlg );  

  page = addPage( i18n("Limits") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  limDlg = new DlgLimits( page );
  topLayout->addWidget( limDlg );  

  page = addPage( i18n("Advanced") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  advDlg = new DlgAdvanced( page );
  topLayout->addWidget( advDlg );  

  page = addPage( i18n("Search") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  seaDlg = new DlgSearch( page );
  topLayout->addWidget( seaDlg );  

  page = addPage( i18n("Directories") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  dirDlg = new DlgDirectories( page );
  topLayout->addWidget( dirDlg );  

  page = addPage( i18n("System") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  sysDlg = new DlgSystem( page );
  topLayout->addWidget( sysDlg );  

  // type of connection influences autoDisconnect & timedDisconnect features
  connect( conDlg, SIGNAL( typeChanged( int ) ),
	   autDlg, SLOT( slotTypeChanged( int ) ) );
  connect( this, SIGNAL( applyClicked() ),
	   SLOT( applySettings() ) );

  conDlg->setData();
  autDlg->setData();
  limDlg->setData();
  advDlg->setData();
  seaDlg->setData();
  dirDlg->setData();
  sysDlg->setData();

  disableResize();
  show();
}


void DlgPreferences::closeEvent( QCloseEvent* ) {
  kmain->m_paPreferences->setChecked( false );
}


void DlgPreferences::done( int r ) {
  if ( r != Rejected ) {
    applySettings();
  }

  hide();
  kmain->m_paPreferences->setChecked( false );
}


void DlgPreferences::applySettings() {
  conDlg->applyData();
  autDlg->applyData();
  limDlg->applyData();
  advDlg->applyData();
  seaDlg->applyData();
  dirDlg->applyData();
  sysDlg->applyData();
}
