/* $Id: logwindow.cpp,v 1.17 2000/04/11 17:28:33 koss Exp $
   $Log: logwindow.cpp,v $
   Revision 1.17  2000/04/11 17:28:33  koss
   reenabled append.
   you'll need a patch for Qt though.

   Revision 1.16  2000/04/10 11:55:12  koss
   Fixed toggle of windows

   Revision 1.15  2000/04/08 16:26:26  koss
   ported to QTextView::append()
   unfortunately it doesn't work.
   need to check this with Mattias

   Revision 1.14  1999/11/22 18:53:36  koss
   Added typedef for TransferMap.

   Revision 1.13  1999/11/19 18:56:09  koss
   Remove marginHint().
   Fixed caption.

   Revision 1.12  1999/11/18 21:35:17  koss
   Commented out replaceSpaces(), it doesn't work anyway.

   Revision 1.11  1999/11/17 18:36:38  koss
   Added call to removeHTML() - now logs won't contain html tags anymore.

   Revision 1.8  1999/11/09 18:32:42  koss
   Little more work on output to QTextView. Still not fixed :-)

   Revision 1.7  1999/10/31 10:24:41  koss
   Added timestamp.
   Switched from QMultiLineEdit to QTextView.
   Now we display richtext logs with different colors for general
   messages, transfer messages & timestamp.

   Revision 1.5  1999/10/19 17:43:23  koss
   New separated log dialog.
   Philosophy : page one = all output mixed
   	     page two = separated output with QListView
   Added simplifyWhiteSpace() to create a better logs.

   Revision 1.4  1999/10/18 22:08:48  koss
   New logging - discerning general and per-transfer messages.
   Pending - finish second tab = per transfer logs
           - port to QTextView and assign colors to items

   Revision 1.1  1999/05/16 17:00:34  koss
   Log window for all messages


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <klocale.h>
#include <kdialog.h>
#include <kaction.h>

#include "transfer.h"
#include "kmainwidget.h"
#include "logwindow.h"


// // Replace regular space with nbsp
// QString replaceSpaces(const QString &str) {
//   QString res = str;
//   res.simplifyWhiteSpace();

//   int pos;
//   while ( (pos = res.find(' ')) != -1) {
//     res.replace(pos, 1, new QChar( 0x00a0 ), 1);
//   }

//   return res;
// }


QString removeHTML(const QString &str) {
  QString res = str;
  int pos;

  // replace <br/> with a newline
  while ( (pos = res.find("<br/>")) != -1) {
    res.replace(pos, 4, "\n");
  }

  // remove all tags
  while ( (pos = res.find('<')) != -1) {
    int pos2 = res.find('>', pos);
    if (pos2 == -1) {
      pos2 = res.length()+1;
    }
    res.remove(pos, pos2-pos+1);
  }

  return res;
}


SeparatedLog::SeparatedLog( QWidget *parent )
  : QWidget( parent ) {

  idSelected = 0;

  QGridLayout *topGridLayout = new QGridLayout(this, 1, 2, 20, KDialog::spacingHint());

  topGridLayout->setRowStretch(0,5);
    
  topGridLayout->setColStretch(0,3);
  topGridLayout->setColStretch(1,10);

  lv_log = new QListView( this );
  lv_log->setMultiSelection( false );
  lv_log->setAllColumnsShowFocus( true );

  lv_log->addColumn( i18n( "Id" ), 40 );
  lv_log->addColumn( i18n( "Name" ), 100 );

  topGridLayout->addWidget( lv_log, 0, 0 );

  connect( lv_log, SIGNAL( selectionChanged( QListViewItem* ) ),
	   SLOT( transferSelected( QListViewItem* ) ) );

  ml_log = new QTextView( this );
  ml_log->setTextFormat( RichText );
  ml_log->setMinimumSize( 300, 200 );

  topGridLayout->addWidget( ml_log, 0, 1 );
}


void SeparatedLog::addLog( uint id, const QString &filename, const QString& message ) {
  if ( ! trMap.contains( id ) ) {
    trMap.insert( id, message );
    QString tmps;
    new QListViewItem( lv_log, tmps.setNum( id ), filename );
  } else {
    trMap[id] += message;
  }

  if ( idSelected == id ) {
    ml_log->append( message );
  }
}


void SeparatedLog::transferSelected( QListViewItem *item ) {
  if ( item ) {
    idSelected = item->text( 0 ).toUInt();
    ml_log->setText( trMap[ idSelected ] );
  }
}


void SeparatedLog::refresh() {
  if ( idSelected > 0 ) {
    ml_log->setText( trMap[ idSelected ] );
  }
}


////////////////////////

LogWindow::LogWindow()
  : KDialogBase( Tabbed, i18n("Log Window"), Close, Close, 0, "", false ) {

  // add pages
  QFrame *page = addPage( i18n("Mixed") );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  mixed_log = new QTextView( page );
  mixed_log->setTextFormat( RichText );
  topLayout->addWidget( mixed_log );  

  page = addPage( i18n("Separated") );
  topLayout = new QVBoxLayout( page, 0, spacingHint() );
  sep_log = new SeparatedLog( page );
  topLayout->addWidget( sep_log );  

  setButtonOKText( i18n("Close") );

  connect(this, SIGNAL( closeClicked() ),
	  this, SLOT( close() ) );

//   resize( 500, 300 );
}


void LogWindow::closeEvent( QCloseEvent* ) {
  kmain->m_paShowLog->setChecked( false );
}


void LogWindow::logGeneral( const QString &message ) {
  QString tmps;

  tmps = "<code><font color=\"blue\">" + QTime::currentTime().toString() +
    "</font> : <strong>" + message + "</strong></code><br/>";

  mixed_log->append(tmps);
}


void LogWindow::logTransfer( uint id, const QString &filename, const QString &message ) {
  QString tmp1, tmp2;

  tmp1 = "<code><font color=\"blue\">" + QTime::currentTime().toString() +
    "</font> : " + message + "</code><br/>";
  tmp2.sprintf( "<strong>%d</strong> : ", id );

  mixed_log->append( tmp2 + tmp1);
  sep_log->addLog( id, filename, tmp1 );
}


QString LogWindow::getText() const {
  return removeHTML( mixed_log->text() );
}
