/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef CORE_H
#define CORE_H

#include "common.h"

enum HeaderMagic {MCOP_MAGIC = 1347371853};
enum MessageType {mcopInvocation = 1, mcopReturn = 2, mcopServerHello = 3, mcopClientHello = 4, mcopAuthAccept = 5, mcopOnewayInvocation = 6};
enum MethodType {methodOneway = 1, methodTwoway = 2};
enum AttributeType {streamIn = 1, streamOut = 2, streamMulti = 4, attributeStream = 8, attributeAttribute = 16, streamAsync = 32, streamDefault = 64};
class Header : public Type {
public:
	Header();
	Header(HeaderMagic magic, long messageLength, MessageType messageType);
	Header(Buffer& stream);
	Header(const Header& copyType);
	Header& operator=(const Header& assignType);
	virtual ~Header();

	HeaderMagic magic;
	long messageLength;
	MessageType messageType;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class Invocation : public Type {
public:
	Invocation();
	Invocation(long requestID, long objectID, long methodID);
	Invocation(Buffer& stream);
	Invocation(const Invocation& copyType);
	Invocation& operator=(const Invocation& assignType);
	virtual ~Invocation();

	long requestID;
	long objectID;
	long methodID;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class OnewayInvocation : public Type {
public:
	OnewayInvocation();
	OnewayInvocation(long objectID, long methodID);
	OnewayInvocation(Buffer& stream);
	OnewayInvocation(const OnewayInvocation& copyType);
	OnewayInvocation& operator=(const OnewayInvocation& assignType);
	virtual ~OnewayInvocation();

	long objectID;
	long methodID;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ServerHello : public Type {
public:
	ServerHello();
	ServerHello(const std::string& serverID, const std::vector<std::string>& authProtocols, const std::string& authSeed);
	ServerHello(Buffer& stream);
	ServerHello(const ServerHello& copyType);
	ServerHello& operator=(const ServerHello& assignType);
	virtual ~ServerHello();

	std::string serverID;
	std::vector<std::string> authProtocols;
	std::string authSeed;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ClientHello : public Type {
public:
	ClientHello();
	ClientHello(const std::string& serverID, const std::string& authProtocol, const std::string& authData);
	ClientHello(Buffer& stream);
	ClientHello(const ClientHello& copyType);
	ClientHello& operator=(const ClientHello& assignType);
	virtual ~ClientHello();

	std::string serverID;
	std::string authProtocol;
	std::string authData;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ObjectReference : public Type {
public:
	ObjectReference();
	ObjectReference(const std::string& serverID, long objectID, const std::vector<std::string>& urls);
	ObjectReference(Buffer& stream);
	ObjectReference(const ObjectReference& copyType);
	ObjectReference& operator=(const ObjectReference& assignType);
	virtual ~ObjectReference();

	std::string serverID;
	long objectID;
	std::vector<std::string> urls;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ParamDef : public Type {
public:
	ParamDef();
	ParamDef(const std::string& type, const std::string& name);
	ParamDef(Buffer& stream);
	ParamDef(const ParamDef& copyType);
	ParamDef& operator=(const ParamDef& assignType);
	virtual ~ParamDef();

	std::string type;
	std::string name;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class MethodDef : public Type {
public:
	MethodDef();
	MethodDef(const std::string& name, const std::string& type, MethodType flags, const std::vector<ParamDef *>& signature);
	MethodDef(Buffer& stream);
	MethodDef(const MethodDef& copyType);
	MethodDef& operator=(const MethodDef& assignType);
	virtual ~MethodDef();

	std::string name;
	std::string type;
	MethodType flags;
	std::vector<ParamDef *> signature;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class AttributeDef : public Type {
public:
	AttributeDef();
	AttributeDef(const std::string& name, const std::string& type, AttributeType flags);
	AttributeDef(Buffer& stream);
	AttributeDef(const AttributeDef& copyType);
	AttributeDef& operator=(const AttributeDef& assignType);
	virtual ~AttributeDef();

	std::string name;
	std::string type;
	AttributeType flags;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class InterfaceDef : public Type {
public:
	InterfaceDef();
	InterfaceDef(const std::string& name, const std::vector<std::string>& inheritedInterfaces, const std::vector<MethodDef *>& methods, const std::vector<AttributeDef *>& attributes, const std::vector<std::string>& defaultPorts);
	InterfaceDef(Buffer& stream);
	InterfaceDef(const InterfaceDef& copyType);
	InterfaceDef& operator=(const InterfaceDef& assignType);
	virtual ~InterfaceDef();

	std::string name;
	std::vector<std::string> inheritedInterfaces;
	std::vector<MethodDef *> methods;
	std::vector<AttributeDef *> attributes;
	std::vector<std::string> defaultPorts;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class TypeComponent : public Type {
public:
	TypeComponent();
	TypeComponent(const std::string& type, const std::string& name);
	TypeComponent(Buffer& stream);
	TypeComponent(const TypeComponent& copyType);
	TypeComponent& operator=(const TypeComponent& assignType);
	virtual ~TypeComponent();

	std::string type;
	std::string name;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class TypeDef : public Type {
public:
	TypeDef();
	TypeDef(const std::string& name, const std::vector<TypeComponent *>& contents);
	TypeDef(Buffer& stream);
	TypeDef(const TypeDef& copyType);
	TypeDef& operator=(const TypeDef& assignType);
	virtual ~TypeDef();

	std::string name;
	std::vector<TypeComponent *> contents;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class EnumComponent : public Type {
public:
	EnumComponent();
	EnumComponent(const std::string& name, long value);
	EnumComponent(Buffer& stream);
	EnumComponent(const EnumComponent& copyType);
	EnumComponent& operator=(const EnumComponent& assignType);
	virtual ~EnumComponent();

	std::string name;
	long value;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class EnumDef : public Type {
public:
	EnumDef();
	EnumDef(const std::string& name, const std::vector<EnumComponent *>& contents);
	EnumDef(Buffer& stream);
	EnumDef(const EnumDef& copyType);
	EnumDef& operator=(const EnumDef& assignType);
	virtual ~EnumDef();

	std::string name;
	std::vector<EnumComponent *> contents;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ModuleDef : public Type {
public:
	ModuleDef();
	ModuleDef(const std::string& moduleName, const std::vector<ModuleDef *>& modules, const std::vector<EnumDef *>& enums, const std::vector<TypeDef *>& types, const std::vector<InterfaceDef *>& interfaces);
	ModuleDef(Buffer& stream);
	ModuleDef(const ModuleDef& copyType);
	ModuleDef& operator=(const ModuleDef& assignType);
	virtual ~ModuleDef();

	std::string moduleName;
	std::vector<ModuleDef *> modules;
	std::vector<EnumDef *> enums;
	std::vector<TypeDef *> types;
	std::vector<InterfaceDef *> interfaces;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class InterfaceRepo;
class FlowSystemSender;
class FlowSystemReceiver;
class FlowSystem;
class GlobalComm;
class TmpGlobalComm;

class InterfaceRepo_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static InterfaceRepo_base *_create(const std::string& subClass = "InterfaceRepo");
	static InterfaceRepo_base *_fromString(std::string objectref);
	static InterfaceRepo_base *_fromReference(ObjectReference ref, bool needcopy);

	inline InterfaceRepo_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long insertModule(const ModuleDef& newModule) = 0;
	virtual void removeModule(long moduleID) = 0;
	virtual InterfaceDef* queryInterface(const std::string& name) = 0;
	virtual TypeDef* queryType(const std::string& name) = 0;
};

class InterfaceRepo_stub : virtual public InterfaceRepo_base, virtual public Object_stub {
protected:
	InterfaceRepo_stub();

public:
	InterfaceRepo_stub(Connection *connection, long objectID);

	long insertModule(const ModuleDef& newModule);
	void removeModule(long moduleID);
	InterfaceDef* queryInterface(const std::string& name);
	TypeDef* queryType(const std::string& name);
};

class InterfaceRepo_skel : virtual public InterfaceRepo_base, virtual public Object_skel {
public:
	InterfaceRepo_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class InterfaceRepo : public SmartWrapper {
private:
	static Object_base* _Creator();
	InterfaceRepo_base *_cache;
	inline InterfaceRepo_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InterfaceRepo_base *)_pool->base->_cast(InterfaceRepo_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline InterfaceRepo() : SmartWrapper(_Creator), _cache(0) {}
	inline InterfaceRepo(const SubClass& s) :
		SmartWrapper(InterfaceRepo_base::_create(s.string())), _cache(0) {}
	inline InterfaceRepo(const Reference &r) :
		SmartWrapper(r.isString()?(InterfaceRepo_base::_fromString(r.string())):(InterfaceRepo_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InterfaceRepo(InterfaceRepo_base* b) : SmartWrapper(b), _cache(0) {}
	inline InterfaceRepo(const InterfaceRepo& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline InterfaceRepo(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline InterfaceRepo& operator=(const InterfaceRepo& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline InterfaceRepo_base* _base() {return _cache?_cache:_method_call();}

	inline long insertModule(const ModuleDef& newModule) {return _cache?_cache->insertModule(newModule):_method_call()->insertModule(newModule);}
	inline void removeModule(long moduleID) {return _cache?_cache->removeModule(moduleID):_method_call()->removeModule(moduleID);}
	inline InterfaceDef* queryInterface(const std::string& name) {return _cache?_cache->queryInterface(name):_method_call()->queryInterface(name);}
	inline TypeDef* queryType(const std::string& name) {return _cache?_cache->queryType(name):_method_call()->queryType(name);}
};

class FlowSystemSender_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystemSender_base *_create(const std::string& subClass = "FlowSystemSender");
	static FlowSystemSender_base *_fromString(std::string objectref);
	static FlowSystemSender_base *_fromReference(ObjectReference ref, bool needcopy);

	inline FlowSystemSender_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void processed() = 0;
};

class FlowSystemSender_stub : virtual public FlowSystemSender_base, virtual public Object_stub {
protected:
	FlowSystemSender_stub();

public:
	FlowSystemSender_stub(Connection *connection, long objectID);

	void processed();
};

class FlowSystemSender_skel : virtual public FlowSystemSender_base, virtual public Object_skel {
public:
	FlowSystemSender_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class FlowSystemSender : public SmartWrapper {
private:
	static Object_base* _Creator();
	FlowSystemSender_base *_cache;
	inline FlowSystemSender_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystemSender_base *)_pool->base->_cast(FlowSystemSender_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline FlowSystemSender() : SmartWrapper(_Creator), _cache(0) {}
	inline FlowSystemSender(const SubClass& s) :
		SmartWrapper(FlowSystemSender_base::_create(s.string())), _cache(0) {}
	inline FlowSystemSender(const Reference &r) :
		SmartWrapper(r.isString()?(FlowSystemSender_base::_fromString(r.string())):(FlowSystemSender_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystemSender(FlowSystemSender_base* b) : SmartWrapper(b), _cache(0) {}
	inline FlowSystemSender(const FlowSystemSender& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline FlowSystemSender(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline FlowSystemSender& operator=(const FlowSystemSender& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline FlowSystemSender_base* _base() {return _cache?_cache:_method_call();}

	inline void processed() {return _cache?_cache->processed():_method_call()->processed();}
};

class FlowSystemReceiver_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystemReceiver_base *_create(const std::string& subClass = "FlowSystemReceiver");
	static FlowSystemReceiver_base *_fromString(std::string objectref);
	static FlowSystemReceiver_base *_fromReference(ObjectReference ref, bool needcopy);

	inline FlowSystemReceiver_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long receiveHandlerID() = 0;
};

class FlowSystemReceiver_stub : virtual public FlowSystemReceiver_base, virtual public Object_stub {
protected:
	FlowSystemReceiver_stub();

public:
	FlowSystemReceiver_stub(Connection *connection, long objectID);

	long receiveHandlerID();
};

class FlowSystemReceiver_skel : virtual public FlowSystemReceiver_base, virtual public Object_skel {
public:
	FlowSystemReceiver_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class FlowSystemReceiver : public SmartWrapper {
private:
	static Object_base* _Creator();
	FlowSystemReceiver_base *_cache;
	inline FlowSystemReceiver_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystemReceiver_base *)_pool->base->_cast(FlowSystemReceiver_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline FlowSystemReceiver() : SmartWrapper(_Creator), _cache(0) {}
	inline FlowSystemReceiver(const SubClass& s) :
		SmartWrapper(FlowSystemReceiver_base::_create(s.string())), _cache(0) {}
	inline FlowSystemReceiver(const Reference &r) :
		SmartWrapper(r.isString()?(FlowSystemReceiver_base::_fromString(r.string())):(FlowSystemReceiver_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystemReceiver(FlowSystemReceiver_base* b) : SmartWrapper(b), _cache(0) {}
	inline FlowSystemReceiver(const FlowSystemReceiver& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline FlowSystemReceiver(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline FlowSystemReceiver& operator=(const FlowSystemReceiver& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline FlowSystemReceiver_base* _base() {return _cache?_cache:_method_call();}

	inline long receiveHandlerID() {return _cache?_cache->receiveHandlerID():_method_call()->receiveHandlerID();}
};

class FlowSystem_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystem_base *_create(const std::string& subClass = "FlowSystem");
	static FlowSystem_base *_fromString(std::string objectref);
	static FlowSystem_base *_fromReference(ObjectReference ref, bool needcopy);

	inline FlowSystem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void startObject(Object node) = 0;
	virtual void stopObject(Object node) = 0;
	virtual void connectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort) = 0;
	virtual void disconnectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort) = 0;
	virtual AttributeType queryFlags(Object node, const std::string& port) = 0;
	virtual FlowSystemReceiver createReceiver(Object destObject, const std::string& destPort, FlowSystemSender sender) = 0;
};

class FlowSystem_stub : virtual public FlowSystem_base, virtual public Object_stub {
protected:
	FlowSystem_stub();

public:
	FlowSystem_stub(Connection *connection, long objectID);

	void startObject(Object node);
	void stopObject(Object node);
	void connectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort);
	void disconnectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort);
	AttributeType queryFlags(Object node, const std::string& port);
	FlowSystemReceiver createReceiver(Object destObject, const std::string& destPort, FlowSystemSender sender);
};

class FlowSystem_skel : virtual public FlowSystem_base, virtual public Object_skel {
public:
	FlowSystem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class FlowSystem : public SmartWrapper {
private:
	static Object_base* _Creator();
	FlowSystem_base *_cache;
	inline FlowSystem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystem_base *)_pool->base->_cast(FlowSystem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline FlowSystem() : SmartWrapper(_Creator), _cache(0) {}
	inline FlowSystem(const SubClass& s) :
		SmartWrapper(FlowSystem_base::_create(s.string())), _cache(0) {}
	inline FlowSystem(const Reference &r) :
		SmartWrapper(r.isString()?(FlowSystem_base::_fromString(r.string())):(FlowSystem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystem(FlowSystem_base* b) : SmartWrapper(b), _cache(0) {}
	inline FlowSystem(const FlowSystem& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline FlowSystem(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline FlowSystem& operator=(const FlowSystem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline FlowSystem_base* _base() {return _cache?_cache:_method_call();}

	inline void startObject(Object node) {return _cache?_cache->startObject(node):_method_call()->startObject(node);}
	inline void stopObject(Object node) {return _cache?_cache->stopObject(node):_method_call()->stopObject(node);}
	inline void connectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort) {return _cache?_cache->connectObject(sourceObject, sourcePort, destObject, destPort):_method_call()->connectObject(sourceObject, sourcePort, destObject, destPort);}
	inline void disconnectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort) {return _cache?_cache->disconnectObject(sourceObject, sourcePort, destObject, destPort):_method_call()->disconnectObject(sourceObject, sourcePort, destObject, destPort);}
	inline AttributeType queryFlags(Object node, const std::string& port) {return _cache?_cache->queryFlags(node, port):_method_call()->queryFlags(node, port);}
	inline FlowSystemReceiver createReceiver(Object destObject, const std::string& destPort, FlowSystemSender sender) {return _cache?_cache->createReceiver(destObject, destPort, sender):_method_call()->createReceiver(destObject, destPort, sender);}
};

class GlobalComm_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static GlobalComm_base *_create(const std::string& subClass = "GlobalComm");
	static GlobalComm_base *_fromString(std::string objectref);
	static GlobalComm_base *_fromReference(ObjectReference ref, bool needcopy);

	inline GlobalComm_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool put(const std::string& variable, const std::string& value) = 0;
	virtual std::string get(const std::string& variable) = 0;
	virtual void erase(const std::string& variable) = 0;
};

class GlobalComm_stub : virtual public GlobalComm_base, virtual public Object_stub {
protected:
	GlobalComm_stub();

public:
	GlobalComm_stub(Connection *connection, long objectID);

	bool put(const std::string& variable, const std::string& value);
	std::string get(const std::string& variable);
	void erase(const std::string& variable);
};

class GlobalComm_skel : virtual public GlobalComm_base, virtual public Object_skel {
public:
	GlobalComm_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class GlobalComm : public SmartWrapper {
private:
	static Object_base* _Creator();
	GlobalComm_base *_cache;
	inline GlobalComm_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(GlobalComm_base *)_pool->base->_cast(GlobalComm_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline GlobalComm() : SmartWrapper(_Creator), _cache(0) {}
	inline GlobalComm(const SubClass& s) :
		SmartWrapper(GlobalComm_base::_create(s.string())), _cache(0) {}
	inline GlobalComm(const Reference &r) :
		SmartWrapper(r.isString()?(GlobalComm_base::_fromString(r.string())):(GlobalComm_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline GlobalComm(GlobalComm_base* b) : SmartWrapper(b), _cache(0) {}
	inline GlobalComm(const GlobalComm& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline GlobalComm(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline GlobalComm& operator=(const GlobalComm& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline GlobalComm_base* _base() {return _cache?_cache:_method_call();}

	inline bool put(const std::string& variable, const std::string& value) {return _cache?_cache->put(variable, value):_method_call()->put(variable, value);}
	inline std::string get(const std::string& variable) {return _cache?_cache->get(variable):_method_call()->get(variable);}
	inline void erase(const std::string& variable) {return _cache?_cache->erase(variable):_method_call()->erase(variable);}
};

class TmpGlobalComm_base : virtual public GlobalComm_base {
public:
	static unsigned long _IID; // interface ID

	static TmpGlobalComm_base *_create(const std::string& subClass = "TmpGlobalComm");
	static TmpGlobalComm_base *_fromString(std::string objectref);
	static TmpGlobalComm_base *_fromReference(ObjectReference ref, bool needcopy);

	inline TmpGlobalComm_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class TmpGlobalComm_stub : virtual public TmpGlobalComm_base, virtual public GlobalComm_stub {
protected:
	TmpGlobalComm_stub();

public:
	TmpGlobalComm_stub(Connection *connection, long objectID);

};

class TmpGlobalComm_skel : virtual public TmpGlobalComm_base, virtual public GlobalComm_skel {
public:
	TmpGlobalComm_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class TmpGlobalComm : public SmartWrapper {
private:
	static Object_base* _Creator();
	TmpGlobalComm_base *_cache;
	inline TmpGlobalComm_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(TmpGlobalComm_base *)_pool->base->_cast(TmpGlobalComm_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline TmpGlobalComm() : SmartWrapper(_Creator), _cache(0) {}
	inline TmpGlobalComm(const SubClass& s) :
		SmartWrapper(TmpGlobalComm_base::_create(s.string())), _cache(0) {}
	inline TmpGlobalComm(const Reference &r) :
		SmartWrapper(r.isString()?(TmpGlobalComm_base::_fromString(r.string())):(TmpGlobalComm_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline TmpGlobalComm(TmpGlobalComm_base* b) : SmartWrapper(b), _cache(0) {}
	inline TmpGlobalComm(const TmpGlobalComm& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline TmpGlobalComm(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline TmpGlobalComm& operator=(const TmpGlobalComm& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator GlobalComm() const { return GlobalComm(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline TmpGlobalComm_base* _base() {return _cache?_cache:_method_call();}

	inline bool put(const std::string& variable, const std::string& value) {return _cache?_cache->put(variable, value):_method_call()->put(variable, value);}
	inline std::string get(const std::string& variable) {return _cache?_cache->get(variable):_method_call()->get(variable);}
	inline void erase(const std::string& variable) {return _cache?_cache->erase(variable):_method_call()->erase(variable);}
};

#endif /* CORE_H */
