#include "main.h"
#include "main.moc"

#include <kglobal.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kaboutdata.h>
#include <kmenubar.h>

#include "inter.h"
#include "version.h"
#include "gpiece.h"
#include "dialogs.h"

MainWidget::MainWidget()
{
	installEventFilter(this);
	KAccel *kacc = new KAccel(this);

	pieceInfo = createPieceInfo();
	inter = new Interface(kacc, this);
	inter->installEventFilter(this);
	inter->singleHuman();

	// File & Popup
	KStdAction::openNew(inter, SLOT(start()), actionCollection(), "game_new");
	(void)new KAction(i18n("Pause"), Key_P, inter, SLOT(pause()),
					  actionCollection(), "game_pause");
	(void)new KAction(i18n("High Scores..."), Key_H,
					  this, SLOT(showHighScores()),
					  actionCollection(), "game_highscores");
	KAction *action = KStdAction::print(this, SLOT(print()),
										actionCollection(), "game_print");
	action->setEnabled(FALSE);
	KStdAction::quit(qApp, SLOT(quit()), actionCollection(), "game_quit");

	// Multiplayers
	(void)new KAction(i18n("Single Human"), 0, inter, SLOT(singleHuman()),
					  actionCollection(), "mp_single_human");
	(void)new KAction(i18n("Human vs Human"), 0, inter, SLOT(humanVsHuman()),
					  actionCollection(), "mp_human_vs_human");
	(void)new KAction(i18n("Human vs &Computer"), 0,
					  inter, SLOT(humanVsComputer()),
					  actionCollection(), "mp_human_vs_computer");
	(void)new KAction(i18n("More..."), 0, inter, SLOT(dialog()),
					  actionCollection(), "mp_more");

	// Settings
	KStdAction::showMenubar(this, SLOT(toggleMenubar()), actionCollection());
	KStdAction::preferences(inter, SLOT(preferences()), actionCollection());
	KStdAction::keyBindings(inter, SLOT(configureKeys()), actionCollection());
	(void)new KAction(i18n("Configure AI..."), 0, inter, SLOT(configureAI()),
					  actionCollection(), "options_configure_ai");

	createGUI();
	readSettings();
	setView(inter);
	updateRects(); // #### should be in KTMainWindow::setView
}

MainWidget::~MainWidget()
{
	delete pieceInfo;
}

bool MainWidget::eventFilter(QObject *, QEvent *e)
{
	QPopupMenu *popup;
	switch (e->type()) {
	 case QEvent::MouseButtonPress:
		if ( ((QMouseEvent *)e)->button()!=RightButton ) return FALSE;
		popup = (QPopupMenu*)factory()->container("popup", this);
		popup->popup(QCursor::pos());
		return TRUE;
	 default : return FALSE;
	}
}

#define MENUBAR_ACTION \
    ((KToggleAction *)actionCollection() \
	 ->action(KStdAction::stdName(KStdAction::ShowMenubar)))

#define PAUSE_ACTION \
    ((KToggleAction *)actionCollection()->action("game_pause"))

void MainWidget::readSettings()
{
	bool visible = OptionDialog::readMenuVisible();
	MENUBAR_ACTION->setChecked(visible);
	toggleMenubar();
}

void MainWidget::toggleMenubar()
{
	bool b = MENUBAR_ACTION->isChecked();
	if (b) menuBar()->show();
	else {
		menuBar()->hide();

		// #### sort of hack : because KTMainWindow does not manage correctly
		// main widget with a fixed layout
		updateRects();
		adjustSize();
	}

	OptionDialog::writeMenuVisible(b);
}

void MainWidget::print()
{
	// #### TODO
}

void MainWidget::showHighScores()
{
	HighScores hs(0, this);
	hs.exec();
}

//-----------------------------------------------------------------------------
int generic_main(int argc, char **argv, const char *name,
				 const char *trName, const char *description, bool catalog)
{
	KAboutData aboutData(name, trName, LONG_VERSION, description,
						 KAboutData::License_GPL, COPYLEFT, 0, HOMEPAGE);
	aboutData.addAuthor("Eirik Eng", "core engine");
	aboutData.addAuthor("Nicolas Hadacek", 0, "hadacek@kde.org");
	KCmdLineArgs::init(argc, argv, &aboutData);
	
	KApplication a;
	if (catalog) KGlobal::locale()->insertCatalogue("ksirtet");
	KGlobal::locale()->insertCatalogue("multiplayers");
	MainWidget *mw = new MainWidget;
	a.setMainWidget(mw);
	mw->show();
	return a.exec();
}
