/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *
 * Comment:
 * This is my first "bigger" application I did with Qt and my very first KDE application.
 * So please apologize some strange coding styles --> if you can't stand some really
 * bad parts just send me a patch including you "elegant" code ;)
 *
 * WABA: Who are you?
*/
    
#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "version.h"
#include "global.h"
#include "top.h"


static const char *description = I18N_NOOP("KDE Card Game");

KConfig *conf;

int main( int argc, char *argv[] )
{
	KAboutData aboutData( "kpoker", I18N_NOOP("KPoker"), 
		KPOKER_VERSION, description, KAboutData::License_GPL, 
		"(c) 1997-1998, Jochen Tuchbreiter");
	aboutData.addAuthor("Jochen Tuchbreiter",0, "whynot@mabi.de");
	KCmdLineArgs::init( argc, argv, &aboutData );

	KApplication myApp;
	PokerWindow *MainScreen = new PokerWindow;

	if (myApp.isRestored()) {
	  if (KTMainWindow::canBeRestored(1))
	    MainScreen->restore(1);
	}

	myApp.setMainWidget( MainScreen );
	MainScreen->show();
		  
	int ret = myApp.exec();
		  
	delete MainScreen;
	
	return ret;

}
