/*  This file is part of the KDE XmlRpc package

    Copyright (C) 1999 Kurt Granroth (granroth@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef KXMLRPCUTIL_H
#define KXMLRPCUTIL_H

#include <qstring.h>
#include <qdatetime.h>

/**
 * This is a container class for utility functions.
 *
 * @short XmlRpc Utility Functions
 * @author Kurt Granroth <granroth@kde.org>
 * @version 0.1
 */
class KXmlRpcUtil
{
public:
    /**
     * Static method for encoding Base64.  This takes a QByteArray
     * array and encodes it into a string
     */
    static bool encodeBase64(const QByteArray& _array, QString& _string);

    /**
     * Static method for decoding Base64.  This takes a Base64-encoded
     * string and decodes it into a byte array
     */
    static bool decodeBase64(const QString& _string, QByteArray& _array);

    /**
     * Static method for encoding QDateTime into an iso8601 date
     */
    static bool encodeISO8601(const QDateTime& _date, QString& _string);

    /**
     * Static method for decoding iso8601 dates into QDateTime
     */
    static bool decodeISO8601(const QString& _string, QDateTime& _date);

    /**
     * Generate a 16 byte authorization token ("cookie")
     */
    static QString generateAuthToken();
};

#endif // KXMLRPCUTIL_H

