/*
   - 

  written 1998 by Alexander Budnik <budnik@linserv.jinr.ru>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */
#ifndef KIK_OPTIONS_H
#define KIK_OPTIONS_H

#include <kapp.h>
#include "kobjconf.h"

class KiMap;

class Options: public KObjectConfig {
  Q_OBJECT
 public:
  enum {Input_Global, Input_Window, Input_Class};
  enum {Place_TopLeft, Place_TopRight, Place_BottomLeft, Place_Bottom_Right};
 protected:
  QList<KiMap> allMaps;
  QStrList        maps;
  bool            keyboardBeep, hotList, autoStart, docking;
  bool            autoMenu, emuCapsLock, custFont, saveClasses;
  int             input, autoStartPlace;
  QString         switchComb, altSwitchComb, codes;
  QColor          capsColor, altColor, foreColor, backColor;
  QFont           font;
 public:
  Options(bool readOnly = TRUE);
  ~Options(){}
  /*--- bool values ---*/
  const bool&    KeyboardBeep   () const {return keyboardBeep; }
  const bool&    AutoMenu       () const {return autoMenu;     }
  const bool&    EmuCapsLock    () const {return emuCapsLock;  }
  const bool&    CustFont       () const {return custFont;     }
  const bool&    SaveClasses    () const {return saveClasses;  }
  const bool&    AutoStart      () const {return autoStart;    }
  const bool&    Docking        () const {return docking;      }
  const bool&    HotList        () const {return hotList;      }
  const int&     Input          () const {return input;        }
  const QColor&  CapsColor      () const {return capsColor;    }
  const QColor&  AltColor       () const {return altColor;     }
  const QColor&  ForeColor      () const {return foreColor;    }
  const QColor&  BackColor      () const {return backColor;    }
  const QFont&   Font           () const {return font;         }
  const int&     AutoStartPlace () const {return autoStartPlace;}
  const QString& Codes          () const {return codes;}
  const QString& SwitchRef      () const {return switchComb;}
  const QString& AltSwitchRef   () const {return altSwitchComb;}
  QStrList Switch() const {
    return KObjectConfig::separate(switchComb, '+');
  }
  QStrList& Maps() {return maps;}
  KiMap* aMap(const char* name);
  bool            hasAltKeys();
  bool            hasCompose();
  bool            oneKeySwitch() const;
  void            setDefaults();
  virtual void loadConfig();
 public:
  enum {Config_Normal=0, Config_StartKikbd};
  static bool     readAutoStart();
  static QStrList availableMaps(const char* subdir = "");
  static void     startConfigProgram(int opt=Config_Normal);
  static bool     isConfigProgram();
 public slots:
  void newUserRc();
  void wrongVersion(int);
};
extern Options *options;

#endif
